/************************************************************************
 *                                                                      *
 * Open File Manager - ncurses file manager for GNU/Linux               *
 * (c) 2001, 2002 Slawomir Strumecki, Raphael Bugajewski                *
 *                                                                      *
 * This program is free software, you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 * If you want to contact us, please use the following address(es):     *
 *                                                                      *
 *     Raphael Bugajewski               Slawomir Strumecki              *
 *     Kl. Mittelstr. 1                 mailto: <logospam@poczta.fm>    *
 *     13585 Berlin / Germany                                           *
 *     Tel.: +49 (175) 331 93 92                                        *
 *     mailto: <born@bugajewski.de>                                     *
 *                                                                      *
 ************************************************************************/

#include "misc.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h> /* for memset */
#include "stack.h"

OSTACK *stackInit(int size)
{
    OSTACK *tmp;
    
    tmp=NULL;
    tmp=(OSTACK *)xmalloc(sizeof(OSTACK));
    if (tmp!=NULL) {
		tmp->last=0;
		tmp->size=size;
		tmp->stack=NULL;
		tmp->stack=(char **)xmalloc(size);
		if (tmp->stack==NULL) {
	    	xfree(tmp);
	    	tmp=NULL;
		} else {
			memset(tmp->stack, 0, size);	
		}
    }
    return tmp;
}


int stackPush(OSTACK* s, char *str)
{
    char *tmp;
    
    if ( (s==NULL) || (s->last>=s->size) || (str==NULL)) return -1;
    tmp=NULL;
    tmp=(char *)xmalloc(strlen(str)+1);
    strcpy(tmp,str);   
    s->stack[s->last++]=tmp;
    
    return 0;
}

char * stackPop(OSTACK *s)
{
    char *tmp;

    tmp=NULL;
    if (s!=NULL && s->stack!=NULL && s->last>0) {
		tmp=s->stack[--s->last];
		s->stack[s->last]=NULL;
	}
    return tmp;
}

int  stackFree(OSTACK *s)
{
    char *tmpch;    

    if (s==NULL) return -1;
    tmpch=NULL;
    while((tmpch=stackPop(s))!=NULL) xfree(tmpch);
    xfree(s->stack);
    s->stack=NULL;
    xfree(s);
    return 0;
}
