/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph.layout;

import java.awt.Dimension;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.debug;
import org.nongnu.multigraph.layout.Layout;
import org.nongnu.multigraph.layout.PositionableNode;
import org.nongnu.multigraph.layout.Vector2D;

public class RadialLayout<N extends PositionableNode, L>
extends Layout<N, L> {
    public RadialLayout(Graph<N, L> graph, Dimension dimension, int n) {
        super(graph, dimension, n);
    }

    @Override
    public boolean layout(float f) {
        double d = (double)Math.min(this.bound.width, this.bound.height) / 2.0;
        double d2 = Math.PI * 2 / (double)this.graph.size();
        Vector2D vector2D = new Vector2D(0.0, d);
        for (PositionableNode positionableNode : this.graph) {
            positionableNode.getPosition().setLocation(vector2D);
            vector2D.rotate(d2);
            debug.println("v: " + vector2D);
        }
        return false;
    }
}

