/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import org.nongnu.multigraph.Edge;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.debug;

public class ShortestPathFirst<N, L> {
    private HashMap<N, SPFnode<N, L>> spfnodes = new HashMap();
    private PriorityQueue<SPFnode<N, L>> q = new PriorityQueue();
    private final Graph<N, L> g;
    private N root;

    public ShortestPathFirst(Graph<N, L> graph) {
        this.g = graph;
        if (graph == null) {
            throw new IllegalArgumentException("graph must not be null");
        }
    }

    private void explore(SPFnode<N, L> sPFnode) {
        debug.printf("SPF: exploring %s\n", sPFnode);
        for (Edge<N, L> object : this.g.edges(sPFnode.n)) {
            debug.printf("SPF: relaxing %s\n", object);
            SPFnode<N, L> sPFnode2 = this.spfnodes.get(object.to());
            if (sPFnode2 == null) {
                sPFnode2 = new SPFnode<N, L>(object.to(), object, object.weight() + sPFnode.cost);
                this.spfnodes.put(sPFnode2.n, sPFnode2);
                this.q.add(sPFnode2);
                continue;
            }
            if (object.weight() + sPFnode.cost < sPFnode2.cost) {
                sPFnode2.cost = object.weight() + sPFnode.cost;
                sPFnode2.parents.clear();
                sPFnode2.parents.add(object);
                debug.printf("SPF: lower cost path found %s\n", sPFnode2);
                continue;
            }
            if (object.weight() + sPFnode.cost != sPFnode2.cost) continue;
            sPFnode2.parents.add(object);
            debug.printf("SPF: equal cost path found %s\n", sPFnode2);
        }
        if (debug.applies()) {
            debug.println("SPFnodes:");
            for (SPFnode sPFnode2 : this.spfnodes.values()) {
                debug.println("\t" + sPFnode2);
            }
        }
    }

    public void run(N n) {
        this.root = n;
        this.spfnodes.clear();
        this.q.clear();
        debug.println("SPF: initialising");
        SPFnode sPFnode = new SPFnode(n, null, 0);
        this.spfnodes.put(n, sPFnode);
        this.explore(sPFnode);
        debug.println("SPF: Search the nodes");
        while ((sPFnode = this.q.poll()) != null) {
            this.explore(sPFnode);
        }
        debug.println("SPF: done");
    }

    public List<Edge<N, L>> path(N n) {
        SPFnode<N, L> sPFnode;
        LinkedList linkedList = null;
        while ((sPFnode = this.spfnodes.get(n)) != null && sPFnode.parents.size() > 0) {
            if (linkedList == null) {
                linkedList = new LinkedList();
            }
            debug.println("in path");
            Edge edge = sPFnode.parents.getFirst();
            linkedList.addFirst(edge);
            n = edge.from();
        }
        return linkedList;
    }

    public N nexthop(N n) {
        SPFnode<N, L> sPFnode;
        N n2 = null;
        while ((sPFnode = this.spfnodes.get(n)) != null && sPFnode.parents.size() > 0) {
            n2 = n;
            n = sPFnode.parents.getFirst().from();
        }
        return n2;
    }

    public N root() {
        return this.root;
    }

    private class SPFnode<N, L>
    implements Comparable<SPFnode<N, L>> {
        final N n;
        LinkedList<Edge<N, L>> parents;
        int cost = 0;

        SPFnode(N n, Edge<N, L> edge, int n2) {
            this.n = n;
            this.parents = new LinkedList();
            if (edge != null) {
                this.parents.add(edge);
            }
            this.cost = n2;
            debug.printf("SPFnode: created %s\n", this);
        }

        @Override
        public int compareTo(SPFnode<N, L> sPFnode) {
            return this.cost - sPFnode.cost;
        }

        public String toString() {
            return "N: " + this.n + ", " + this.cost + ", Edge to parent: " + (!this.parents.isEmpty() ? this.parents.get(0) : "<none>");
        }
    }
}

