/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph.rewire;

import java.awt.Dimension;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.nongnu.multigraph.EdgeLabeler;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.debug;
import org.nongnu.multigraph.layout.PositionableNode;
import org.nongnu.multigraph.rewire.Rewire;

public class CartesianRewire<N extends PositionableNode, E>
extends Rewire<N, E> {
    private float range;
    private LinkedList<N>[][] gridindex = null;
    private final int divs = 10;
    private final int shiftx;
    private final int shifty;
    private final float divlen;
    private final int rangediv;

    public CartesianRewire(Graph<N, E> graph, EdgeLabeler<N, E> el, Dimension bound, float range) {
        super(graph, el);
        this.range = range;
        if (bound != null && range > 0.0f) {
            this.shiftx = bound.width / 2;
            this.shifty = bound.height / 2;
            this.divlen = Math.min(bound.width, bound.height) / 10;
            this.rangediv = (int)Math.ceil(range / this.divlen);
            this.gridindex = new LinkedList[(int)Math.ceil(bound.getWidth() / (double)this.divlen)][(int)Math.ceil(bound.getHeight() / (double)this.divlen)];
        } else {
            this.gridindex = new LinkedList[1][1];
            this.rangediv = 0;
            this.shifty = 0;
            this.shiftx = 0;
            this.divlen = 0.0f;
        }
    }

    public CartesianRewire(Graph<N, E> graph, EdgeLabeler<N, E> el, float range) {
        super(graph, el);
        this.range = range;
        this.rangediv = 0;
        this.shifty = 0;
        this.shiftx = 0;
        this.divlen = 0.0f;
        this.gridindex = new LinkedList[1][1];
    }

    private int _gridcalc(double pos, int shift, int alen) {
        return Math.min(alen - 1, (int)Math.floor(((double)shift + pos) / (double)this.divlen));
    }

    private int togridx(N node) {
        if (this.gridindex.length > 1) {
            return this._gridcalc(node.getPosition().x, this.shiftx, this.gridindex.length);
        }
        return 0;
    }

    private int togridy(N node) {
        if (this.gridindex[0].length > 1) {
            return this._gridcalc(node.getPosition().y, this.shifty, this.gridindex[0].length);
        }
        return 0;
    }

    private void make_grid_index() {
        for (int i = 0; i < this.gridindex.length; ++i) {
            for (int j = 0; j < this.gridindex[0].length; ++j) {
                if (this.gridindex[i][j] == null) continue;
                this.gridindex[i][j].clear();
            }
        }
        for (PositionableNode node : this.graph) {
            int y;
            int x = this.togridx(node);
            if (this.gridindex[x][y = this.togridy(node)] == null) {
                this.gridindex[x][y] = new LinkedList();
            }
            this.gridindex[x][y].add(node);
        }
    }

    private void rewire_grid() {
        for (int i = 0; i < this.gridindex.length; ++i) {
            for (int j = 0; j < this.gridindex[0].length; ++j) {
                if (this.gridindex[i][j] == null) continue;
                this.rewire_grid(i, j);
            }
        }
    }

    private void rewire_grid(int x, int y) {
        HashSet<Object> targets = new HashSet<Object>();
        if (this.gridindex[x][y] == null || this.gridindex[x][y].size() == 0) {
            return;
        }
        for (int i = Math.max(x - this.rangediv, 0); i <= x + this.rangediv && i < this.gridindex.length; ++i) {
            for (int j = Math.max(y - this.rangediv, 0); j <= y + this.rangediv && j < this.gridindex[i].length; ++j) {
                if (this.gridindex[i][j] == null) continue;
                targets.addAll(this.gridindex[i][j]);
            }
        }
        for (PositionableNode node : this.gridindex[x][y]) {
            targets.addAll(this.graph.successors(node));
        }
        if (targets.size() > 1) {
            this.rewire(this.gridindex[x][y], targets);
        }
    }

    private void rewire(LinkedList<N> check, Set<N> targets) {
        PositionableNode n1;
        while ((n1 = (PositionableNode)check.poll()) != null) {
            for (PositionableNode n2 : targets) {
                Object label;
                if (n2 == n1) continue;
                double dist = n1.getPosition().distance(n2.getPosition());
                debug.printf("Cartesian: %s -> %s = %f\n", n1, n2, dist);
                if (dist <= (double)this.range && (label = this.el.getLabel(n1, n2)) != null) {
                    if (this.graph.successors(n1).contains(n2)) continue;
                    this.graph.set(n1, n2, label);
                    continue;
                }
                this.graph.remove(n1, n2);
            }
        }
    }

    @Override
    public void rewire() {
        if (this.graph.size() < 2) {
            return;
        }
        if (this.range <= 0.0f) {
            return;
        }
        this.make_grid_index();
        if (this.graph.size() < 2) {
            return;
        }
        this.rewire_grid();
    }
}

