/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph.perturb;

import java.awt.Dimension;
import java.util.Random;
import org.nongnu.multigraph.EdgeLabeler;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.debug;
import org.nongnu.multigraph.layout.PositionableNode;
import org.nongnu.multigraph.layout.Vector2D;
import org.nongnu.multigraph.rewire.CartesianRewire;
import org.nongnu.multigraph.rewire.Rewire;

public class RandomMove<N extends PositionableNode, L>
extends Rewire<N, L> {
    private final CartesianRewire<N, L> cl;
    private final Dimension bound;
    private final float default_speed;
    private Random r = new Random();
    private float maxrange;
    private final int default_angle_dev = 75;
    private final int angle_dev;
    EdgeLabeler<N, L> probel = new EdgeLabeler<N, L>(){

        @Override
        public L getEdge(N from, N to) {
            double range = (double)RandomMove.this.maxrange - (double)RandomMove.this.maxrange * Math.abs(RandomMove.this.r.nextGaussian());
            debug.printf("moverewire: consider %s, %s\n", from, to);
            debug.printf("            range %f (out of %f)\n", range, Float.valueOf(RandomMove.this.maxrange));
            if (from.getPosition().distance(to.getPosition()) > range) {
                return null;
            }
            return RandomMove.this.el.getLabel(from, to);
        }

        @Override
        public L getLabel(N from, N to) {
            return this.getEdge((N)from, (N)to);
        }
    };

    public RandomMove(Graph<N, L> graph, EdgeLabeler<N, L> el, Dimension bound, float default_speed, float maxrange) {
        super(graph, el);
        this.maxrange = maxrange;
        this.cl = new CartesianRewire<N, L>(graph, el, bound, maxrange);
        this.bound = bound;
        this.default_speed = default_speed;
        this.angle_dev = 75;
        this.cl.rewire();
    }

    public RandomMove(Graph<N, L> graph, EdgeLabeler<N, L> el, Dimension bound, float default_speed, float maxrange, int angle_dev) {
        super(graph, el);
        this.cl = new CartesianRewire<N, L>(graph, el, bound, maxrange);
        this.bound = bound;
        this.default_speed = default_speed;
        this.angle_dev = angle_dev;
        this.cl.rewire();
    }

    private boolean clip(Vector2D pos) {
        double origx = pos.x;
        double origy = pos.y;
        pos.x = Math.min(Math.max((double)(-this.bound.width / 2), pos.x), (double)(this.bound.width / 2));
        pos.y = Math.min(Math.max((double)(-this.bound.height / 2), pos.y), (double)(this.bound.height / 2));
        return pos.x != origx || pos.y != origy;
    }

    private void move(N node) {
        Vector2D v = node.getVelocity();
        Vector2D pos = node.getPosition();
        if (v.x == 0.0 && v.y == 0.0) {
            v.setLocation(0.0, this.default_speed);
            v.rotate(360.0 * this.r.nextDouble());
        }
        pos.plus(v);
        if (this.clip(pos)) {
            v.rotate(Math.toRadians(180.0 + this.r.nextGaussian() * (double)this.angle_dev));
        }
    }

    @Override
    public void rewire() {
        for (PositionableNode node : this.graph) {
            if (!node.isMovable()) continue;
            this.move(node);
        }
        this.cl.rewire();
    }
}

