/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.stream.Stream;
import org.nongnu.multigraph.Edge;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.PluggableObservable;

public class PartitionGraph<N, E>
implements Graph<N, E>,
Observer {
    private Graph<N, E> graph;
    private int num_partitions;
    private PartitionCallbacks<N, E> cb;
    private Set<N>[] partitions;

    public PartitionGraph(PartitionCallbacks<N, E> cb) {
        this.graph = cb.create_graph();
        this.cb = cb;
        this.num_partitions = cb.num_partitions();
        this.partitions = new Set[this.num_partitions];
        for (int i = 0; i < this.partitions.length; ++i) {
            this.partitions[i] = new HashSet<N>();
        }
        this.graph.addObserver(this);
    }

    private int part_id(N node) {
        return this.cb.node2partition(node) % this.num_partitions;
    }

    private void partition_add(N node) {
        this.partitions[this.part_id(node)].add(node);
    }

    private void partition_remove(N node) {
        if (!this.graph.contains(node)) {
            this.partitions[this.part_id(node)].remove(node);
        }
    }

    public Set<N> partition(int id) {
        if (id >= this.partitions.length) {
            throw new IllegalArgumentException("Partition id out of bounds: " + id);
        }
        return Collections.unmodifiableSet(this.partitions[id]);
    }

    public int partitions() {
        return this.partitions.length;
    }

    @Override
    public boolean is_directed() {
        return this.graph.is_directed();
    }

    @Override
    public boolean is_simple() {
        return this.graph.is_simple();
    }

    @Override
    public void set(N from, N to, E label) {
        this.partition_add(from);
        this.partition_add(to);
        this.graph.set(from, to, label);
    }

    @Override
    public void set(N from, N to, E label, int weight) {
        this.partition_add(from);
        this.partition_add(to);
        this.graph.set(from, to, label, weight);
    }

    @Override
    public boolean add(N node) {
        this.partition_add(node);
        return this.graph.add(node);
    }

    @Override
    public boolean remove(N from, N to, E label) {
        boolean ret = this.graph.remove(from, to, label);
        this.partition_remove(from);
        this.partition_remove(to);
        return ret;
    }

    @Override
    public boolean remove(N from, N to) {
        boolean ret = this.graph.remove(from, to);
        this.partition_remove(from);
        this.partition_remove(to);
        return ret;
    }

    @Override
    public void clear_all_edges() {
        this.graph.clear_all_edges();
    }

    @Override
    public int edge_outdegree(N node) {
        return this.graph.edge_outdegree(node);
    }

    @Override
    public int nodal_outdegree(N node) {
        return this.graph.nodal_outdegree(node);
    }

    @Override
    public float avg_nodal_degree() {
        return this.graph.avg_nodal_degree();
    }

    @Override
    public long link_count() {
        return this.graph.link_count();
    }

    @Override
    public int max_nodal_degree() {
        return this.graph.max_nodal_degree();
    }

    @Override
    public Set<N> successors(N from) {
        return this.graph.successors(from);
    }

    @Override
    public Set<Edge<N, E>> edges(N from) {
        return this.graph.edges(from);
    }

    @Override
    public Stream<Edge<N, E>> stream(N from) {
        return this.graph.stream(from);
    }

    @Override
    public Collection<Edge<N, E>> edges(N from, N to) {
        return this.graph.edges(from, to);
    }

    @Override
    public Edge<N, E> edge(N from, N to) {
        return this.graph.edge(from, to);
    }

    @Override
    public boolean is_linked(N from, N to) {
        return this.graph.is_linked(from, to);
    }

    @Override
    public Edge<N, E> edge(N from, N to, E label) {
        return this.graph.edge(from, to, label);
    }

    @Override
    public Iterable<N> random_node_iterable() {
        return this.graph.random_node_iterable();
    }

    @Override
    public Iterable<Edge<N, E>> random_edge_iterable(N n) {
        return this.graph.random_edge_iterable(n);
    }

    @Override
    public void addObserver(Observer o) {
        this.graph.addObserver(o);
    }

    @Override
    public int countObservers() {
        return this.graph.countObservers();
    }

    @Override
    public void deleteObserver(Observer o) {
        this.graph.deleteObserver(o);
    }

    @Override
    public void deleteObservers() {
        this.graph.deleteObservers();
    }

    @Override
    public boolean hasChanged() {
        return this.graph.hasChanged();
    }

    @Override
    public void notifyObservers() {
        this.graph.notifyObservers();
    }

    @Override
    public void notifyObservers(Object arg) {
        this.graph.notifyObservers(arg);
    }

    @Override
    public void plugObservable() {
        this.graph.plugObservable();
    }

    @Override
    public void unplugObservable() {
        this.graph.unplugObservable();
    }

    @Override
    public int size() {
        return this.graph.size();
    }

    @Override
    public boolean isEmpty() {
        return this.graph.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.graph.contains(o);
    }

    @Override
    public Iterator<N> iterator() {
        return this.graph.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.graph.toArray();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return this.graph.toArray(ts);
    }

    @Override
    public boolean remove(Object o) {
        this.partition_remove(o);
        return this.graph.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> clctn) {
        return this.graph.containsAll(clctn);
    }

    @Override
    public boolean addAll(Collection<? extends N> clctn) {
        return this.graph.addAll(clctn);
    }

    @Override
    public boolean retainAll(Collection<?> clctn) {
        return this.graph.retainAll(clctn);
    }

    @Override
    public boolean removeAll(Collection<?> clctn) {
        return this.graph.removeAll(clctn);
    }

    @Override
    public void clear() {
        this.graph.clear();
    }

    @Override
    public void update(Observable o, Object o1) {
        if (o != this.graph) {
            return;
        }
        Object node = o1;
        Set<N> partition = this.partitions[this.part_id(node)];
        if (partition.contains(node) && !this.graph.contains(node)) {
            partition.remove(node);
        }
        if (!partition.contains(node) && this.graph.contains(node)) {
            partition.add(node);
        }
    }

    @Override
    public PluggableObservable edge_events() {
        return this.graph.edge_events();
    }

    public static interface PartitionCallbacks<N, E> {
        public Graph<N, E> create_graph();

        public int num_partitions();

        public int node2partition(N var1);
    }
}

