/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mib;

import java.math.BigInteger;
import java.util.HashMap;
import net.percederberg.mib.Mib;
import net.percederberg.mib.symbol.Symbol;
import net.percederberg.mib.symbol.TypeSymbol;
import net.percederberg.mib.symbol.ValueSymbol;
import net.percederberg.mib.type.Constraint;
import net.percederberg.mib.type.EnumerationType;
import net.percederberg.mib.type.IntegerType;
import net.percederberg.mib.type.NamedType;
import net.percederberg.mib.type.ObjectIdentifierType;
import net.percederberg.mib.type.SizeConstraint;
import net.percederberg.mib.type.StringType;
import net.percederberg.mib.type.Type;
import net.percederberg.mib.type.ValueConstraint;
import net.percederberg.mib.type.ValueRangeConstraint;

public class SymbolFactory {
    private Mib mib;
    private HashMap symbols = new HashMap();

    public SymbolFactory(Mib mib) {
        this.mib = mib;
    }

    public Symbol findSymbol(String name) {
        if (this.symbols.containsKey(name)) {
            return (Symbol)this.symbols.get(name);
        }
        return this.createSymbol(name);
    }

    public Symbol createSymbol(String name) {
        Symbol symbol = null;
        if (symbol == null) {
            symbol = this.createObjectIdSymbol(name);
        }
        if (symbol == null) {
            symbol = this.createSnmp1TypeSymbol(name);
        }
        if (symbol == null) {
            symbol = this.createSnmp2TypeSymbol(name);
        }
        if (symbol != null) {
            this.symbols.put(symbol.getName(), symbol);
        }
        return symbol;
    }

    private Symbol createObjectIdSymbol(String name) {
        ObjectIdentifierType type = ObjectIdentifierType.getInstance();
        if (name.equals("iso")) {
            return new ValueSymbol(name, type, 1);
        }
        if (name.equals("org")) {
            Symbol symbol = this.findSymbol("iso");
            return new ValueSymbol(name, type, symbol, 3);
        }
        if (name.equals("dod")) {
            Symbol symbol = this.findSymbol("org");
            return new ValueSymbol(name, type, symbol, 6);
        }
        if (name.equals("internet")) {
            Symbol symbol = this.findSymbol("dod");
            return new ValueSymbol(name, type, symbol, 1);
        }
        if (name.equals("directory")) {
            Symbol symbol = this.findSymbol("internet");
            return new ValueSymbol(name, type, symbol, 1);
        }
        if (name.equals("mgmt")) {
            Symbol symbol = this.findSymbol("internet");
            return new ValueSymbol(name, type, symbol, 2);
        }
        if (name.equals("mib-2")) {
            Symbol symbol = this.findSymbol("mgmt");
            return new ValueSymbol(name, type, symbol, 1);
        }
        if (name.equals("transmission")) {
            Symbol symbol = this.findSymbol("mib-2");
            return new ValueSymbol(name, type, symbol, 10);
        }
        if (name.equals("experimental")) {
            Symbol symbol = this.findSymbol("internet");
            return new ValueSymbol(name, type, symbol, 3);
        }
        if (name.equals("private")) {
            Symbol symbol = this.findSymbol("internet");
            return new ValueSymbol(name, type, symbol, 4);
        }
        if (name.equals("enterprises")) {
            Symbol symbol = this.findSymbol("private");
            return new ValueSymbol(name, type, symbol, 1);
        }
        if (name.equals("security")) {
            Symbol symbol = this.findSymbol("internet");
            return new ValueSymbol(name, type, symbol, 5);
        }
        if (name.equals("snmpV2")) {
            Symbol symbol = this.findSymbol("internet");
            return new ValueSymbol(name, type, symbol, 6);
        }
        if (name.equals("snmpDomains")) {
            Symbol symbol = this.findSymbol("snmpV2");
            return new ValueSymbol(name, type, symbol, 1);
        }
        if (name.equals("snmpProxys")) {
            Symbol symbol = this.findSymbol("snmpV2");
            return new ValueSymbol(name, type, symbol, 2);
        }
        if (name.equals("snmpModules")) {
            Symbol symbol = this.findSymbol("snmpV2");
            return new ValueSymbol(name, type, symbol, 3);
        }
        if (name.equals("zeroDotZero")) {
            ValueSymbol symbol = new ValueSymbol("zero", type, 0);
            return new ValueSymbol(name, type, symbol, 0);
        }
        return null;
    }

    private Symbol createSnmp1TypeSymbol(String name) {
        TypeSymbol symbol = new TypeSymbol(name);
        ObjectIdentifierType type = null;
        Constraint cons = null;
        if (name.equals("ObjectName")) {
            type = ObjectIdentifierType.getInstance();
            symbol.setType(type);
        } else if (name.equals("ObjectSyntax")) {
            this.mib.addWarning("choice types are not supported: " + name);
        } else if (name.equals("SimpleSyntax")) {
            this.mib.addWarning("choice types are not supported: " + name);
        } else if (name.equals("ApplicationSyntax")) {
            this.mib.addWarning("choice types are not supported: " + name);
        } else if (name.equals("NetworkAddress")) {
            this.mib.addWarning("choice types are not supported: " + name);
        } else if (name.equals("IpAddress")) {
            cons = new ValueConstraint(new Integer(4));
            cons = new SizeConstraint((ValueConstraint)cons);
            symbol.setType(new StringType((SizeConstraint)cons));
        } else if (name.equals("Counter")) {
            cons = new ValueRangeConstraint(new Long(0L), new Long(0xFFFFFFFFL));
            symbol.setType(new IntegerType((ValueRangeConstraint)cons));
        } else if (name.equals("Gauge")) {
            cons = new ValueRangeConstraint(new Long(0L), new Long(0xFFFFFFFFL));
            symbol.setType(new IntegerType((ValueRangeConstraint)cons));
        } else if (name.equals("TimeTicks")) {
            cons = new ValueRangeConstraint(new Long(0L), new Long(0xFFFFFFFFL));
            symbol.setType(new IntegerType((ValueRangeConstraint)cons));
        } else if (name.equals("Opaque")) {
            symbol.setType(new StringType());
        } else {
            return null;
        }
        return symbol;
    }

    private Symbol createSnmp2TypeSymbol(String name) {
        TypeSymbol symbol = new TypeSymbol(name);
        Type type = null;
        EnumerationType enumerationType = null;
        Constraint cons = null;
        if (name.equals("ObjectName")) {
            type = ObjectIdentifierType.getInstance();
            symbol.setType(type);
        } else if (name.equals("NotificationName")) {
            type = ObjectIdentifierType.getInstance();
            symbol.setType(type);
        } else if (name.equals("ObjectSyntax")) {
            this.mib.addWarning("choice types are not supported: " + name);
        } else if (name.equals("SimpleSyntax")) {
            this.mib.addWarning("choice types are not supported: " + name);
        } else if (name.equals("Integer32")) {
            cons = new ValueRangeConstraint(new Long(Integer.MIN_VALUE), new Long(Integer.MAX_VALUE));
            symbol.setType(new IntegerType((ValueRangeConstraint)cons));
        } else if (name.equals("ApplicationSyntax")) {
            this.mib.addWarning("choice types are not supported: " + name);
        } else if (name.equals("IpAddress")) {
            cons = new ValueConstraint(new Integer(4));
            cons = new SizeConstraint((ValueConstraint)cons);
            symbol.setType(new StringType((SizeConstraint)cons));
        } else if (name.equals("Counter32")) {
            cons = new ValueRangeConstraint(new Long(0L), new Long(0xFFFFFFFFL));
            symbol.setType(new IntegerType((ValueRangeConstraint)cons));
        } else if (name.equals("Gauge32")) {
            cons = new ValueRangeConstraint(new Long(0L), new Long(0xFFFFFFFFL));
            symbol.setType(new IntegerType((ValueRangeConstraint)cons));
        } else if (name.equals("Unsigned32")) {
            cons = new ValueRangeConstraint(new Long(0L), new Long(0xFFFFFFFFL));
            symbol.setType(new IntegerType((ValueRangeConstraint)cons));
        } else if (name.equals("TimeTicks")) {
            cons = new ValueRangeConstraint(new Long(0L), new Long(0xFFFFFFFFL));
            symbol.setType(new IntegerType((ValueRangeConstraint)cons));
        } else if (name.equals("Opaque")) {
            symbol.setType(new StringType());
        } else if (name.equals("Counter64")) {
            cons = new ValueRangeConstraint(BigInteger.ZERO, new BigInteger("18446744073709551615"));
            symbol.setType(new IntegerType((ValueRangeConstraint)cons));
        } else if (name.equals("DisplayString")) {
            cons = new ValueRangeConstraint(new Integer(0), new Integer(255));
            cons = new SizeConstraint((ValueRangeConstraint)cons);
            symbol.setType(new StringType((SizeConstraint)cons));
        } else if (name.equals("PhysAddress")) {
            cons = new ValueConstraint(new Integer(6));
            cons = new SizeConstraint((ValueConstraint)cons);
            symbol.setType(new StringType((SizeConstraint)cons));
        } else if (name.equals("TruthValue")) {
            enumerationType = new EnumerationType();
            enumerationType.addValue("true", new Integer(1));
            enumerationType.addValue("false", new Integer(2));
            symbol.setType(enumerationType);
        } else if (name.equals("TestAndIncr")) {
            cons = new ValueRangeConstraint(new Long(0L), new Long(Integer.MAX_VALUE));
            symbol.setType(new IntegerType((ValueRangeConstraint)cons));
        } else if (name.equals("AutonomousType")) {
            symbol.setType(ObjectIdentifierType.getInstance());
        } else if (name.equals("InstancePointer")) {
            symbol.setType(ObjectIdentifierType.getInstance());
        } else if (name.equals("VariablePointer")) {
            symbol.setType(ObjectIdentifierType.getInstance());
        } else if (name.equals("RowPointer")) {
            symbol.setType(ObjectIdentifierType.getInstance());
        } else if (name.equals("RowStatus")) {
            enumerationType = new EnumerationType();
            enumerationType.addValue("active", new Integer(1));
            enumerationType.addValue("notInService", new Integer(2));
            enumerationType.addValue("notReady", new Integer(3));
            enumerationType.addValue("createAndGo", new Integer(4));
            enumerationType.addValue("createAndWait", new Integer(5));
            enumerationType.addValue("destroy", new Integer(6));
            symbol.setType(enumerationType);
        } else if (name.equals("TimeStamp")) {
            type = new NamedType((TypeSymbol)this.findSymbol("TimeTicks"));
            symbol.setType(type);
        } else if (name.equals("TimeInterval")) {
            cons = new ValueRangeConstraint(new Long(0L), new Long(Integer.MAX_VALUE));
            symbol.setType(new IntegerType((ValueRangeConstraint)cons));
        } else if (name.equals("DateAndTime")) {
            cons = new ValueRangeConstraint(new Integer(8), new Integer(11));
            cons = new SizeConstraint((ValueRangeConstraint)cons);
            symbol.setType(new StringType((SizeConstraint)cons));
        } else if (name.equals("StorageType")) {
            enumerationType = new EnumerationType();
            enumerationType.addValue("other", new Integer(1));
            enumerationType.addValue("volatile", new Integer(2));
            enumerationType.addValue("nonVolatile", new Integer(3));
            enumerationType.addValue("permanent", new Integer(4));
            enumerationType.addValue("readOnly", new Integer(5));
            symbol.setType(enumerationType);
        } else if (name.equals("TDomain")) {
            symbol.setType(ObjectIdentifierType.getInstance());
        } else if (name.equals("TAddress ")) {
            cons = new ValueRangeConstraint(new Integer(1), new Integer(255));
            cons = new SizeConstraint((ValueRangeConstraint)cons);
            symbol.setType(new StringType((SizeConstraint)cons));
        } else if (name.equals("SnmpAdminString")) {
            cons = new ValueRangeConstraint(new Integer(0), new Integer(255));
            cons = new SizeConstraint((ValueRangeConstraint)cons);
            symbol.setType(new StringType((SizeConstraint)cons));
        } else {
            return null;
        }
        return symbol;
    }
}

