/*
 * @(#)CompoundType.java       1.0            6 September 1999
 *
 * This work is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * Copyright (c) 1999 Ericsson Telecom. All rights reserved.
 * Copyright (c) 2002 Per Cederberg. All rights reserved.
 */

package net.percederberg.mib.type;

import java.util.Vector;
import net.percederberg.mib.symbol.ValueSymbol;

/**
 * A class for handling composed types for symbols in the MIBs.
 *
 * @version  1.0
 * @author   Per Cederberg, per@percederberg.net
 */
public class CompoundType extends Type {

    /**
     * Contains all the symbol parts.
     */
    private Vector symbols;

    /**
     * Creates a new compound type.
     */
    public CompoundType() {
        this.symbols = new Vector();
    }

    /**
     * Adds a component to this type. The component is added last in
     * the list.
     *
     * @param  sym      a symbol component
     */
    public void addComponent(ValueSymbol sym) {
        symbols.add(sym);
    }

    /**
     * Checks if this type equals another.
     *
     * @param  obj       an object
     * @return true if the types are equal, false otherwise
     */
    public boolean equals(Object obj) {
        return this == obj;
    }

    /**
     * Returns a string description of this type.
     *
     * @return a string description of the type
     */
    public String toString() {
        return "CompoundType";
    }

    /**
     * Transfers the type information from this type to a type
     * converter object. The calling conventions declared in the
     * TypeConverter class are followed.
     *
     * @param   converter     a type converter
     */
    public void transferType(TypeConverter converter) {
        converter.createCompound(symbols);
    }

}
