/*
 * @(#)NodeConstants.java           1.2          9 August 1999
 *
 * This work is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * Copyright (c) 1999 Ericsson Telecom. All rights reserved.
 * Copyright (c) 2002 Per Cederberg. All rights reserved.
 */

package net.percederberg.mib.asn1.node;

/**
 * Interface containing all the token and production node
 * constants. These constants <strong>must</strong> be updated
 * manually when the set of tokens or productions change.
 *
 * @version  1.2
 * @author   Per Cederberg, per@percederberg.net
 */
public interface NodeConstants {

   // Token node constants (starting at 0)
   public static final int EOF = 0;
   public static final int TDOT = 8;
   public static final int TCOMMA = 9;
   public static final int TSEMI_COLON = 10;
   public static final int TLEFTPAREN = 11;
   public static final int TRIGHTPAREN = 12;
   public static final int TLEFTBRACE = 13;
   public static final int TRIGHTBRACE = 14;
   public static final int TLEFTBRACKET = 15;
   public static final int TRIGHTBRACKET = 16;
   public static final int TMINUS = 17;
   public static final int TLESSTHAN = 18;
   public static final int TBAR = 19;
   public static final int TASSIGN = 20;
   public static final int TDEFINITIONS = 21;
   public static final int TEXPLICIT = 22;
   public static final int TIMPLICIT = 23;
   public static final int TTAGS = 24;
   public static final int TBEGIN = 25;
   public static final int TEND = 26;
   public static final int TEXPORTS = 27;
   public static final int TIMPORTS = 28;
   public static final int TFROM = 29;
   public static final int TMACRO = 30;
   public static final int TINTEGER = 31;
   public static final int TREAL = 32;
   public static final int TBOOLEAN = 33;
   public static final int TNULL = 34;
   public static final int TBIT = 35;
   public static final int TOCTET = 36;
   public static final int TSTRING = 37;
   public static final int TENUMERATED = 38;
   public static final int TSEQUENCE = 39;
   public static final int TSET = 40;
   public static final int TOF = 41;
   public static final int TCHOICE = 42;
   public static final int TUNIVERSAL = 43;
   public static final int TAPPLICATION = 44;
   public static final int TPRIVATE = 45;
   public static final int TANY = 46;
   public static final int TDEFINED = 47;
   public static final int TBY = 48;
   public static final int TOBJECT = 49;
   public static final int TIDENTIFIER = 50;
   public static final int TINCLUDES = 51;
   public static final int TMIN = 52;
   public static final int TMAX = 53;
   public static final int TSIZE = 54;
   public static final int TWITH = 55;
   public static final int TCOMPONENT = 56;
   public static final int TCOMPONENTS = 57;
   public static final int TPRESENT = 58;
   public static final int TABSENT = 59;
   public static final int TOPTIONAL = 60;
   public static final int TDEFAULT = 61;
   public static final int TTRUE = 62;
   public static final int TFALSE = 63;
   public static final int TPLUS_INFINITY = 64;
   public static final int TMINUS_INFINITY = 65;
   public static final int TOBJECT_TYPE = 66;
   public static final int TTRAP_TYPE = 67;
   public static final int TSYNTAX = 68;
   public static final int TACCESS = 69;
   public static final int TSTATUS = 70;
   public static final int TDESCRIPTION = 71;
   public static final int TREFERENCE = 72;
   public static final int TINDEX = 73;
   public static final int TDEFVAL = 74;
   public static final int TENTERPRISE = 75;
   public static final int TVARIABLES = 76;
   public static final int TBINSTRING = 77;
   public static final int THEXSTRING = 78;
   public static final int TCSTRING = 79;
   public static final int TUCASEFIRST_IDENT = 80;
   public static final int TLCASEFIRST_IDENT = 81;
   public static final int TNUMBER = 82;

   // Production node constants (starting at 100)
   public static final int START = 100;
   public static final int MODULEDEFINITION = 101;
   public static final int TAGDEFAULT = 102;
   public static final int MODULEIDENTIFIER = 103;
   public static final int MODULEBODY = 104;
   public static final int EXPORTS = 105;
   public static final int IMPORTS = 106;
   public static final int SYMBOLSFROMMODULELIST = 107;
   public static final int SYMBOLSFROMMODULE = 108;
   public static final int SYMBOLLIST = 109;
   public static final int SYMBOL = 110;
   public static final int ASSIGNMENTLIST = 111;
   public static final int ASSIGNMENT = 112;
   public static final int MACRODEFINITION = 113;
   public static final int MACROBODY = 114;
   public static final int SKIPTOEND = 115;
   public static final int MACROREFERENCE = 116;
   public static final int TYPEASSIGNMENT = 117;
   public static final int TYPE = 118;
   public static final int BUILTINTYPE = 119;
   public static final int INTEGERTYPE = 120;
   public static final int NAMEDNUMBERLIST = 121;
   public static final int NAMEDNUMBER = 122;
   public static final int SIGNEDNUMBER = 123;
   public static final int STRINGTYPE = 124;
   public static final int BITSTRINGTYPE = 125;
   public static final int SEQUENCETYPE = 126;
   public static final int SEQUENCEOFTYPE = 127;
   public static final int SETTYPE = 128;
   public static final int SETOFTYPE = 129;
   public static final int ELEMENTTYPELIST = 130;
   public static final int ELEMENTTYPE = 131;
   public static final int NAMEDTYPE = 132;
   public static final int CHOICETYPE = 133;
   public static final int ENUMERATEDTYPE = 134;
   public static final int SELECTIONTYPE = 135;
   public static final int TAGGEDTYPE = 136;
   public static final int TAG = 137;
   public static final int CLASSNUMBER = 138;
   public static final int CLASS = 139;
   public static final int ANYTYPE = 140;
   public static final int DEFINEDTYPE = 141;
   public static final int CONSTRAINTLIST = 142;
   public static final int CONSTRAINT = 143;
   public static final int VALUECONSTRAINT = 144;
   public static final int VALUERANGE = 145;
   public static final int LOWERENDPOINT = 146;
   public static final int UPPERENDPOINT = 147;
   public static final int SIZECONSTRAINT = 148;
   public static final int ALPHABETCONSTRAINT = 149;
   public static final int VALUEASSIGNMENT = 150;
   public static final int VALUE = 151;
   public static final int DEFINEDVALUE = 152;
   public static final int BUILTINVALUE = 153;
   public static final int BOOLEANVALUE = 154;
   public static final int SPECIALREALVALUE = 155;
   public static final int NULLVALUE = 156;
   public static final int NAMEDVALUE = 157;
   public static final int OBJECTIDENTIFIERVALUE = 158;
   public static final int OBJIDCOMPONENTLIST = 159;
   public static final int OBJIDCOMPONENT = 160;
   public static final int NAMEANDNUMBERFORM = 161;
   public static final int BINARYSTRING = 162;
   public static final int HEXSTRING = 163;
   public static final int CHARSTRING = 164;
   public static final int NUMBER = 165;
   public static final int IDENTIFIER = 166;
   public static final int MODULEREFERENCE = 167;
   public static final int TYPEREFERENCE = 168;
   public static final int DEFINEDMACROTYPE = 169;
   public static final int DEFINEDMACRONAME = 170;
   public static final int SNMPOBJECTTYPEMACROTYPE = 171;
   public static final int SNMPTRAPTYPEMACROTYPE = 172;
   public static final int SNMPACCESSPART = 173;
   public static final int SNMPSTATUSPART = 174;
   public static final int SNMPDESCRPART = 175;
   public static final int SNMPREFERPART = 176;
   public static final int SNMPINDEXPART = 177;
   public static final int TYPEORVALUELIST = 178;
   public static final int TYPEORVALUE = 179;
   public static final int SNMPDEFVALPART = 180;
   public static final int SNMPVARPART = 181;
   public static final int VARTYPES = 182;

   /**
    * A list with all the node names for token nodes.
    */
   public static final String[] tokenNodeName = {
      "EOF",
      null,
      null,
      null,
      null,
      null,
      null,
      null,
      "TDOT",
      "TCOMMA",
      "TSEMI_COLON",
      "TLEFTPAREN",
      "TRIGHTPAREN",
      "TLEFTBRACE",
      "TRIGHTBRACE",
      "TLEFTBRACKET",
      "TRIGHTBRACKET",
      "TMINUS",
      "TLESSTHAN",
      "TBAR",
      "TASSIGN",
      "TDEFINITIONS",
      "TEXPLICIT",
      "TIMPLICIT",
      "TTAGS",
      "TBEGIN",
      "TEND",
      "TEXPORTS",
      "TIMPORTS",
      "TFROM",
      "TMACRO",
      "TINTEGER",
      "TREAL",
      "TBOOLEAN",
      "TNULL",
      "TBIT",
      "TOCTET",
      "TSTRING",
      "TENUMERATED",
      "TSEQUENCE",
      "TSET",
      "TOF",
      "TCHOICE",
      "TUNIVERSAL",
      "TAPPLICATION",
      "TPRIVATE",
      "TANY",
      "TDEFINED",
      "TBY",
      "TOBJECT",
      "TIDENTIFIER",
      "TINCLUDES",
      "TMIN",
      "TMAX",
      "TSIZE",
      "TWITH",
      "TCOMPONENT",
      "TCOMPONENTS",
      "TPRESENT",
      "TABSENT",
      "TOPTIONAL",
      "TDEFAULT",
      "TTRUE",
      "TFALSE",
      "TPLUS_INFINITY",
      "TMINUS_INFINITY",
      "TOBJECT_TYPE",
      "TTRAP_TYPE",
      "TSYNTAX",
      "TACCESS",
      "TSTATUS",
      "TDESCRIPTION",
      "TREFERENCE",
      "TINDEX",
      "TDEFVAL",
      "TENTERPRISE",
      "TVARIABLES",
      "TBINSTRING",
      "THEXSTRING",
      "TCSTRING",
      "TUCASEFIRST_IDENT",
      "TLCASEFIRST_IDENT",
      "TNUMBER",
   };

   /**
    * A list with all the node names for production nodes.
    */
   public static final String[] productionNodeName = {
      "Start",
      "ModuleDefinition",
      "TagDefault",
      "ModuleIdentifier",
      "ModuleBody",
      "Exports",
      "Imports",
      "SymbolsFromModuleList",
      "SymbolsFromModule",
      "SymbolList",
      "Symbol",
      "AssignmentList",
      "Assignment",
      "MacroDefinition",
      "MacroBody",
      "SkipToEND",
      "MacroReference",
      "TypeAssignment",
      "Type",
      "BuiltinType",
      "IntegerType",
      "NamedNumberList",
      "NamedNumber",
      "SignedNumber",
      "StringType",
      "BitStringType",
      "SequenceType",
      "SequenceOfType",
      "SetType",
      "SetOfType",
      "ElementTypeList",
      "ElementType",
      "NamedType",
      "ChoiceType",
      "EnumeratedType",
      "SelectionType",
      "TaggedType",
      "Tag",
      "ClassNumber",
      "Class",
      "AnyType",
      "DefinedType",
      "ConstraintList",
      "Constraint",
      "ValueConstraint",
      "ValueRange",
      "LowerEndPoint",
      "UpperEndPoint",
      "SizeConstraint",
      "AlphabetConstraint",
      "ValueAssignment",
      "Value",
      "DefinedValue",
      "BuiltinValue",
      "BooleanValue",
      "SpecialRealValue",
      "NullValue",
      "NamedValue",
      "ObjectIdentifierValue",
      "ObjIdComponentList",
      "ObjIdComponent",
      "NameAndNumberForm",
      "BinaryString",
      "HexString",
      "CharString",
      "Number",
      "Identifier",
      "ModuleReference",
      "TypeReference",
      "DefinedMacroType",
      "DefinedMacroName",
      "SnmpObjectTypeMacroType",
      "SnmpTrapTypeMacroType",
      "SnmpAccessPart",
      "SnmpStatusPart",
      "SnmpDescrPart",
      "SnmpReferPart",
      "SnmpIndexPart",
      "TypeOrValueList",
      "TypeOrValue",
      "SnmpDefValPart",
      "SnmpVarPart",
      "VarTypes",
   };
}
