/*
 * @(#)SwitchAdapter.java         1.2            9 August 1999
 *
 * This work is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * Copyright (c) 1999 Ericsson Telecom. All rights reserved.
 * Copyright (c) 2002 Per Cederberg. All rights reserved.
 */

package net.percederberg.mib.asn1.analysis;

import net.percederberg.mib.asn1.node.Node;

/**
 * This class provides a default implementation of the Switch interface.
 * By default all caseXXX methods call the defaultCase method, which is
 * empty. This class should be subclassed and the appropriate methods
 * overridden for handling various types of parse tree analysis.
 *
 * @version  1.2
 * @author   Per Cederberg, per@percederberg.nett
 */
public class SwitchAdapter implements Switch {

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseStart(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseModuleDefinition(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseTagDefault(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseModuleIdentifier(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseModuleBody(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseExports(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseImports(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseSymbolsFromModuleList(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseSymbolsFromModule(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseSymbolList(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseSymbol(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseAssignmentList(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseAssignment(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseMacroDefinition(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseMacroBody(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseSkipToEND(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseMacroReference(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseTypeAssignment(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseType(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseBuiltinType(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseIntegerType(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseNamedNumberList(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseNamedNumber(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseSignedNumber(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseStringType(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseBitStringType(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseSequenceType(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseSequenceOfType(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseSetType(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseSetOfType(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseElementTypeList(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseElementType(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseNamedType(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseChoiceType(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseEnumeratedType(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseSelectionType(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseTaggedType(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseTag(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseClassNumber(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseClass(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseAnyType(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseDefinedType(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseConstraintList(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseConstraint(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseValueConstraint(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseValueRange(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseLowerEndPoint(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseUpperEndPoint(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseSizeConstraint(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseAlphabetConstraint(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseValueAssignment(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseValue(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseDefinedValue(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseBuiltinValue(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseBooleanValue(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseSpecialRealValue(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseNullValue(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseNamedValue(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseObjectIdentifierValue(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseObjIdComponentList(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseObjIdComponent(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseNameAndNumberForm(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseBinaryString(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseHexString(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseCharString(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseNumber(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseIdentifier(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseModuleReference(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseTypeReference(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseDefinedMacroType(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseDefinedMacroName(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseSnmpObjectTypeMacroType(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseSnmpTrapTypeMacroType(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseSnmpAccessPart(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseSnmpStatusPart(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseSnmpDescrPart(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseSnmpReferPart(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseSnmpIndexPart(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseTypeOrValueList(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseTypeOrValue(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseSnmpDefValPart(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseSnmpVarPart(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseVarTypes(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseEOF(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseTDOT(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTCOMMA(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTSEMI_COLON(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTLEFTPAREN(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTRIGHTPAREN(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTLEFTBRACE(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTRIGHTBRACE(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTLEFTBRACKET(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTRIGHTBRACKET(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTMINUS(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTLESSTHAN(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTBAR(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTASSIGN(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTDEFINITIONS(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTEXPLICIT(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTIMPLICIT(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTTAGS(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTBEGIN(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTEND(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTEXPORTS(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTIMPORTS(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTFROM(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTMACRO(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTINTEGER(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTREAL(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTBOOLEAN(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTNULL(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTBIT(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTOCTET(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTSTRING(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTENUMERATED(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTSEQUENCE(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTSET(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTOF(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTCHOICE(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTUNIVERSAL(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTAPPLICATION(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTPRIVATE(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTANY(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTDEFINED(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTBY(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTOBJECT(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTIDENTIFIER(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTINCLUDES(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTMIN(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTMAX(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTSIZE(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTWITH(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTCOMPONENT(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTCOMPONENTS(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTPRESENT(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTABSENT(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTOPTIONAL(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTDEFAULT(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTTRUE(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTFALSE(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTPLUS_INFINITY(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTMINUS_INFINITY(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTOBJECT_TYPE(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseTTRAP_TYPE(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseTSYNTAX(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseTACCESS(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseTSTATUS(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseTDESCRIPTION(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseTREFERENCE(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseTINDEX(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseTDEFVAL(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseTENTERPRISE(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method.
    *
    * @param node   a parse tree node
    */
   public void caseTVARIABLES(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTBINSTRING(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTHEXSTRING(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTCSTRING(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTUCASEFIRST_IDENT(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTLCASEFIRST_IDENT(Node node) {
      defaultCase(node);
   }

   /**
    * Called upon switching this node type. By default calls the
    * defaultCase method. 
    *
    * @param node   a parse tree node
    */
   public void caseTNUMBER(Node node) {
      defaultCase(node);
   }

   /**
    * A default method called from all caseXXX methods. Override this method
    * in a subclass to handle the default case.
    *
    * @param  node   a parse tree node
    */
   protected void defaultCase(Node node) {
   }
}
