/*
 * @(#)Switch.java               1.2               9 August 1999
 *
 * This work is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * Copyright (c) 1999 Ericsson Telecom. All rights reserved.
 * Copyright (c) 2002 Per Cederberg. All rights reserved.
 */

package net.percederberg.mib.asn1.analysis;

import net.percederberg.mib.asn1.node.Node;

/**
 * This interface specifies methods being called upon switching from
 * the nodes. See the visitor (or switch) design pattern for
 * information on how this works.
 *
 * @version  1.2
 * @author   Per Cederberg, per@percederberg.net
 */
public interface Switch {
   // Production node cases
   public void caseStart(Node node);
   public void caseModuleDefinition(Node node);
   public void caseTagDefault(Node node);
   public void caseModuleIdentifier(Node node);
   public void caseModuleBody(Node node);
   public void caseExports(Node node);
   public void caseImports(Node node);
   public void caseSymbolsFromModuleList(Node node);
   public void caseSymbolsFromModule(Node node);
   public void caseSymbolList(Node node);
   public void caseSymbol(Node node);
   public void caseAssignmentList(Node node);
   public void caseAssignment(Node node);
   public void caseMacroDefinition(Node node);
   public void caseMacroBody(Node node);
   public void caseSkipToEND(Node node);
   public void caseMacroReference(Node node);
   public void caseTypeAssignment(Node node);
   public void caseType(Node node);
   public void caseBuiltinType(Node node);
   public void caseIntegerType(Node node);
   public void caseNamedNumberList(Node node);
   public void caseNamedNumber(Node node);
   public void caseSignedNumber(Node node);
   public void caseStringType(Node node);
   public void caseBitStringType(Node node);
   public void caseSequenceType(Node node);
   public void caseSequenceOfType(Node node);
   public void caseSetType(Node node);
   public void caseSetOfType(Node node);
   public void caseElementTypeList(Node node);
   public void caseElementType(Node node);
   public void caseNamedType(Node node);
   public void caseChoiceType(Node node);
   public void caseEnumeratedType(Node node);
   public void caseSelectionType(Node node);
   public void caseTaggedType(Node node);
   public void caseTag(Node node);
   public void caseClassNumber(Node node);
   public void caseClass(Node node);
   public void caseAnyType(Node node);
   public void caseDefinedType(Node node);
   public void caseConstraintList(Node node);
   public void caseConstraint(Node node);
   public void caseValueConstraint(Node node);
   public void caseValueRange(Node node);
   public void caseLowerEndPoint(Node node);
   public void caseUpperEndPoint(Node node);
   public void caseSizeConstraint(Node node);
   public void caseAlphabetConstraint(Node node);
   public void caseValueAssignment(Node node);
   public void caseValue(Node node);
   public void caseDefinedValue(Node node);
   public void caseBuiltinValue(Node node);
   public void caseBooleanValue(Node node);
   public void caseSpecialRealValue(Node node);
   public void caseNullValue(Node node);
   public void caseNamedValue(Node node);
   public void caseObjectIdentifierValue(Node node);
   public void caseObjIdComponentList(Node node);
   public void caseObjIdComponent(Node node);
   public void caseNameAndNumberForm(Node node);
   public void caseBinaryString(Node node);
   public void caseHexString(Node node);
   public void caseCharString(Node node);
   public void caseNumber(Node node);
   public void caseIdentifier(Node node);
   public void caseModuleReference(Node node);
   public void caseTypeReference(Node node);
   public void caseDefinedMacroType(Node node);
   public void caseDefinedMacroName(Node node);
   public void caseSnmpObjectTypeMacroType(Node node);
   public void caseSnmpTrapTypeMacroType(Node node);
   public void caseSnmpAccessPart(Node node);
   public void caseSnmpStatusPart(Node node);
   public void caseSnmpDescrPart(Node node);
   public void caseSnmpReferPart(Node node);
   public void caseSnmpIndexPart(Node node);
   public void caseTypeOrValueList(Node node);
   public void caseTypeOrValue(Node node);
   public void caseSnmpDefValPart(Node node);
   public void caseSnmpVarPart(Node node);
   public void caseVarTypes(Node node);

   // Token node cases
   public void caseEOF(Node node);
   public void caseTDOT(Node node);
   public void caseTCOMMA(Node node);
   public void caseTSEMI_COLON(Node node);
   public void caseTLEFTPAREN(Node node);
   public void caseTRIGHTPAREN(Node node);
   public void caseTLEFTBRACE(Node node);
   public void caseTRIGHTBRACE(Node node);
   public void caseTLEFTBRACKET(Node node);
   public void caseTRIGHTBRACKET(Node node);
   public void caseTMINUS(Node node);
   public void caseTLESSTHAN(Node node);
   public void caseTBAR(Node node);
   public void caseTASSIGN(Node node);
   public void caseTDEFINITIONS(Node node);
   public void caseTEXPLICIT(Node node);
   public void caseTIMPLICIT(Node node);
   public void caseTTAGS(Node node);
   public void caseTBEGIN(Node node);
   public void caseTEND(Node node);
   public void caseTEXPORTS(Node node);
   public void caseTIMPORTS(Node node);
   public void caseTFROM(Node node);
   public void caseTMACRO(Node node);
   public void caseTINTEGER(Node node);
   public void caseTREAL(Node node);
   public void caseTBOOLEAN(Node node);
   public void caseTNULL(Node node);
   public void caseTBIT(Node node);
   public void caseTOCTET(Node node);
   public void caseTSTRING(Node node);
   public void caseTENUMERATED(Node node);
   public void caseTSEQUENCE(Node node);
   public void caseTSET(Node node);
   public void caseTOF(Node node);
   public void caseTCHOICE(Node node);
   public void caseTUNIVERSAL(Node node);
   public void caseTAPPLICATION(Node node);
   public void caseTPRIVATE(Node node);
   public void caseTANY(Node node);
   public void caseTDEFINED(Node node);
   public void caseTBY(Node node);
   public void caseTOBJECT(Node node);
   public void caseTIDENTIFIER(Node node);
   public void caseTINCLUDES(Node node);
   public void caseTMIN(Node node);
   public void caseTMAX(Node node);
   public void caseTSIZE(Node node);
   public void caseTWITH(Node node);
   public void caseTCOMPONENT(Node node);
   public void caseTCOMPONENTS(Node node);
   public void caseTPRESENT(Node node);
   public void caseTABSENT(Node node);
   public void caseTOPTIONAL(Node node);
   public void caseTDEFAULT(Node node);
   public void caseTTRUE(Node node);
   public void caseTFALSE(Node node);
   public void caseTPLUS_INFINITY(Node node);
   public void caseTMINUS_INFINITY(Node node);
   public void caseTOBJECT_TYPE(Node node);
   public void caseTTRAP_TYPE(Node node);
   public void caseTSYNTAX(Node node);
   public void caseTACCESS(Node node);
   public void caseTSTATUS(Node node);
   public void caseTDESCRIPTION(Node node);
   public void caseTREFERENCE(Node node);
   public void caseTINDEX(Node node);
   public void caseTDEFVAL(Node node);
   public void caseTENTERPRISE(Node node);
   public void caseTVARIABLES(Node node);
   public void caseTBINSTRING(Node node);
   public void caseTHEXSTRING(Node node);
   public void caseTCSTRING(Node node);
   public void caseTUCASEFIRST_IDENT(Node node);
   public void caseTLCASEFIRST_IDENT(Node node);
   public void caseTNUMBER(Node node);
}
