<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009,2010 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
echo '
*****************
** LARUS BOARD **
*****************
';
set_time_limit(0);
chdir(dirname(__FILE__));
$private_root = realpath(dirname(__FILE__).'/../lb_private');
$cli_cfg_file = dirname(__FILE__).'/cli_helper.ini';
$help_text = array('en'=>'
This command line tool will help you to convert existing board software
to Larus Board, if the web-based interface causes a timeout or is
expected to be very costly.

Usage:
'.basename(__FILE__).' [FUNCTION] [ROOT-PRIVATE] [CLI-HELPER-CONFIGURATION]

FUNCTION describes toe operation you want to perform. "convert" is default.

ROOT-PRIVATE is your "lb_private" folder. This contains the software
files. If you leave it blank, we try to auto-detect it.

CONFIGURATION is the path to this program`s configuration file. Usually
it resides in the same folder as '.basename(__FILE__).'. Leaving it blank
enables auto-detection again.
',
'de'=>'
Dieses Kommandozeilenwerzeug hilft bei der Konvertierung bestehender
Forumsoftware zum Larus Board, wenn die Webgestützte Version im Browser
mit Timeout abbricht oder absehbar aufwendig ist.

Benutzung:
'.basename(__FILE__).' [FUNKTION] [WURZEL-PRIVAT] [CLI-HELPER-KONFIGURATION]

FUNKTION beschreibt, was du möchtest. "convert" startet den Konverter.

WURZEL-PRIVAT ist der Ordner "lb_private". Dort liegen die Programm-
dateien. Bleibt der Parameter leer, wird versucht dies automatisch
zu erkennen.

KONFIGURATION ist der Pfad zur Konfigurationsdatei dieses Programms.
Üblicherweise liegt sie im gleichen Ordner wie '.basename(__FILE__).'.
Ein Auslassen führt ebenfalls zur automatischen Erkennung.
');
  if ( isset($_ENV['LANG']) )
  $lang = substr($_ENV['LANG'],0,2);
  elseif ( isset($_ENV['LANGUAGE']) )
  $lang = substr($_ENV['LANGUAGE'],0,2);
  else
  $lang = 'en';

  if ( !in_array(strtolower($lang),array('en','de'),true) )
  $lang = 'en';

  if ( $argc < 2 || in_array($argv[1],array('--help','-help','-h','-?'),true) )
  die($help_text[$lang]);
  if ( isset($argv[2]) && file_exists($argv[2].'/class.root.php') )
  $private_root = $argv[2];
  if ( isset($argv[3]) && file_exists($argv[3]) && basename($argv[3]) === 'cli_helper.ini' )
  $cli_cfg_file = $argv[3];

$cli_cfg_file = parse_ini_file($cli_cfg_file,true);

// ====================================================================

$_GET['step'] = 7;
$a = parse_url($_SESSION['xf_setup']['uri']);
$_SESSION['xf_setup']['lang'] = $lang;
$_SESSION['xf_setup']['path'] = $private_root;
$_SESSION['xf_setup']['uri'] = $cli_cfg_file['db-target']['rooturi'];
$_SESSION['xf_setup']['__restore'] = array(
'sfs'=>$cli_cfg_file['db-source']['class'],
'dbs_type'=>$cli_cfg_file['db-source']['engine'],
'dbs_host'=>$cli_cfg_file['db-source']['hostname'],
'dbs_username'=>$cli_cfg_file['db-source']['username'],
'dbs_password'=>$cli_cfg_file['db-source']['password'],
'dbs_name'=>$cli_cfg_file['db-source']['database'],
'dbs_prefix'=>$cli_cfg_file['db-source']['prefix'],
'dbt_type'=>$cli_cfg_file['db-target']['engine'],
'dbt_host'=>$cli_cfg_file['db-target']['hostname'],
'dbt_username'=>$cli_cfg_file['db-target']['username'],
'dbt_password'=>$cli_cfg_file['db-target']['password'],
'dbt_name'=>$cli_cfg_file['db-target']['database'],
'dbt_prefix'=>$cli_cfg_file['db-target']['prefix'],
'guest_uid'=>$cli_cfg_file['db-source']['guest']
);
$_SERVER['REQUEST_METHOD'] = 'GET';
$_SERVER['SERVER_NAME'] = 'localhost.localdomain';
$_SERVER['REMOTE_ADDR'] = '127.0.0.1';
$_SERVER['HTTP_HOST'] = ( isset($a['host']) ) ? $a['host'] : 'localhost.localdomain';

  switch ( $argv[1] ){
  default:
  ob_start();
  define('__XF_MINIMAL',true);
  require_once('index.php');
  break;
  }

echo chr(10);
?>