<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<script type="text/javascript" src="js/calendar.js"></script>
<script type="text/javascript" src="<?php echo $languagePath;?>calendar/calendar-lang.js"></script>
<script type="text/javascript" src="js/calendar-setup.js"></script>

<div class="col_main">
	<?php
	if (isset($schedule)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php 
				if (isset($schedule['schedule_type_id']) && $schedule['schedule_type_id'] == 2) { //task
					echo $lang['hdr_schedule_task'];
				}
				elseif (isset($schedule['schedule_type_id'])) { //event
					echo $lang['hdr_schedule_event'];
				}
			?>
			<br />
		</div>
		
		<div class="box_mid">
			<div class="content">
					<p class="txt_item_title">
						<?php echo $schedule['schedule_title'];?><br />
					</p>
					
					<p>
						<?php echo $lang['txt_start'];?>:
						<?php 
						if (!empty($schedule['schedule_start_datetime'])) {
							echo $this->date->formatDate($schedule['schedule_start_datetime'], 1);
							
							if (!empty($schedule['schedule_all_day_item'])) {
								echo " (" .$lang['txt_all_day_item'] . ")";
							}
						}
						else {
							echo $lang['txt_no_start'];
						}
						?>&nbsp;
						
						<?php echo $lang['txt_end'];?>: 
						<?php 
						if (!empty($schedule['schedule_end_datetime'])) {
							echo $this->date->formatDate($schedule['schedule_end_datetime'], 1);
							
							if (!empty($schedule['schedule_all_day_item'])) {
								echo " (" .$lang['txt_all_day_item'] . ")";
							}
						}
						else {
							echo $lang['txt_no_end'];
						}
						?>
						<br />
						
						<?php echo $lang['txt_location'];?>: 
						<?php echo $schedule['schedule_location'];?>
						&nbsp;
						
						<?php echo $lang['txt_status'];?>: 
						<?php 
						if (isset($schedule['status_id'])) {
							echo $lang['schedule']['arr_event_status'][$schedule['status_id']];
						}?><br />
						
						
						<?php
						if (isset($schedule['schedule_type_id']) && $schedule['schedule_type_id'] == 2) { //task
						if (!empty($schedule['schedule_priority'])) {
						?>
							<?php echo $lang['txt_priority'];?>: 
							<?php echo $lang['schedule']['arr_priority'][$schedule['schedule_priority']];?>, 
						<?php }?>
							<?php echo $lang['txt_p_complete'];?>: 
						<?php 
							if (!empty($schedule['schedule_complete'])) { //task
								echo $lang['txt_complete'] . "<br />";
							}
							else {
								echo $schedule['schedule_p_complete'] . "<br />";
							}
						}
						?>
					</p>
					<hr />
					
					
					<p>
					<?php echo $schedule['schedule_body'];?><br />
					</p>
				
					<div class="metadata">
					<?php
					if (isset($author)) {
					?>
						<p>
							<b><?php echo $lang['txt_author'];?></b> -&#62; 
							<?php echo $lang['txt_profile_nic'];?>: 
							<a href="sn_profile.php?user_id=<?php echo $author['user_id'];?>"><?php echo $author['profile_nic'];?></a>, 
							<?php echo $lang['txt_profile_session_status'];?>: 
							<?php
							if ($author['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b>";
							}
							else {
									echo $lang['arr_user_online_status'][$author['online_status']];
							}
							?>, 
							<?php echo $lang['txt_hometown'];?>: 
							<?php echo $author['profile_hometown'];?>, 
							<?php echo $lang['txt_joined'];?>: 
							<?php echo $this->date->formatDate($author['profile_create_datetime']);?>
							<br />
						</p>
						
						<p>
							<b><?php echo $lang['hdr_schedule_item'];?></b> -&#62; 
							<?php
							if (!empty($schedule['bookmark'])) {
								echo $lang['txt_bookmarks'] . ": ";
								
								if (!empty($schedule['bookmark']['watch'])) {
									echo $lang['txt_marked'];
								}
				
								if (!empty($schedule['bookmark']['recommend'])) {
									echo $lang['txt_tipped'];
								}
								echo ", ";
							}
							?>
							<?php echo $lang['txt_published_to'];?>: 
							<?php
							if (isset($schedule['rsp'])) {
								foreach($schedule['rsp'] as $key => $i):
									
									echo trim($lang['rsp']['rsp_level'][$i['level_id']] . " " . $i['degree_id']);
									echo " (" .$lang['rsp']['status'][$i['status_id']] . ")";
									if ($key+1 < count($schedule['rsp'])) {
										echo ", ";
									}
									
								endforeach;
							}
							?>
							<br />
						</p>
					<?php }?>
				</div>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_comments'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
					//comments
					if (isset($me['user_id']) && $schedule['user_id'] == $me['user_id']) {
						$unlocked = 1;
					}
						
					if (!empty($schedule['schedule_allow_comments'])) {
						$unlocked = 1;
					}
						
					$hidden_form = array(
						"schedule_id" => $schedule['schedule_id']
					);
					
					if (isset($_REQUEST['user_id'])) {
						$hidden_form['user_id'] = $_REQUEST['user_id'];
					}
					
					include $templatePath . "comment.inc.tpl.php";
				?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php 
	}
	else {
	?>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_schedule_items'];?>
			<br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($schedule_items)) {
				?>
					<p>
						<b><?php echo $lang['hdr_tasks'];?></b><br />
					</p>
					
					<table width="100%" cellpadding="4" cellspacing="0" border="0">
						<?php
						$display_items = trimArray($schedule_items);
						foreach($display_items as $key => $i):
						if (isset($i['schedule_type_id']) && $i['schedule_type_id'] == 2) { //task
						?>
						<tr>
							<td valign="top">
								<a href="sch_view.php?schedule_id=<?php echo $i['schedule_id']?>"><?php echo $i['schedule_title'];?></a><br />
								<?php echo $i['schedule_synopsis'];?><br />
							</td>
							<td align="right" valign="top" nowrap>
								<?php
								if (!empty($i['schedule_occurence'])) {
									if ($i['schedule_occurence'] == $schedule_config['occurrence']['daily']) {
										echo $lang['schedule']['occurrence'][1] . ": " . $this->date->formatDate($i['schedule_start_datetime'], 3);
									}
									elseif ($i['schedule_occurence'] == $schedule_config['occurrence']['weekly']) {
										echo $lang['schedule']['occurrence'][3] . ": " . $this->date->formatDate($i['schedule_start_datetime'], 4);
									}
									elseif ($i['schedule_occurence'] == $schedule_config['occurrence']['monthly']) {
										echo $lang['schedule']['occurrence'][9] . ": " . $this->date->formatDate($i['schedule_start_datetime'], 5);
									}
									elseif ($i['schedule_occurence'] == $schedule_config['occurrence']['yearly']) {
										echo $lang['schedule']['occurrence'][12] . ": " . $this->date->formatDate($i['schedule_start_datetime'], 5);
									}
								}
								else { //no repeat
									echo $i['display_schedule_start_datetime'];
								}
								?>
								<br />
								<?php
								if (isset($i['schedule_allocation'])) {
									echo $lang['txt_allocation'] . ": " . $i['schedule_allocation'] . "<br />";
								}
								?>
							</td>
						</tr>
						<?php
						}
						endforeach;
						?>
					</table>
					
					<p>
						<b><?php echo $lang['hdr_events'];?></b><br />
					</p>
					
					<table width="100%" cellpadding="4" cellspacing="0" border="0">
						<?php
						foreach($display_items as $key => $i):
						if (isset($i['schedule_type_id']) && $i['schedule_type_id'] == 1) { //event
						?>
						<tr>
							<td valign="top">
								<a href="sch_view.php?schedule_id=<?php echo $i['schedule_id']?>"><?php echo $i['schedule_title'];?></a><br />
								<?php echo $i['schedule_synopsis'];?><br />
							</td>
							<td align="right" valign="top" nowrap>
								<?php
								if (!empty($i['schedule_occurence'])) {
									if ($i['schedule_occurence'] == $schedule_config['occurrence']['daily']) {
										echo $lang['schedule']['occurrence'][1] . ": " . $this->date->formatDate($i['schedule_start_datetime'], 3);
									}
									elseif ($i['schedule_occurence'] == $schedule_config['occurrence']['weekly']) {
										echo $lang['schedule']['occurrence'][3] . ": " . $this->date->formatDate($i['schedule_start_datetime'], 4);
									}
									elseif ($i['schedule_occurence'] == $schedule_config['occurrence']['monthly']) {
										echo $lang['schedule']['occurrence'][9] . ": " . $this->date->formatDate($i['schedule_start_datetime'], 5);
									}
									elseif ($i['schedule_occurence'] == $schedule_config['occurrence']['yearly']) {
										echo $lang['schedule']['occurrence'][12] . ": " . $this->date->formatDate($i['schedule_start_datetime'], 5);
									}
								}
								else { //no repeat
									echo $i['display_schedule_start_datetime'];
								}
								?>
								<br />
								<?php
								if (isset($i['schedule_allocation'])) {
									echo $lang['txt_allocation'] . ": " . $i['schedule_allocation'] . "<br />";
								}
								?>
								<br />
								<?php
								if (isset($i['allocation_status_id'])) {
									echo $lang['schedule']['allocation_status'][$i['allocation_status_id']] . "<br />";
								}
								?>
							</td>
						</tr>
						<?php
						}
						endforeach;
						?>
					</table>
					<?php
					echo createArrayList($schedule_items);
					?>
				<?php 
				}
				if (!isset($schedule) && !isset($schedule_items	)) {
					echo $lang['err_no_schedule_items'] . "<br />";
				}
				?>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
</div>

<div class="col_side">
	<form action="sch_view.php" method="post" name="frm" id="id_frm">
	<input type="hidden" name="schedule_id" value="<?php if(isset($schedule['schedule_id'])) { echo $schedule['schedule_id'];}?>" />
	<input type="hidden" name="schedule_type_id" value="<?php if(isset($schedule_type_id)) { echo $schedule_type_id;}?>" />
	
	<?php
	if (isset($schedule)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_attendance'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table border="0" cellspacing="0" cellpadding="2">
					<tr>
						<td>
							<?php echo $lang['txt_allocation'];?><br />
						</td>
						<td>
							<?php echo $schedule['schedule_allocation'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_applications'];?><br />
						</td>
						<td>
							<?php echo $schedule['schedule_applicants'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_confirmed'];?><br />
						</td>
						<td>
							<?php echo $schedule['schedule_confirmed'];?><br />
						</td>
					</tr>
				</table>
				
				<?php
				if (isset($me['user_id']) && $me['user_id']>0) {
				?>
				<table border="0" cellspacing="0" cellpadding="2" width="100%">
					<tr>
						<td valign="top">
							<?php
							$url = "sch_view.php?schedule_id=" . $schedule['schedule_id'];
							?>
							
							
							<?php
							if ($schedule['schedule_allocation'] > $schedule['schedule_confirmed']) { //spaces available
								echo $lang['txt_event_allocation_intro'];
								echo "<br /><br />";
							
								if (isset($schedule['allocation']['status_id'])) {
									if ($schedule['allocation']['status_id'] == $schedule_config['allocation_status']['rejected']) {
										echo "<p>" . $lang['txt_application_rejected'];
									}
									else {
										echo "<p align=\"right\"><b>" . $lang['txt_application'] . " " . $lang['schedule']['allocation_status'][$schedule['allocation']['status_id']] . "</b></p><p align=\"right\">";
									}
									
									
									
									//if task is confirmed allow use to remove it
									if ($schedule['allocation']['status_id'] == $schedule_config['allocation_status']['confirmed']) {
										$button = "<a href=\"" . $url . "&amp;withdraw_confirmation=1\" class=\"link_urgent\">" . $lang['href_event_withdraw_confirmation'] . "</a>";
									}
									elseif ($schedule['allocation']['status_id'] == $schedule_config['allocation_status']['withdrawn'] || $schedule['allocation']['status_id'] < 1) {
										$button = "<a href=\"" . $url . "&amp;schedule_apply_update=1\" class=\"link_urgent\">" . $lang['href_event_apply'] . "</a>";
									}
								}
								else {
									$button = "<a href=\"" . $url . "&amp;schedule_apply=1\" class=\"link_urgent\">" . $lang['href_event_apply'] . "</a>";
								}
							}
							?><br />
							</p>
						</td>
					</tr>
				</table>
				<?php
				}
				else {
				?>
				<p>
					<b><?php echo $lang['txt_log_in_attendance'];?></b><br />
				</p>
				<?php }?>
				
				<table cellpadding="0" cellspacing="0" border="0" width="100%">
					<tr>
						<td>
							<?php
							if (isset($button)) {
								echo "&nbsp;" . $button;
							}
							?>
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
			
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_schedule_item'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<b><?php echo $lang['txt_statistics'];?></b><br />
				</p>
					
				<?php
				if (isset($lang['txt_task_summary'])) {
					echo $lang['txt_task_summary'];
				}
				?>
				&nbsp;
				<?php
				if (isset($lang['txt_event_summary'])) {
					echo $lang['txt_event_summary'];
				}
				?><br />
				
					
					<p>
					<b><?php echo $lang['hdr_options'];?></b><br />
					</p>
					
					<p>
						<select name="options" class="options_select">
							<option value="list_node" selected="selected"><?php echo $lang['txt_option_group'];?></option>
							
							<?php
							if (isset($me['user_id'])) {
							?>
								<?php
								$selected = "";
								if (isset($frmdata) && $frmdata['options'] == "list_relation") {
								$selected = "selected=\"selected\"";
								}
								?>
								<option value="list_relation" <?php echo $selected;?>><?php echo $lang['txt_option_network'];?></option>
								
								<?php
								$selected = "";
								if (isset($frmdata) && $frmdata['options'] == "list_allocation") {
								$selected = "selected=\"selected\"";
								}
								?>
								<option value="list_allocation" <?php echo $selected;?>><?php echo $lang['txt_option_alloc'];?></option>
								
								<?php
								$selected = "";
								if (isset($frmdata) && $frmdata['options'] == "list_initiated") {
								$selected = "selected=\"selected\"";
								}
								?>
								<option value="list_initiated" <?php echo $selected;?>><?php echo $lang['txt_option_items'];?></option>
								
								<?php
								$selected = "";
								if (isset($frmdata) && $frmdata['options'] == "list_marked") {
								$selected = "selected=\"selected\"";
								}
								?>
								<option value="list_marked" <?php echo $selected;?>><?php echo $lang['txt_option_marked'];?></option>
								
								<?php
								$selected = "";
								if (isset($frmdata) && $frmdata['options'] == "list_relation_tips") {
								$selected = "selected=\"selected\"";
								}
								?>
								<option value="list_relation_tips" <?php echo $selected;?>><?php echo $lang['txt_option_tipped'];?></option>
								
								<option> </option>
								<?php
								if (isset($schedule) && $me['user_id'] > 0) {
								?>
								
									<?php
									if (empty($schedule['bookmark']['watch'])) {
									?>
									<option value="item_mark"><?php echo $lang['txt_option_mark'];?></option>
									<?php }?>
									<?php
									if (!empty($schedule['bookmark']['watch']) && !empty($schedule['bookmark']['recommend'])) {
										echo "&nbsp;&amp;&nbsp;";
									}
									?>
									<?php
									if (empty($schedule['bookmark']['recommend'])) {
									?>
									<option value="item_tip"><?php echo $lang['txt_option_tip'];?></option>
									<?php }?>
								<?php }?>
							<?php }?>
							
							<?php
							if ($this->user_acs->checkPermission($resource_ids['schedule'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
							if (isset($schedule)) {
							?>
								<option value="item_edit"><?php echo $lang['txt_option_edit'];?></option>
								<option value="item_edit_allocation"><?php echo $lang['txt_option_edit_a'];?></option>
							<?php
							}
							?>
								<option value="item_add_event"><?php echo $lang['txt_option_add_e'];?></option>
								<option value="item_add_task"><?php echo $lang['txt_option_add_t'];?></option>
							<?php }?>
						</select>
						<input type="image" src="<?php echo $templatePath;?>img/go.png" name="option_action" value="1" class="go" /><br />
					</p>
					
					<?php
					if (isset($schedule)) {
					?>
					<p>
						<b><?php echo $lang['hdr_tag'];?></b><br />
					</p>
						
					<p>
						<?php
						$tags = "";
						if (isset($item_tags)) {
							foreach ($item_tags as $key => $i):
								$tags .= "<a href='search.php?tag=" . $i['tag_body']. "'>" . $i['tag_body'] . "</a>";
								
								//mark my tags
								if (isset($my_tags)) {
									foreach ($my_tags as $key => $mt):
										if ($i['tag_body'] == $mt['tag_body']) {
											$tags .= "*";
											break;
										}
									endforeach;
								}
								
								if (count($item_tags) > $key+1) {
									$tags .= ", ";
								}
							endforeach;
							echo $tags;
						}
						?>
					</p>
					
					<?php
					if ($this->user_acs->checkPermission($resource_ids['schedule'], $privilege_ids['allow_tagging'])) { //resourece_id, Priv_id
					$tags = "";
					if (isset($my_tags)) {
						foreach ($my_tags as $key => $i):
							$tags .= $i['tag_body'];
							if (count($my_tags) > $key+1) {
								$tags .= ", ";
							}
						endforeach;
					}
					?>
					<p>
						<input width="30" name="tags" value="<?php echo $tags;?>" />
						<input type="image" src="<?php echo $templatePath;?>img/go.png" name="update_tag" value="1" class="go" /><br />
					</p>
					<?php }?>
					<?php }?>
				
					<p>
						<b><?php echo $lang['hdr_search'];?></b><br />
					</p>
					
					<p>
						<label for="id_start_date"><?php echo $lang['form_label_from_date'];?></label><br />
					</p>
					
					<p>
						<input type="text" name="start_date" id="id_start_date" class="slim_input" size="11" value="<?php if(isset($search['start_date'])) { echo $search['start_date'];}?>" />&nbsp;
						<img src="<?php echo $templatePath;?>img/cal_icon.png" id="id_cal_pop1" width="34" height="21" border="0" alt="" onmouseover="this.style.background='red';" onmouseout="this.style.background=''" /><br />
							
							<script type="text/javascript">
								function dateChanged1(calendar) {
									if (calendar.dateClicked) {
										var y = calendar.date.getFullYear();
										var m = calendar.date.getMonth()+1;     // integer, 0..11
										var d = calendar.date.getDate();      // integer, 1..31
								
										document.frm.id_start_date.value = y + '-' + m + '-' + d;
										calendar.callCloseHandler();
									}
								};
								
								Calendar.setup({           // our callback function
									ifFormat       :    "%m-%d-%Y",
									showsTime      :    true,
									button         :    "id_cal_pop1",
									singleClick    :    true,
									onSelect    : dateChanged1
								});
							</script>
					</p>
					
					
					<?php
					if (isset($display) && $display == "task") {
					?>
					<p>
						<label for="id_schedule_priority"><?php echo $lang['form_label_priority'];?></label><br />
					</p>
					<p>
							<select id="id_schedule_priority" name="schedule_priority">
							<option value="0"><?php echo $lang['form_option_all'];?></option>
							<?php
							foreach($lang['schedule']['arr_priority'] as $key => $i):
							$selected = "";
	
							if (isset($schedule_priority) && $schedule_priority == $key) {
								$selected = " selected=\"selected\"";
							}
							?>
							<option value="<?php echo $key;?>"<?php echo $selected;?>><?php echo $i;?></option>
							<?php endforeach; ?>
							</select>
					</p>>
					<?php
					}
					else {
					?>
					</p>
						<label for="id_schedule_show"><?php echo $lang['form_label_show'];?></label><br />
					</p>
					
					<p>
							<select id="id_schedule_show" name="schedule_show">
							<option value="0"><?php echo $lang['form_option_all'];?></option>
							<?php
							foreach($lang['schedule']['arr_show_days'] as $key => $i):
							$selected = "";
	
							if (isset($search['schedule_show']) && $search['schedule_show'] == $key) {
								$selected = " selected=\"selected\"";
							}
							?>
							<option value="<?php echo $key;?>"<?php echo $selected;?>><?php echo $i;?></option>
							<?php endforeach; ?>
							</select>
					</p>
					
					
					<?php
					$checked = "";
					if (!empty($search['schedule_status'])) {
						$checked = "checked=\"checked\"";
					}
					?>
					<p>
						<label for="id_schedule_status"><?php echo $lang['form_label_tentative'];?></label>
						<input type="checkbox" id="id_schedule_status" name="schedule_status" class="checkbox" <?php echo $checked;?> />
						<br />
					</p>
					<?php }?>
				
				<p>
					<input type="text" name="search_text" size="20" value="<?php if (isset($search_text)) { echo $search_text;};?>" />
					<input type="image" src="<?php echo $templatePath;?>img/go.png" value="search" class="go" /><br />
				</p>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	</form>
</div>
