+++ Wiki
The Hawaiian term wiki wiki, meaning "quick" or "super-fast".

A wiki enables documents to be written collectively in a simple markup language using a web browser. A single page in a wiki is referred to as a "wiki page", while the entire body of pages, which are usually highly interconnected via hyperlinks, is called "the wiki."

A defining characteristic of wiki technology is the ease with which pages can be created and updated. Generally, there is no review before modifications are accepted.

You can use your wiki as a web site in which to write documents such as manuals, cv's or detailed information about your interests. You can add pictures to support your work or create picture galleries.




wiki default items:

When you edit your wiki page you may see a checkbox called "default page". When someone visits your wiki, the default page is the first page that someone sees. If your page is the default page you will not see anything, however if it is not you have the option to make it into your default page.


+++ A guide to formatting wiki content

[[toc]]

++++ BOLD
You can make any text '''bold''' by putting three apostrphe's before and after the word(s) like:

!'''words to bold'''

'''words to bold'''

++++ CODE
For technical manuals you may wish to write code examples by enclosing the code in &#60;code&#62;code tag&#60;/code&#62;. You can also specify a 'type' as either 'php' or 'html' &#60;code type="php"&#62;text&#60;code&#62;

<code type="php">
<?php
// comment
$variable = 'Hello world!';
echo($variable);
?>


++++ HEADING
How big you want your heading text. Just put a plus sign (+) in front of the text.

!+ Heading Level 1
!++ Heading Level 2
!+++ Heading Level 3
!++++ Heading Level 4


++++ HORIZONTAL RULE
on a line by itself at the beginning of the line put ---- to create a horizontal rule:


++++ BREAK
You may want to create an explicit line break (force a line break). You can use it in lists, tables, etc. to break lines without breaking the element. Any line ending with a space and an underscore will create a break.

			<p>The quick brown _<br />
			foxs jumps over<br />
			the lazy dog.</p>

			<p>The quick brown<br />
			foxs jumps over <br />
			the lazy dog.</p>
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="blockquote">

			<p><b>BLOCKQUOTE</b><br />
			Any line starting with one or more &gt; signs, followed by a space will create a blockquote:</p>

			<blockquote><p>one &gt; is one tab in (blockquote)</p>
			<blockquote><p>two&gt;&gt; is two tab in (blockquotes)</p>
			</blockquote>
			</blockquote>
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="lists">
			<p><b>LISTS</b><br />
			Use this to create ordered lists with a # character, or unordered lists with a * marker.
			Adding spaces before the marking indents the list items. You can mix ordered and
			unordered lists. If you put a blank line between list item lines, you will start
			a new list.</p>

			<p># one<br />
			# two </p>

			<ol>
			 <li>one</li>
			 <li>two </li>
			</ol>

			<p>* three<br />
			* four</p>

			<ul>
			 <li>three</li>
			 <li>four</li>
			</ul><a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="table">
			<p><b>TABLE</b><br />
			| | at the beginning of a line, with || to separate cells, and | | at the end of the
			line, with optional alignment character (&lt; for left, = for center, &gt; for
			right)</p>

			<p>|| Cell 1 || Cell 2 ||<br />
			|| Cell 3 || Cell 4 ||</p>


			<table>
				<tr>
					<td>Cell 1</td>
					<td>Cell 2</td>
				</tr>
				<tr>
					<td>Cell 3</td>
			 		<td>Cell 4</td>
				</tr>
			</table>

			<p>You can span cells by using more than one set of | | markers.</p>

			<p>|| Cell 1 || Cell 2 ||<br />
			|||| Cell span ||</p>

			<table>
				<tr>
					<td>Cell 1</td>
					<td>Cell 2</td>
				</tr>
				<tr>
					<td colspan="2">Cell span</td>
				</tr>
			</table>

			<p>You can align the contents of a cell by including a &lt;, =, or &gt; character
			after the || marker.</p>

			<p>||< left ||= center ||> right ||<br />
			|| The quick brown || fox jumps over || the lazy dog. ||</p>

			<table>
				<tr>
					<td style="text-align: left;">left</td>
					<td style="text-align: center;">center</td>
					<td style="text-align: right;">right</td>
				</tr>
				<tr>
					<td>The quick brown</td>
					<td>fox jumps over</td>
					<td>the lazy dog.</td>
				</tr>
			</table>

			<p>If you include a blank line between table lines, you will start a new table.</p>

			<p>|| cell 1 || cell 2 ||</p>
			<p>|| cell 3 || cell 4 ||</p>

			<table>
				<tr>
					<td>cell 1</td>
					<td>cell 2</td>
				</tr>
			</table>

			<table>
				<tr>
					<td>cell 3</td>
					<td>cell 4</td>
				</tr>
			</table>
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="image">

			<p><b>IMAGE</b><br />
			You can place an image in your document. You may optionally link to another page
			in the wiki, and you may optionally indicate HTML attributes for your image, such
			as 'align' and 'hspace'. There can be no spaces in the image file name, and the
			macro arguments must be of the form 'arg=&quot;value&quot;'.</p>

			<p>Look in your images and see the filename of your image:</p>

			<p>[[image 2_t2.jpg]]<br />
			[[image 2_t2.jpg align="left" hspace="8"]]</p>

			<p><img src="../../../asset_aGFT6/group/2_t2.jpg" alt="2_t2.jpg" /></p>

			<p><img src="../../../asset_aGFT6/group/2_t2.jpg" align="left" hspace="8" alt="2_t2.jpg" /></p>

			<p>You can make the image a link to a page in the wiki by adding a link=&quot;...&quot; argument:</p>

			<p>[[image 2_t2.jpg link="FormatingFields"]]</p>

			<p><a href="FormatingFields"><img src="../../../asset_aGFT6/group/2_t2.jpg" alt="2_t2.jpg" /></a></p>

			<p>Barnraiser limits the amount of space you have for storing images. This is because we need to pay for that space. If you need more you can either pay us a small fee to increase your space or create links to images in other sites (note: remember that you must observe copyright laws)</p>

			<p>You can put a picture in a page by typing the URL to the picture (it must end in gif, jpg, or png).</p>

			<p>http://www.smudge.com/asset/kosovo_107_t1.jpg</p>

			<p><img src="http://www.smudge.com/asset/kosovo_107_t1.jpg" alt="http://www.smudge.com/asset/kosovo_107_t1.jpg" /></p>

			<p>You can use the described-reference URL markup to give the image an ALT tag. You should do this as it helps people with visual disabilities. It also means that when you roll over the image with your mouse you see the ALT tag:</p>

			<p>[http://www.smudge.com/asset/kosovo_107_t1.jpg Pristina/Prishtina Library]</p>

			<p><img src="http://www.smudge.com/asset/kosovo_107_t1.jpg" alt="Pristina/Prishtina Library with ugly fountain;)" /></p>
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="toc">
			<p><b>TABLE OF CONTENTS</b><br />
			Looks through all the heading elements in the source text and creates a table of
			contents from them; each table of contents entry is linked to the appropriate
			heading, so you can click on it to go to the heading.</p>

			<p>[[toc]]<br />
			<div id="toc"><strong>Table of Contents</strong>
			<div style="margin-left: -1em;"><a href="#toc0">+ Heading Level 1</a></div>
			<div style="margin-left: 0em;"><a href="#toc1">++ Heading Level 2</a></div>
			<div style="margin-left: 1em;"><a href="#toc2">+++ Heading Level 3</a></div>
			<div style="margin-left: 2em;"><a href="#toc3">++++ Heading Level 4</a></div>
			<div style="margin-left: 3em;"><a href="#toc4">+++++ Heading Level 5</a></div>

			<div style="margin-left: 4em;"><a href="#toc5"> ++++++ Heading Level 6</a></div>
			</div>
			<br />
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="centre">
			<b>CENTRE</b><br />
			Any line starting with an = sign followed by a space will center a paragraph line:</p>

			<p>= This line is centered.</p>

			<p><div style="text-align: center;">This line is centered.</div></p>
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="raw">

			<p><b>RAW</b><br />
			Use this when you want to mark text that should not be processed by the remaining
			Text_Wiki rules (i.e., it should be displayed literally as it is).</p>

			<p><strong>I'm strong!</strong>  **I'm strong!**</p>
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="links">

			<p><b>LINKS</b><br />
			You can make a link by simply typing some words together (called smashing words
			together) with a CAPS at the start of each word !LikeTheseWords. For instance
			this page name is called FormatingFields.</p>

			<p>If you want to create a new page in the !ThenTypeSomethingNew and you will
			see a questionmark appear after it like  !ThenTypeSomethingNew[?]. This means
			that the page has not been created yet, however if you then click on the link
			the page will be created and you can type information into it.</p>

			<p>If you do not want the text to create a link up an exclamation mark in front
			of it:</p>

			<p>!ThenTypeSomethingNew</p>

			<p>You can create a &quot;described&quot; or &quot;labeled&quot; link to a wiki
			page by putting the page name in brackets, followed by some text.</p>

			<p>[FormatingFields This is a link to this page]</p>

			<p>[FormatingFields This is a link to this page]</p>
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="url">

			<p><b>URL's</b><br />
			Create a remote link by simply typing in it's url:
			<a href="http://www.barnraiser.org/" onclick="window.open(this.href, '_blank'); return false;">http://www.barnraiser.org/</a> .</p>

			<p>Remember to include the whole url including the http: segment.
			You do not need to put the trailing slash, however it is good policy
			to do so.</p>

			<p>If you like, enclose it in brackets to create a numbered reference
			and avoid cluttering the page; [http://www.barnraiser.org/] becomes:</p>

			<p>The Barnraiser organisation made this <sup><a href="http://www.barnraiser.org/" onclick="window.open(this.href, '_blank'); return false;">1</a></sup></p>

			<p>Or you can have a described-reference instead of a numbered reference:</p>

			<p>[http://www.barnraiser.org/ Barnraiser is super cool]</p>

			<p><a href="http://www.barnraiser.org/" onclick="window.open(this.href, '_blank'); return false;">Barnraiser is super cool</a></p>
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="textcolor">
			<p><b>TEXTCOLOR</b><br />
			You can color text like this:</p>

			<p>##red|This is red text, ## but this is not.</p>

			<p><span style="color: aqua;">This is aqua text, </span> but this is not.<br />
			<span style="color: black;">This is black text, </span> but this is default browser text colour.<br />
			<span style="color: blue;">This is blue text, </span> but this is not.<br />
			<span style="color: fuchsia;">This is fuchsia text, </span> but this is not.<br />

			<span style="color: gray;">This is gray text, </span> but this is not.<br />
			<span style="color: green;">This is green text, </span> but this is not.<br />
			<span style="color: lime;">This is lime text, </span> but this is not.<br />
			<span style="color: maroon;">This is maroon text, </span> but this is not.<br />
			<span style="color: olive;">This is olive text, </span> but this is not.<br />

			<span style="color: purple;">This is purple text, </span> but this is not.<br />
			<span style="color: red;">This is red text, </span> but this is not.<br />
			<span style="color: silver;">This is silver text, </span> but this is not.<br />
			<span style="color: teal;">This is teal text, </span> but this is not.<br />
			<span style="color: yellow;">This is yellow text, </span> but this is not.</p>

			<p>If you are familiar with hex code you can also use those:</p>

			<p>More text, and then ##ff9933|this is kind of orange.##</p>

			<p>More text, and then <span style="color: #ff9933;">this is kind of orange.</span></p>
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
			<a name="tt">
			<p><b>TELETYPE TEXT</b><br />
			To create teletype (monospace) text:</p>

			<p>This is {{teletype}} text.</p>

			<p>This is <tt>teletype</tt> text.</p>
			<a href="#">back to the top</a><br />
			<br />
		</td>
	</tr>
	<tr>
		<td>
			<hr />
				<a name="italic">
				<p><b>ITALIC TEXT</b><br />
				To create italic text:</p>

				<p>This is ''italic'' text.</p>

				<p>This is <i>italic</i> text.</p>

				<br />
				<a href="#">back to the top</a><br />
				<br />
		</td>
	</tr>
</table>
