#!/usr/bin/perl -w # -*- cperl -*- #
#
#  de.pm - German language resources for GNUMP3d
#
#  GNU MP3D - A portable(ish) MP3 server.
#
# Homepage:
#   http://www.gnump3d.org/
#
# Author:
#  Steve Kemp <steve@steve.org.uk>
#
# Version:
#  $Id: de.pm,v 1.1 2003/10/27 11:48:24 skx Exp $
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  Steve Kemp
#  ---
#  http://www.steve.org.uk/
#
#


#
##
#
#
#  This file may be copied and used as a basis of localisation for
# any other language.  Mail me your updated file and I'll happily
# include it within the distribution.
#
#
##
#


#
#  Hash that contains all our text.
#
our %TEXT ;




$TEXT{ HELP_TEXT } = <<E_O_HELP;
GNUMP3d v\$RELEASE - Ein portabler MP3/OGG/HTTP streaming server.
              - Siehe http://www.gnump3d.org/ fr mehr details.

Benutzung: gnump3d [optionen]

 --background              Programm von Konsole abkoppeln und im Hintergrund laufen lassen.
 --config filename         Optionen vom Konfigurationsfile einlesen.
 --debug                   Debugging Nachrichten nicht ins Error-log, sondern auf Standard-Out schreiben.
 --dump-plugins            Alle gefundenen plugins auflisten.
 --fast                    Schnellstart ohne vorheriges indizieren der audio files.
 --help                    Diese Benutzerinformation.
 --lang XX                 Lade die Texte aus dem angegebenen Sprachen-file.
 --plugin-verz Verzeichnis Lade die plugins aus dem  angegebenen Verzeichniss.
 --port Nummer             Auf der angegebenen Port-Nummer Dienste anbieten.
 --quiet                   Beim Starten das Banner nicht zeigen.
 --root Verzeichnis        Wurzelverzeichnis des Musik-Archives.
 --test                    Erlaubt das einlesen von Umgebungsvariablen.
 --themen-verz Verzeichnis Load the theme files from the given directory.
 --version                 Gibt die Version dieser Software aus.

 Fehlermeldungen an : Steve Kemp <steve\@steve.org.uk>

E_O_HELP




$TEXT{ VERSION_TEXT } = <<E_O_VERSION;
gnump3d v\$RELEASE [CVS Info: \$VERSION]
E_O_VERSION




$TEXT{ STARTUP_BANNER } =<<E_O_BANNER;
GNUMP3d v\$RELEASE von Steve Kemp
http://www.gnump3d.org/

GNUMP3d is freie software, durch die GNU General Public License geschtzt
und es wird begrsst, die Software zu ndern und/oder zu kopieren unter denselben
Bedingungen.

Fr weitere Details Schauen Sie unter dem COPYING Link:

  Kopier Details:
    http://\$host/COPYING

  GNUMP3d spielt momentan:
    http://\$host/

  GNUMP3d Website:
    http://www.gnump3d.org/
E_O_BANNER





$TEXT{ ERROR_BIND } =<<E_O_BIND;
  Konnte den Port, auf den gehrt werden soll nicht ffnen

  Evtl. ist der Port \$PORT bereits in Benutzung?

  Hier die Systemfehlermeldung:

     \$!

E_O_BIND





$TEXT{ ROOT_MISSING } =<<E_O_NO_ROOT;
  Das angegebene Wurzelverzeichnis des Musik-Archives. \$ROOT,
 ist nicht vorhanden.

  Bitte im Konfigurationsfile das korrekte Wurzelverzeichnis angeben,
 in dem sich das Musik Archiv befindet.

  Der Fehler kann behoben werden, wenn die Zeile korrigiert wird, die momentan
 folgenden Inhalt hat:

   root = \$ROOT

E_O_NO_ROOT




$TEXT{ THEME_DIR_MISSING } =<<E_O_NO_THEME_DIR;
  Das angegebene Themen Verzeichnis \$theme_dir existiert nicht.

  Bitte im Konfigurationsfile das korrekte Themen Verzeichnis
 angeben.

  Der Fehler kann behoben werden, wenn die Zeile korrigiert wird, die momentan
 folgenden Inhalt hat:

    theme_dir = \$theme_dir

E_O_NO_THEME_DIR




$TEXT{ PLUGIN_DIR_MISSING } =<<E_O_NO_PLUGIN_DIR;
  Das gewhlte plugin Verzeichnis chosen \$plugin_dir existiert nicht.

  Bitte im Konfigurationsfile das korrekte plugin Verzeichnis
 angeben.

  Der Fehler kann behoben werden, wenn die Zeile korrigiert wird, die momentan
 folgenden Inhalt hat:

    plugin_directory = \$plugin_dir

E_O_NO_PLUGIN_DIR




$TEXT{ NO_PLUGINS } =<<E_O_NO_PLUGINS_FOUND;
   Im Verzeichnis \$plugin_dir wurde kein Plugin gefunden

   Abbruch.

E_O_NO_PLUGINS_FOUND




$TEXT{ CONFIG_MISSING } =<<E_CONFIG_MISSING;
  Das Konfigurationsfile existiert nicht:
 \$CONFIG_FILE

  Mit  '--config' kann der Pfad zum Konfigurationsfile angegeben werden.

  Voreingestellt ist  /etc/gnump3d/gnump3d.conf und ~/.gnump3drc , wenn
 es sich um Unix und GNU/Linux Systeme handelt.

E_CONFIG_MISSING




$TEXT{ DEFAULT_THEME_MISSING } =<<E_O_NO_DEFAULT_THEME;
  Das Themen Verzeichnis '\$theme_dir' enthlt nicht das default Thema
'\$default_theme'  welches verwendet werden soll.

  Der Fehler kann behoben werden, wenn eine oder beide Zeilen korrigiert wird, die momentan
 folgenden Inhalt haben:

    theme_directory = \$theme_directory
    theme           = \$default_theme

E_O_NO_DEFAULT_THEME




$TEXT{ MIME_MISSING } =<<E_O_NO_MIME;
  Das Fileformat was ich in den  MIME types nachschlagen wollte existiert
 nicht.

  Bitte '\$mime_file' eintragen - oder im Konfigurationsfile die Zeile
 korrigieren, die momentan folgenden Inhalt hat:

    mime_file = \$mime_file

E_O_NO_MIME




$TEXT{ RO_ACCESS_LOG } =<<E_O_NO_WRITE;
  Das angegebene Logfile  '\$access_log' ist nicht bechreibbar



  Der Fehler kann behoben werden, wenn die File-Berechtigungen angepasst werden, oder
 wenn die Zeile korrigiert wird, die momentan folgenden Inhalt hat:

   logfile = \$access_log

E_O_NO_WRITE




$TEXT{ RO_NOW_SERVING } =<<E_O_NO_WRITE_SERVING;
  Das Verzeichnis, in dem ich den momentan gespielten Titel schreiben soll, ist nicht beschreibbar
   - \$NOW_PLAYING_PATH.

   Der Fehler kann behoben werden, wenn die Verzeichnis-Berechtigungen angepasst werden, oder
 wenn die Zeile korrigiert wird, die momentan folgenden Inhalt hat:

    now_playing_path = \$NOW_PLAYING_PATH

E_O_NO_WRITE_SERVING





$TEXT{ RUNNING_INDEX } =<<E_RUNNING_INDEX;

 Das indizieren des Musik Archives luft... und kann etwas dauern.

 Starten Sie mit '--fast' wenn das beim Starten bersprungen werden soll.

E_RUNNING_INDEX




$TEXT{ ERROR_FORK } = <<E_NO_FORK;
  Fataler Fehler, kann meinen Prozess nicht aufspalten `fork()`.

  Die Systemfehlermeldung war \$!

E_NO_FORK




$TEXT{ ACCESS_DENIED } =<<E_ACCESS_DENIED;
  Zugriff auf \$connected_address ist verboten.

  Bitte den Systemadministrator benachrichtigen, wenn Sie an einen Fehler glauben.

E_ACCESS_DENIED




$TEXT{ ERROR404 } =<<E_404_TEXT;

  Das angeforderte File <code>\$uri</code> wurde nicht gefunden.

  Bitte gehen Sie direkt nach <a href="/">index</a>.

E_404_TEXT




$TEXT{ EMPTY_PLAYLIST } =<<E_EMPTY_PLAYLIST;

  Die ausgewhlte Playliste ist leer.

  Bitte eine andere Wahl treffen, und den Fehler dem
 Server Eigentmer mitteilen.

E_EMPTY_PLAYLIST




$TEXT{ INDEXING_COMPLETE } =<<E_INDEX_DONE;
  Indizierung fertig.

E_INDEX_DONE



$TEXT{ FAIL_TRUNCATE } =<<E_FAIL_TRUNCATE;
  Das Access Logfile '\$access_log' konnte nicht gekrzt werden.

  Die Systemfehlermeldung war:

      \$!

E_FAIL_TRUNCATE


$TEXT{ FAIL_OPEN_LOGFILE } =<<E_FAIL_LOGFILE;
  Das Access Logfile '\$access_log' konnte nicht geffnet werden, Abbruch.

  Die Systemfehlermeldung war:

      \$!

E_FAIL_LOGFILE




$TEXT{ FAILED_USER_SWITCH } =<<FAILED_USER_DETAILS;
  Ich konnte die ID und GID fr user \$username nicht finden
 und deshalb nicht zum User wechseln. Abbruch!

  Der Fehler kann vermieden werden, indem der Eintrag im Konfigurationsfile
  'user = \$username' in gnump3d.conf angepasst wird.

FAILED_USER_DETAILS





#
#  Module loaded correctly now.
#
1;
