<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Gestion des connexions.
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaClass
*/

SetVarGlobal("gconnexionid",'');

/**
* Fournit une API pour acceder aux connexions.
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaClass
*/
class Connexion {
	
	/**
	* Retourne une nouvelle connexion. Positionne la variable globale $gconnexionid
	* @return	string	Retourne la valeur de la nouvelle connexion
	* @access	public
	*/
	function GetIdCnx() {
	 global $gconnexionid ;
		srand(time())			;
		$taille = 8				;
		$value = "1234567890"	;
		$id = '' ;
		for ( $i=0; $i<$taille; $i++ ) {
			$id .= substr($value,(rand()%(strlen($value))),1);
		}
		$gconnexionid = $id  ;
		return $gconnexionid ;
	}

	/**
	* Met a jour la connexion pour un membre
	* @param	integer	$idu ID du membre
	* @access	private
	*/
	function Update($idu) {
	 global $guser, $TBL, $db ;
		$date = FormatDate() ;
		$sSQL = "UPDATE ".$TBL['membres']." SET date_connexion='".$date."' " ;
		$sSQL.= "WHERE id=".$idu ;
		$db->query($sSQL) ;
	}

	/**
	* Incremente le nombre de connexion pour le membre $idu
	* @param	integer	$idu ID du membre
	* @access	private
	*/
	function IncNbCnx($idu) {
	 global $TBL, $db ;
	 	$date = FormatDate()	;
		$sSQL = "SELECT nbconnexion FROM ".$TBL['membres']." WHERE id=".$idu ;
		$db->query($sSQL) ;
		$db->next_record();
		$nb = $db->f('nbconnexion') + 1 ;
		$sSQL = "UPDATE ".$TBL['membres']." SET nbconnexion=".$nb.",date_connexion='".$date."' " ;
		$sSQL.= "WHERE id=".$idu ;		
		$db->query($sSQL) ;
	}

	/**
	* Cre une nouvelle connexion pour le membre $idu
	* @param	integer	$idu ID du membre
	* @return	integer	Retourne une nouvelle connexion pour le membre
	* @access	public
	*/
	function NewCnx($idu) {
	 global $TBL, $db, $ClsLog ;
		//$this->Update($idu)		;
		$this->IncNbCnx($idu)	;
		$sSQL = "DELETE FROM ".$TBL['connexion']." WHERE id_user=".$idu ;
		$db->query($sSQL)		;
		$date = FormatDate()	;
		$ids = $this->GetIdCnx();
		$sSQL="INSERT INTO ".$TBL['connexion']." (id_user,id_connexion,date_connexion)" ;
		$sSQL .=" VALUES (".$idu.",'".$ids."','".$date."')" ;
		$db->query($sSQL)	;	
		$ClsLog->newLog($idu,$ids);
		return($ids)		;
	}

	/**
	* Met a jour la date de la connexion $cnx
	* @param	integer	$cnx Valeur de la connexion
	* @access	public
	*/
	function Refresh($cnx) { 
	 global $TBL, $db, $ClsLog ;
		$date = FormatDate() ;
		$sSQL = "UPDATE ".$TBL['connexion']." SET date_connexion='".$date."' " ;
		$sSQL.= "WHERE id_connexion=".$cnx	;
		$ClsLog->refresh($cnx);
		$db->query($sSQL) ;
	}

	/**
	* Gere le Login d'un membre a la plate forme GANESHA
	* @param	string	$txtuser		Valeur du login
	* @param	string	$txtpassword	Valeur du password
	* @return	boolean	Retourne 0 si la connexion a echouee, sinon l'Id du membre connecte
	* @access	public
	*/
	function Login($txtuser,$txtpassword) {
	 global $guser, $guserid, $gusertype, $TBL, $groupe, $db ;
		$sSQL = "SELECT prenom, nom, id, type, id_groupe FROM ".$TBL['membres']." "			;
		$sSQL.= " WHERE login='".$txtuser."' and password='".$txtpassword."'"	;
		$db->query($sSQL) ;
		if ( $db->num_rows() == 1 ) {
			$db->next_record();
			$guser     = $db->f("prenom")." ".$db->f("nom") ;
			$guserid   = $db->f("id")		;
			$gusertype = $db->f("type")		;
			$groupe	   = $db->f("id_groupe");
			$db->free()		;
			return($guserid);
		} else {
			return 0;
		}
	}

	/**
	* Retourne la derniere connexion d'un membre
	* @param	integer	$idu Id du membre
	* @return	string	Retourne la date de la derniere connexion d'un membre
	* @access	public
	*/
	function Last($idu) { 
	 global $guserid,$TBL, $db ;
	 global $st_texte ;
		$sSQL="SELECT date_connexion FROM ".$TBL['membres']." where id=".$idu ;
		$db->query($sSQL) ;
		$db->next_record();
		if ( $db->f(0) !=  "" ) {
			$last = date("j/m/Y",$db->f(0))	;
			$db->free()						;
		} else {
			$last = $st_texte['premcnx']	;
		}
		return $last;
	}

	/**
	* Retourne le nombre de connexions actives
	* @return	integer	Retourne le nombre de connexions actives
	* @access	public
	*/
	function NbCnxActive() {
	 global $TBL, $db ;
		$date = getdate() ;
		$ref_date = $date["0"] - TIME_OUT_CNX			;
		$sSQL = "SELECT id_user FROM ".$TBL['connexion'];
		$sSQL.= " where date_connexion >=".$ref_date	;
		$db->query($sSQL)		;
		$db->next_record()		;
		$nb  = $db->num_rows()	;
		$db->free()				;
		return $nb				;
	}

	/**
	* Supprime les connexions qui ont depassees le Time Out
	* @access	public
	*/
	function DeleteOldCnx() {
	 global $TBL, $db ;
		$date = getdate()							;
		$ref_date = $date["0"] - TIME_OUT_CNX		;
		$sSQL = "DELETE FROM ".$TBL['connexion']	;
		$sSQL.= " WHERE date_connexion <".$ref_date	;
		$db->query($sSQL)							;
	}

} // class Connexion 

/**
* Instance de la classe Connexion
* @var	object	Connexion
*/
$ClsCnx = new Connexion ;

?>