<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Gestion des chapitres
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaClass
*/
/**
* Fournit une API pour acceder aux chapitres.
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaClass
*/
class Chapitre {

	/**
	* Contient la connexion locale de la classe
	* @var	object DB_Ganesha	$_db
	* @access	private
	*/
	var $_db ;

	/**
	* Constructeur. Initialise une connexion a la bdd
	* @access	private
	*/
	function Chapitre() {
		$this->_db = new DB_Ganesha ;
	}

	/**
	* Retourne le nombre de chapitre pour un module
	* @param	integer	$idm Id du module
	* @return	integer Retourne le nombre de chapitre pour un module
	* @access	public
	*/
	function NbChapter($idm) {
	 global $TBL, $db ;
		$sSQL="SELECT numero FROM ".$TBL['module']." WHERE id_module=".$idm ;
		$db->query($sSQL)		;
		$db->next_record()		;
		$nb = $db->num_rows()	;
		$db->free()				;
		return $nb				;
	} 

	/**
	* Retourne le nombre de quizz pour un module
	* @param	integer	$idm Id du module
	* @return	integer Retourne le nombre de quizz pour un module
	* @access	public
	*/
	function readIdQuizz($idm) {
	 global $TBL, $db ;
		$sSQL = "SELECT numero FROM ".$TBL['module']." WHERE id_module=".$idm." " ;
		$sSQL.= "AND type<>".TITRE." ORDER BY numero ASC";		
		$db->query($sSQL);
		$ret['cnt'] = $db->num_rows()	;
		while($db->next_record()) {
			$ret[] = $db->f('numero');
		}
		$db->free()	;
		return($ret);
	} 

	/**
	* Retourne le nombre de quizz pour un module
	* @param	integer	$idm Id du module
	* @return	integer Retourne le nombre de quizz pour un module
	* @access	public
	*/
	function NbQuizz($idm) {
	 global $TBL, $db ;
		$sSQL="SELECT numero FROM ".$TBL['module']." WHERE id_module=".$idm." AND type<>".TITRE ;
		$db->query($sSQL)		;
		$db->next_record()		;
		$nb = $db->num_rows()	;
		$db->free()				;
		return $nb				;
	} 

	/**
	* Retourne le titre du chapitre
	* @param	integer	$idm Id du module
	* @param	integer	$idc Id du chapitre
	* @return	integer Retourne le titre du chapitre
	* @access	public
	*/
	function Title($idm,$idc) {
	 global $TBL, $db ;
		$sSQL="SELECT titre FROM ".$TBL['module']."  WHERE id_module=".$idm." AND numero=".$idc ;
		$db->query($sSQL)		;
		$db->next_record()		;
		return $db->f("titre")	;
	} 

	/**
	* Lecture de tous les chapitres d'un module
	* @param	integer	$idm Id du module
	* @return	array le detail des chapitres
	* @access	public
	* @see		NextItem()
	*/
	function read($idm) {
	 	global $TBL, $db;
		if ( is_numeric($idm)) {
			$sSQL = " SELECT titre,numero,link,norme,type FROM ".$TBL['module']."  WHERE id_module=".$idm ;
			$sSQL.= " ORDER BY numero ASC"	;
			$db->query($sSQL)	;
			$ret = array();
			$ret['cnt'] = $db->num_rows();
			$i=0;
			while($db->next_record()) {
				$ret[$i]['titre']  	= $db->f("titre")	;
				$ret[$i]['numero'] 	= $db->f("numero") 	;
				$ret[$i]['lien']   	= $db->f("link")   	;
				$ret[$i]['norme']	= $db->f("norme") 	;
				$ret[$i]['type']   	= $db->f("type")   	;
				$i++;
			}
		}
		return ($ret);
	} 


	/**
	* Lecture de tous les chapitres d'un module
	* @param	integer	$idm Id du module
	* @param	integer	$idc Id du chapitre
	* @return	array le detail des chapitres
	* @access	public
	* @see		NextItem()
	*/
	function info($idm,$idc) {
	 	global $TBL, $db;
		if ( is_numeric($idm)) {
			$sSQL = " SELECT titre,numero,link,norme,type FROM ".$TBL['module']." WHERE id_module=".$idm ;
			$sSQL.= " AND numero=".$idc	;
			$db->query($sSQL)	;
			$db->next_record() 	;
			$ret['titre']  	= $db->f("titre")	;
			$ret['numero'] 	= $db->f("numero") 	;
			$ret['lien']   	= $db->f("link")   	;
			$ret['norme']	= $db->f("norme") 	;
			$ret['type']   	= $db->f("type")   	;
		}
		return ($ret);
	} 
		

} // class Chapitre

/**
* Instance de la classe Chapitre
* @var	object	Chapitre
*/
$ClsChapitre = new Chapitre ;

?>