<?php

// -----------------------------------------------------------------------
// This file is part of beacon
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

/*
formatFileOutput
formats the html for a file
style = thumbnail image or link
tom calthrop
6th December 2004
*/
function formatFileOutput($arr_file, $style = null) {
	
	global $template_path, $c_node;
	
	if ($arr_file['file_suffix'] == "jpg" || $arr_file['file_suffix'] == "gif" || $arr_file['file_suffix'] == "png") {
		echo "<img src=\"get_file.php?file="  . $arr_file['file'] . "\" border=\"0\" class=\"picture\">";
    
	}
	elseif ($arr_file['file_suffix'] == "pdf") {
		echo "<img src=\"" . $template_path . "img/file_pdf.png\" border=\"0\">";
	}
	elseif ($arr_file['file_suffix'] == "txt") {
		echo "<img src=\"" . $template_path . "img/file_txt.png\" border=\"0\">";
	}
}


/*
* Trim
* tom calthrop
* 10th Jan 2004
*/
function dots($num, $string) {
	if (strlen($string) > $num) {
		$string = substr_replace($string, '...', $num);
	}
	return $string;
}


/*
* Read file from hard disk and return
* tom calthrop
* 22nd April 2004
*/
function readTxtFile($source) {

	$handle = fopen($source, "rb");
	$output = "";
	do {
	   $data = fread($handle, 8192);
	   if (strlen($data) == 0) {
	       break;
	   }
	   $output .= $data;
	} while (true);

	fclose($handle);

	$output = addslashes($output);

	return $output;
}



/*
* Format an email address for display
* tom calthrop
* 31st May 2005
*/
function formatEmail($email) {
	
	global $lang;
	
	$pos = strrpos($email, ".");
	$email = substr($email, 0, $pos) . "-" . $lang['email']['dot'] . "-" . substr($email, $pos+1);
	
	$email = str_replace("@", "-" . $lang['email']['at'] . "-", $email);
	
	return $email;
}


?>
