<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------


// MAIN INCLUDES ---------------------------------------------------------
include ("components/core/config/core.config.php");
include ("components/core/inc/functions.inc.php");


// SESSION HANDLER -------------------------------------------------------
// sets up all session and global vars 
session_name($core_config['node']['php_session_name']);
session_start();

if ($core_config['am']['webspace_creation_type'] === 1 || $core_config['am']['webspace_creation_type'] === 2) {
	// ERROR HANDLING
	// this is accessed and updated with all errors thoughtout this build
	// processing regularly checks if empty before continuing
	$GLOBALS['am_error_log'] = array();
	
	
	// SETUP DATABASE ------------------------------------------------------
	require_once('components/core/class/Db.class.php');
	$db = new Database($core_config['db']);


	// SETUP LANGUAGE
	$_SESSION['language_code'] = $core_config['language']['pack'][$core_config['language']['default_pack_id']];
	
	$locale_code = $installed_server_language_packs[strtoupper($_SESSION['language_code'])];
	
	setlocale(LC_ALL, $locale_code);

	$lang = array();
	$language_path = "components/core/language/" . $_SESSION['language_code'] . "/";
	include_once($language_path . 'common.lang.php');
	require_once($language_path . 'admin_webspace.lang.php');
	require_once($language_path . 'create_webspace.lang.php');

	// SETUP TEMPLATE -------------------------------------------
	$template_path = "template/";
	$component_path = "components/core/";
	$template_path_core = $component_path . $template_path;
		
	require_once('components/core/class/Template.class.php');
	$tpl = new Template();
	$body = new Template();

	$script_name = "create_webspace";

	
	// //create trusted root
	$trusted_root = "http://" . $_SERVER['HTTP_HOST'] . dirname ($_SERVER['PHP_SELF']);
	
	if (substr($trusted_root, -1, 1) != "/") {
		$trusted_root .= "/";
	}
	
	//create return_to path
	$return_to = "http://" . $_SERVER['HTTP_HOST'] . dirname ($_SERVER['PHP_SELF']);
	
	if (substr($return_to, -1, 1) != "/") {
		$return_to .= "/";
	}
	$return_to .= "create_webspace.php";
	
	
	if (isset($_POST['commit'])) {
		if (!empty($_POST['openid_login'])) {
			
			include_once ('components/core/class/Openid.class.php');
			
			$openid = new SimpleOpenID($db, $core_config);
			$openid->SetIdentity($_POST['openid_login']);
			$openid->SetTrustRoot($trusted_root);
			$openid->SetApprovedURL($return_to);
			$openid->SetRequiredFields(array('nickname'));
			$openid->SetOptionalFields(array('fullname', 'email', 'country', 'language'));
			if ($openid->GetOpenIDServer()) {
				$openid->SetApprovedURL($trusted_root);
				$openid->SetApprovedURL($return_to);
				$openid->Redirect();
				exit;
			}
			else {
				$error = $openid->GetError();
				$GLOBALS['am_error_log'][] = array('login_failed');
			}
		}
	}
	elseif (isset($_GET['openid_mode'])) {
			
		if ($_GET['openid_mode'] == 'id_res') {
			
			include_once ('components/core/class/Openid.class.php');
			
			$openid = new SimpleOpenID($db, $core_config);
			$openid->SetIdentity($_GET['openid_identity']);
			if ($openid->ValidateWithServer()) {
				//$_SESSION['openid_identity'] = $_GET['openid_identity'];
	
				$openid = $_GET['openid_identity'];
				
				if(substr($openid,-1,1) == '/'){
					$openid = substr($openid, 0, strlen($openid)-1);
				}
					
				$_SESSION['openid_identity'] = $openid;
	
			
				$_SESSION['level_id'] =  64;
				
				if (!empty($_GET['openid_sreg_email'])) {
					$_SESSION['openid_email'] = $_GET['openid_sreg_email'];
				}
				
				if (!empty($_GET['openid_sreg_fullname'])) {
					$_SESSION['openid_fullname'] = $_GET['openid_sreg_fullname'];
				}
				
				if (!empty($_GET['openid_sreg_country'])) {
					$_SESSION['openid_country'] = $_GET['openid_sreg_country'];
				}
				
				if (!empty($_GET['openid_sreg_language'])) {
					$_GET['openid_sreg_language'] = strtolower($_GET['openid_sreg_language']);
					
					if (in_array($_GET['openid_sreg_language'], $core_config['language']['pack'])) {
						$_SESSION['language_code'] = $_GET['openid_sreg_language'];
					}
				}
				else {
					$_SESSION['language_code'] = $core_config['language']['pack'][$core_config['language']['default_pack_id']];
				}
				
				$_SESSION['openid_nickname'] = $_GET['openid_sreg_nickname'];
	
				// We may have started to setup a webspace then been disconnected.
				// we check for a connection and if non exists
				// we need to create a dummy-connection and later update that connection...
				$query = "
					SELECT connection_id
					FROM " . $db->prefix . "_connection c
					WHERE
					c.connection_openid=" . $db->qstr($_SESSION['openid_identity']) ." AND
					webspace_id<1"
				;
				
				$result = $db->Execute($query);
	
				if (isset($result[0])) {
					$_SESSION['connection_id'] = $result[0]['connection_id'];
				}
				else {
					$data = array();
					
					$data['connection_create_datetime'] = time();
					$data['status_id'] = $core_config['connection']['status']['active'];
					$data['connection_openid'] = $_SESSION['openid_identity'];
					$data['connection_nickname'] = $_SESSION['openid_nickname'];
							
					if (!empty($_SESSION['openid_email'])) {
						$data['connection_email'] = $_SESSION['openid_email'];
					}
							
					if (!empty($_SESSION['openid_fullname'])) {
						$data['connection_fullname'] = $_SESSION['openid_fullname'];
					}
							
					if (!empty($_SESSION['openid_country'])) {
						$data['connection_country'] = $_SESSION['openid_country'];
					}
					
					if (!empty($_GET['openid_sreg_language'])) {
					$rec['connection_language'] = $_GET['openid_sreg_language'];
				}
				elseif (!empty($_SESSION['openid_language'])) {
					$rec['connection_language'] = $_SESSION['openid_language'];
				}
							
					$table = $db->prefix . "_connection";
				
					$db->insertDB($data, $table);
		
					$_SESSION['connection_id'] = $db->insertID();
				}
			}
		}
	}
	elseif (isset($_POST['test_unix_name'])) {
	
		if (empty($_POST['unix_name'])) {
			$GLOBALS['am_error_log'][] = array('unix_name_empty');
		}
		elseif (!preg_match('/^[a-z0-9.~]+$/', $_POST['unix_name'])) {
			$GLOBALS['am_error_log'][] = array('unix_name_incorrect');
		}
		elseif (strlen($_POST['unix_name']) < 3) {
			$GLOBALS['am_error_log'][] = array('unix_name_short');
		}
		
		$query = "
			SELECT webspace_id, owner_connection_id
			FROM " . $db->prefix . "_webspace
			WHERE webspace_unix_name='" . $_POST['unix_name'] . "'"
		;
		
		$result = $db->Execute($query);
		
		if (isset($result[0]) && isset($result[0]['webspace_id'])) {
			if (!isset($_SESSION['connection_id']) || $result[0]['owner_connection_id'] != $_SESSION['connection_id']) {
				// already taken...
				$GLOBALS['am_error_log'][] = array('unix_name_taken');
			}
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			$body->set('select_unix_name', 1);
		}
	}
	elseif (isset($_POST['select_unix_name'])) {
		
		if (empty($_POST['unix_name'])) {
			$GLOBALS['am_error_log'][] = array('unix_name_empty');
		}
		elseif (!preg_match('/^[A-Za-z0-9.~]+$/', $_POST['unix_name'])) {
			$GLOBALS['am_error_log'][] = array('unix_name_incorrect');
		}
		elseif (strlen($_POST['unix_name']) < 3) {
			$GLOBALS['am_error_log'][] = array('unix_name_short');
		}
		
		$query = "
			SELECT webspace_id, owner_connection_id
			FROM " . $db->prefix . "_webspace
			WHERE webspace_unix_name=" . $db->qstr($_POST['unix_name'])
		;
		
		$result = $db->Execute($query);
	
		if (isset($result[0]) && isset($result[0]['webspace_id'])) {
			if ($result[0]['owner_connection_id'] == $_SESSION['connection_id']) {
	
				$webspace_id = $result[0]['webspace_id'];
				$body->set('webspace_id', $webspace_id);
			}
			else {
				// already taken...
				$GLOBALS['am_error_log'][] = array('unix_name_taken');
			}
		}
		
		if (empty($GLOBALS['am_error_log']) && !isset($webspace_id)) {
			// we reserve (insert) a record with a date of 000
			$data = array();
			$data['owner_connection_id'] = $_SESSION['connection_id'];
			$data['webspace_unix_name'] = $_POST['unix_name'];
			$data['webspace_create_datetime'] = time();
	
			$table = $db->prefix . "_webspace";
			
			$db->insertDB($data, $table);
	
			$webspace_id = $db->insertID();
	
			if (isset($webspace_id)) {
				$body->set('webspace_id', $webspace_id);
			}
		}
	}
	elseif (isset($_POST['commit_webspace']) && !empty($_POST['webspace_id'])) {
	
		if (empty($_POST['agreement_approved'])) {
			$GLOBALS['am_error_log'][] = array('agreement_not_approved');
		}
	
		if (empty($_POST['language_code'])) {
			$_POST['language_code'] = $core_config['language']['pack'][$core_config['language']['default_pack_id']];
		}

		if (empty($_POST['webspace_title'])) {
			$GLOBALS['am_error_log'][] = array('title_empty');
		}

		if (empty($_POST['webspace_description'])) {
			$GLOBALS['am_error_log'][] = array('description_empty');
		}
			
		if (empty($GLOBALS['am_error_log'])) {
			if ($core_config['am']['webspace_creation_type'] === 2) {
				$status_id = $core_config['webspace']['status']['active'];
			}
			else {
				$status_id = $core_config['webspace']['status']['pending'];
			}

			$query = "
				UPDATE " . $db->prefix . "_webspace SET
				language_code=" . $db->qstr($_POST['language_code']) . ",
				webspace_allocation=" . $core_config['file']['default_allocation'] . ",
				status_id=" . $status_id
			;

			$query .= ", webspace_description=" . $db->qstr($_POST['webspace_description']);

			$query .= ", webspace_title=" . $db->qstr($_POST['webspace_title']);
			
			$query .= ", webspace_css=" . $db->qstr(@file_get_contents(dirname(__FILE__) . "/" . $component_path . "template/layouts/" . $_POST['layout'] . '/css/style.css'));

			if (!empty($_POST['webspace_locked'])) {
				$query .= ", webspace_locked=1";
			}

			if (!empty($_POST['webspace_maintainer_log'])) {
				$query .= ", webspace_maintainer_log=" . $db->qstr($_POST['webspace_maintainer_log']);
			}

			$query .= " WHERE webspace_id=" . $_POST['webspace_id'];
			//echo $query; exit;
			$result = $db->Execute($query);


			// insert the page-set
			$page_set = @scandir(dirname(__FILE__) . "/" . $component_path . "template/layouts/" . $_POST['layout'] . "/pages");

			unset($page_set[0], $page_set[1]);
			$data = array();
			$data['webspace_id'] = $_POST['webspace_id'];
			$_SESSION['webspace_id'] = $data['webspace_id'];
			$webspace_id = $data['webspace_id'];

			foreach($page_set as $p) {

				$webpage_body = file_get_contents(dirname(__FILE__) . "/" . $component_path . "template/layouts/" . $_POST['layout'] . "/pages/" . $p);
				$webpage_name = explode('.', $p);
				$webpage_name = ucfirst(strtolower($webpage_name[0]));

				$data['webpage_body'] = $webpage_body;
				$data['webpage_name'] = $webpage_name;
				$data['webpage_title'] = $webpage_name;
				$data['webpage_create_datetime'] = time();

				$table = $db->prefix . '_webpage';

				$db->insertDB($data, $table);

				if ($webpage_name == "Home") {
					$default_webpage_id = $db->insertID();
				}
			}

			unset($data);

			if (!isset($default_webpage_id)) {
				$default_webpage_id = $db->insertID();
			}

			$query = "
				UPDATE " . $db->prefix . "_webspace
				SET default_webpage_id=" . $default_webpage_id . "
				WHERE webspace_id=" . $webspace_id
			;

			$db->Execute($query);

			$_SESSION['level_id'] = 64;
			unset($data);

			$maintainer_permissions=0;

			// get permissions
			$query = "
				SELECT *
				FROM " . $db->prefix . "_permission
				ORDER BY plugin_name"
			;

			$result = $db->Execute($query);

			if (isset($result)) {
				foreach($result as  $key => $i) :
					$maintainer_permissions = $maintainer_permissions+$i['bitwise_operator'];
				endforeach;
			}

			$query = "
				UPDATE " . $db->prefix . "_connection
				SET webspace_id=" . $webspace_id . ",
				connection_permission=" . $maintainer_permissions . "
				WHERE connection_id=" . $_SESSION['connection_id']
			;

			$db->Execute($query);

			$_SESSION['connection_permission'] = $maintainer_permissions;

			
			if ($core_config['am']['mode'] < 1) {
				$query = "
					SELECT webspace_unix_name
					FROM " . $db->prefix . "_webspace
					WHERE webspace_id=" . $webspace_id
				;
		
				$result = $db->Execute($query);

				if (isset($result[0])) {
					$url = formatSubDomainUrl($result[0]['webspace_unix_name']);
					
					header("location: " . $url);
					exit;
				}
			}
			
			header('location: index.php?ws=' . $webspace_id);
			exit;
		}
		else {
			$body->set('webspace_id', $_POST['webspace_id']);
		}
	}
	else {
		// we will any session data
		unset (
			$_SESSION['connection_id'],
			$_SESSION['webspace_id'],
			$_SESSION['level_id'],
			$_SESSION['openid_identity'],
			$_SESSION['openid_email'],
			$_SESSION['openid_fullname'],
			$_SESSION['openid_country'],
			$_SESSION['openid_language'],
			$_SESSION['openid_nickname'],
			$_SESSION['maintainer']
		);
	}
	
	$output_layouts = array();
		
	// obtain the layouts
	foreach (glob(dirname(__FILE__) . '/' . $component_path . 'template/layouts/*/language/' . $_SESSION['language_code'] . '/layout.lang.php') as $f):

		unset ($lang['layout_title'], $lang['layout_description'], $layout_temp);

		// GET NAME
		$pattern = "/template\/layouts\/(.*?)\/language/";

		if (preg_match ($pattern, $f, $dname)) {
			if (!empty($dname[1])) {

				include_once($f);

				$layout_temp['name'] = $dname[1];

				if (isset($lang['layout_title'])) {
					$layout_temp['title'] = $lang['layout_title'];
				}
				else {
					$layout_temp['title'] = "";
				}

				if (isset($lang['layout_description'])) {
					$layout_temp['description'] = $lang['layout_description'];
				}
				else {
					$layout_temp['description'] = "";
				}

				array_push ($output_layouts, $layout_temp);
			}
		}
	endforeach;

	if (!empty($output_layouts)) {
		$body->set('layouts', $output_layouts);
	}

	$tpl->set('lang', $lang);
	$body->set('lang', $lang);
	$tpl->set('template_path_core', $template_path_core);
	$body->set('template_path_core', $template_path_core);
	$body->set('core_config', $core_config);
	$tpl->set('core_config', $core_config);
	$tpl->set('script_name', $script_name);

	//unset($tpl->vars['webspace']['webspace_css']);
	$template_file = $script_name . ".tpl.php";
	$tpl->set('content', $body->fetch($component_path . $template_path . $template_file));

	echo $tpl->fetch($template_path_core . 'wrapper.tpl.php');
}
else { // creation forbidden
	header("location: overview.php");
	exit;
}

?>