<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "me";


if (!isset($_SESSION['md5'])) {
	header("Location: index.php?http_referer=" . urlencode($_SERVER['REQUEST_URI']) . "&" . strip_tags(SID));
	exit;
}

if (isset($_POST['remove_respect']) && !empty($_POST['identity_id'])) {
	$query = "
		DELETE FROM " . $db->prefix . "_relation
		WHERE user_id=" . $_SESSION['user_id'] . " AND 
		identity_id_relation IN (" . implode(', ', $_POST['identity_id']) . ")"
	;
	
	$result = $db->Execute($query);
	
	if (!isset($result->fields)) {
		$error_info = "script=me_ties.php -- " . $query . " -- " . $db->ErrorMsg();
		$GLOBALS['am_error_log'][] = array('db_error', $error_info);
	}
}

require_once ("class/File.class.php");
$file = new File($db, $core_config['file']);

if (isset($core_config['module'])) {
	$file->core_config_module = $core_config['module'];
}

$file->user_id = $_SESSION['user_id'];
$file->module_id = 0; // core
$file->no_image = $core_config['file']['image']['thumb'][0]['no_image'];
$file->thumbs = $core_config['file']['image']['thumb'];
$file->thumb = $core_config['file']['image']['thumb'][0]['suffix'];

include_once ('class/Network.class.php');
$network = new Network($db, $core_config);
$network->user_id = $_SESSION['user_id'];
$network->file = $file;
$user->file = $file;


$output_respected_mutual = $network->selMutualRespected();

$user->file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
$user->file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];

$query = "
	SELECT r.identity_id_relation, r.identity_id
	FROM " . $db->prefix . "_relation r
	WHERE r.user_id=" . $_SESSION['user_id']
;

$result = $db->Execute($query);

if (isset($result->fields)) {
	$output_respected = array();
	while(!$result->EOF) {
		array_push($output_respected, $result->fields);
		$result->moveNext();
	}
	$result->Close();
}

if (!empty($output_respected)) {
	
	foreach($output_respected as $key => $r):
		$output_respected[$key]['identity'] = $user->selUserIdentity(null, $r['identity_id_relation']);
		$output_respected[$key]['matrix'] = $network->selMatrix($r['identity_id'], $r['identity_id_relation']);
	endforeach;
	$body->set('respected', $output_respected);
}


if (!empty($output_respected_mutual)) {

	// we include all module files which have a function to obtain a single item
	// module_id 1 will include a function called -selItemModule1
	if (!empty($core_config['module'])) {
		foreach($core_config['module'] as $key => $i):
			$suffix = $core_config['module'][$key]['prefix'];
	
			if(is_file("components/" . $suffix . "/inc/" . $suffix . "_item_select.function.php")) {
				include_once("components/" . $suffix . "/inc/" . $suffix . "_item_select.function.php");
			}
		endforeach;
	}

	foreach($output_respected_mutual as $key => $i):
 		$output_respected_mutual[$key]['identity']['identity_nic'] = $i['identity_nic'];
 		$output_respected_mutual[$key]['identity']['identity_id'] = $i['identity_id'];
 		$output_respected_mutual[$key]['identity_relation']['identity_nic'] = "foo";
		$output_respected_mutual[$key]['identity_relation']['identity_id'] = $i['identity_id_mutual'];
		$output_respected_mutual[$key]['relation']['respected']['item_id'] = $i['item_id'];
		$output_respected_mutual[$key]['relation']['respected']['module_id'] = $i['module_id'];
		$output_respected_mutual[$key]['relation']['respected']['relation_create_datetime'] = $i['relation_create_datetime'];
		$output_respected_mutual[$key]['relation']['mutual']['item_id'] = $i['item_id_mutual'];
		$output_respected_mutual[$key]['relation']['mutual']['module_id'] = $i['module_id_mutual'];
		$output_respected_mutual[$key]['relation']['mutual']['relation_create_datetime'] = $i['relation_create_datetime_mutual'];
		$output_respected_mutual[$key]['ties'] = $network->selSharedParticipationCount($i['identity_id'], $i['identity_id_mutual']);
	
		$suffix = $core_config['module'][$output_respected_mutual[$key]['relation']['mutual']['module_id']]['prefix'];
		$function_name = "selItemModule_" . $suffix;

		if (function_exists($function_name)) {
			$output_respected_mutual[$key]['item'] = $function_name($output_respected_mutual[$key]['relation']['mutual']['item_id']);
		}
	endforeach;

	$body->set('respected_mutual', $output_respected_mutual);
}

?>