<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

class Network {
	
	// Constructor
	// Sebastian Öblom 15th January 2007
	//
	function Network($db, $config, $identity_id = null, $identity_id_relation = null) {
		$this->db = $db;
		$this->config = $config;
		
		if (isset($identity_id)) {
			$this->identity_id = $identity_id;
		}
		
		if (isset($identity_id_relation)) {
			$this->identity_id_relation = $identity_id_relation;
		}
	}//EO Network
	
	
	// setIdentities ----------------------------------------------------------------------
	// sets the identities to perform action at
	// Sebastian Öblom 15th January 2007
	//
	function setIdentities($identity_id, $identity_id_relation) {
		$this->identity_id = $identity_id;
		$this->identity_id_relation = $identity_id_relation;
	}//EO setIdentities
	
	
	//
	//
	//
	//
	function selMatrix($identity_id = null, $identity_id_relation = null) {
		
		$matrix = array();
		
		if (!isset($identity_id) && !isset($this->user_id)) {
			$identity_id = $this->identity_id;
		}
		
		if (!isset($identity_id_relation)) {
			$identity_id_relation = $this->identity_id_relation;
		}
		
		if (isset($identity_id)) { // identity to identity-level. We only need to get 2 identity-cards
			
			$query = "
				SELECT i.identity_nic, i.identity_name
				FROM " . $this->db->prefix . "_user_identity i
				WHERE i.identity_id=" . $identity_id
			;
			
			$result = $this->db->Execute($query);
			
			if (isset($result->fields)) {
				$matrix[0]['identity'] = $result->fields;
				$matrix[0]['identity']['identity_id'] = $identity_id;
				$result->Close();
			}
			else {
				$error_info = "method=selMatrix class=Network.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
 				$GLOBALS['am_error_log'][] = array('db_error', $error_info);
			}
			
			$query = "
				SELECT i.identity_nic, i.identity_name
				FROM " . $this->db->prefix . "_user_identity i
				WHERE i.identity_id=" . $identity_id_relation
			;
			
			$result = $this->db->Execute($query);
			
			if (isset($result->fields)) {
				$matrix[0]['identity_relation'] = $result->fields;
				$matrix[0]['identity_relation']['identity_id'] = $identity_id_relation;
				$result->Close();
			}
			else {
				$error_info = "method=selMatrix class=Network.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
 				$GLOBALS['am_error_log'][] = array('db_error', $error_info);
			}
			
			// we need to find out the relation between identity_id and identity_id_relation
			$matrix[0]['relation'] = $this->selRelation($identity_id, $identity_id_relation);
			
			// we need the number of ties we share
			$matrix[0]['ties'] = $this->selSharedParticipationCount($identity_id, $identity_id_relation);
		}
		elseif (isset($this->user_id)) {
			// we select all our identities
			$query = "
				SELECT i.identity_nic, i.identity_name, i.identity_id
				FROM " . $this->db->prefix . "_user_identity i
				WHERE i.user_id=" . $this->user_id
			;
			
			if (isset($this->identity_type)) {
				$query .= " AND i.identity_type=" . $this->identity_type;
			}
			
			$result = $this->db->Execute($query);
			$counter = 0;
			
			if (isset($result->fields)) {
				while(!$result->EOF) {
					$matrix[$counter]['identity'] = $result->fields;
					$counter++;
					$result->moveNext();
				}
				$result->Close();
			}
			else {
				$error_info = "method=selMatrix class=Network.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
 				$GLOBALS['am_error_log'][] = array('db_error', $error_info);
			}
			
			// the other identity-card
			$query = "
				SELECT i.identity_nic, i.identity_name
				FROM " . $this->db->prefix . "_user_identity i
				WHERE i.identity_id=" . $identity_id_relation
			;

			$result = $this->db->Execute($query);
			
			if (isset($result->fields)) {
				for($i = 0; $i < $counter; $i++) {
					$matrix[$i]['identity_relation'] = $result->fields;
					$matrix[$i]['identity_relation']['identity_id'] = $identity_id_relation;
				}
				$result->Close();
			}
			else {
				$error_info = "method=selMatrix class=Network.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
 				$GLOBALS['am_error_log'][] = array('db_error', $error_info);
			}
			
			// Set X, R or M to each card and calculate the number
			foreach($matrix as $key => $m):
				$matrix[$key]['relation'] = $this->selRelation($m['identity']['identity_id'], $identity_id_relation);
				$matrix[$key]['ties'] = $this->selSharedParticipationCount($m['identity']['identity_id'], $identity_id_relation);
			endforeach;
		}

		return $matrix;
	}//EO selMatrix
	
	
	//
	//
	//
	//
	function selRelation($identity_id = null, $identity_id_relation = null) {
		$relation = array();
		
		if (!isset($identity_id)) {
			$identity_id = $this->identity_id;
		}
		
		if (!isset($identity_id_relation)) {
			$identity_id_relation = $this->identity_id_relation;
		}
		
		$query = "
			SELECT r.module_id, r.item_id, r.relation_create_datetime 
			FROM " . $this->db->prefix . "_relation r
			WHERE r.identity_id=" . $identity_id . " AND r.identity_id_relation=" . $identity_id_relation
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			if (isset($result->fields['module_id'])) {
				$relation['respected'] = $result->fields;
				$result->Close();
				
				$query = "
					SELECT r.module_id, r.item_id, r.relation_create_datetime 
					FROM " . $this->db->prefix . "_relation r
					WHERE r.identity_id=" . $identity_id_relation . " AND r.identity_id_relation=" . $identity_id
				;
				
				$result = $this->db->Execute($query);
				
				if (isset($result->fields)) {
					if (isset($result->fields['module_id'])) {
						$relation['mutual'] = $result->fields;
						$result->Close();
					}
				}
				else {
					$error_info = "method=selRelation class=Network.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
					$GLOBALS['am_error_log'][] = array('db_error', $error_info);
				}
			}
		}
		else {
			$error_info = "method=selRelation class=Network.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
		
		return $relation; // if empty, there is no relation R or M
	}//EO selRelation
	
	
	// sharedParticipation ---------------------------------------------------------------------------
	// returns an array of stuff we both are participating in
	// Sebastian Öblom 15th January 2007
	//
	function sharedParticipation($identity_id = null, $identity_id_relation = null) {
		$participation = array();
		
		if (!isset($identity_id)) {
			$identity_id = $this->identity_id;
		}
		
		if (!isset($identity_id_relation)) {
			$identity_id_relation = $this->identity_id_relation;
		}
		
		$query = "
			SELECT t1.item_id, t1.module_id
			FROM " . $this->db->prefix . "_participation AS t1 
			INNER JOIN " . $this->db->prefix . "_participation AS t2 
			ON (t2.identity_id=" . $identity_id . " AND t1.item_id=t2.item_id AND t1.module_id=t2.module_id) 
			WHERE t1.identity_id =" . $identity_id_relation . " AND t1.status_id=" . $this->config['participation']['status']['active'] . " AND 
			t2.status_id IN (" . $this->config['participation']['status']['active'] . ", " . $this->config['participation']['status']['invite']  . ")"
		;
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			if (isset($result->fields['item_id'])) {
				while(!$result->EOF) {
					array_push($participation, $result->fields);
					$result->moveNext();
				}
			}
			$result->Close();
		}
		else {
			$error_info = "method=sharedParticipation class=Network.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
		
		return $participation;
	}//EO sharedParticipation
	
	
	//
	//
	//
	//
	function selSharedParticipationCount($identity_id = null, $identity_id_relation = null) {
	
		if (!isset($identity_id)) {
			$identity_id = $this->identity_id;
		}
		
		if (!isset($identity_id_relation)) {
			$identity_id_relation = $this->identity_id_relation;
		}
		
		$query = "
			SELECT COUNT(*) AS total
			FROM " . $this->db->prefix . "_participation AS t1 
			INNER JOIN " . $this->db->prefix . "_participation AS t2 
			ON (t2.identity_id=" . $identity_id . "
			AND t1.item_id=t2.item_id AND t1.module_id=t2.module_id) 
			WHERE t1.identity_id=" . $identity_id_relation . " AND 
			t1.status_id=" . $this->config['participation']['status']['active'] . " AND 
			t2.status_id=" . $this->config['participation']['status']['active'] .""
		;
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			if (isset($result->fields)) {
				$temp = $result->fields;
			}
			$result->Close();
		}
		else {
			$error_info = "method=selRelation class=Network.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
		return $temp;
	
	}//EO selSharedParticipationCount
	
	
	// IdentityStatistics ------------------------------------------------------------------------------
	// returns nr of people respected and nr of respect from people
	// Sebastian Öblom, 15th January 2007
	//
	function IdentityStatistics($identity_id = null) {
		
		if (!isset($identity_id)) {
			$identity_id = $this->identity_id;
		}
		
		$statistics = array();
		$query = "
			SELECT COUNT(*) AS respected
			FROM " . $this->db->prefix . "_relation r
			WHERE r.identity_id=" . $identity_id . ""
		;
		
		$result = $this->db->Execute($query);
		if (isset($result->fields)) {
			$statistics['respected'] = $result->fields['respected'];
			$result->Close();
		}
		else {
			$error_info = "method=IdentityStatistics class=Network.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
		
		$query = "
			SELECT COUNT(*) AS respect
			FROM " . $this->db->prefix . "_relation r
			WHERE r.identity_id_relation=" . $identity_id . ""
		;
		
		$result = $this->db->Execute($query);
		if (isset($result->fields)) {
			$statistics['respect'] = $result->fields['respect'];
			$result->Close();
		}
		else {
			$error_info = "method=IdentityStatistics class=Network.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
		
		return $statistics;
	}//EO IdentityStatistics
	
	
	// networkRelationPath --------------------------------------------------------------------
	// returns the set of identities we both respect (including mutual)
	// Sebastian Öblom, 15th January 2007
	//
	function networkRelationPath() {
	
		$query = "
			SELECT DISTINCT r.identity_id_relation, i.identity_nic
			FROM " . $this->db->prefix . "_relation r
			INNER JOIN " . $this->db->prefix . "_user_identity i
			ON r.identity_id_relation=i.identity_id
			WHERE r.identity_id=" . $this->identity_id . " OR r.identity_id=" . $this->identity_id_relation . ""
		;
		
		$result = $this->db->Execute($query);
		if (isset($result->fields)) {
			$respected_ids = array();
			while(!$result->EOF) {
				array_push($respected_ids, $result->fields);
				$result->moveNext();
			}
			$result->Close();
		}
		else {
			$error_info = "method=networkRelationPath class=Network.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
		
		return $respected_ids;
	}//EO networkRelationPath
	
	
	// networkTiePath ------------------------------------------------------------------------
	// returns identities that 'I' respect (including mutual) that also has something in common (participation) with 'you'
	// Sebastian Öblom, 15:th January 2007
	//
	function networkTiePath() {
		
		// We first select people i respect
		$query = "
			SELECT r.identity_id_relation
			FROM " . $this->db->prefix . "_relation r
			WHERE r.identity_id=" . $this->identity_id . ""
		;
		$temp = array();
		$temp1 = array();
		$result = $this->db->Execute($query);
		if (isset($result->fields)) {
			
			while(!$result->EOF) {
				array_push($temp, $result->fields['identity_id_relation']);
				$result->moveNext();
			}
			$result->Close();
		}
		else {
			$error_info = "method=networkTiePath class=Network.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
		
		// We select people you participate with
		$query = "
			SELECT DISTINCT t1.identity_id
			FROM " . $this->db->prefix . "_participation AS t1 
			INNER JOIN " . $this->db->prefix . "_participation AS t2 
			ON (t2.identity_id=" . $this->identity_id_relation . " AND t1.item_id=t2.item_id AND t1.module_id=t2.module_id) 
			WHERE t1.identity_id !=" . $this->identity_id_relation . ""
		;
		
		$result = $this->db->Execute($query);
		if (isset($result->fields)) {
			
			while(!$result->EOF) {
				array_push($temp1, $result->fields['identity_id']);
				$result->moveNext();
			}
			$result->Close();
		}
		else {
			$error_info = "method=networkTiePath class=Network.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
		
		// we intercect to find the interseting identities
		return array_intersect($temp, $temp1);
	}//EO networkTiePath
	
	
	// selSharedRespected --------------------------------------------------------------------------------
	// returns people we both respect
	// Sebastian Öblom 15th January 2007
	//
	function selSharedRespected() {
		// We first select people i respect
		$query = "
			SELECT r.identity_id_relation, i.identity_nic
			FROM " . $this->db->prefix . "_relation r
			INNER JOIN " . $this->db->prefix . "_user_identity i
			ON r.identity_id_relation=i.identity_id
			WHERE r.identity_id=" . $this->identity_id . ""
		;
		
		$temp = array();
		$temp1 = array();
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			
			while(!$result->EOF) {
				array_push($temp, $result->fields);
				$result->moveNext();
			}
			$result->Close();
		}
		else {
			$error_info = "method=selRespected class=Network.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
		
		// we select people you respect
		$query = "
			SELECT r.identity_id_relation, i.identity_nic
			FROM " . $this->db->prefix . "_relation r
			INNER JOIN " . $this->db->prefix . "_user_identity i
			ON r.identity_id_relation=i.identity_id
			WHERE r.identity_id=" . $this->identity_id_relation . ""
		;

		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			
			while(!$result->EOF) {
				array_push($temp1, $result->fields);
				$result->moveNext();
			}
			$result->Close();
		}
		else {
			$error_info = "method=selRespected class=Network.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
		
		return array_intersect($temp, $temp1);
	}//EO selSharedRespected
	
	
	// selMutualRespected ---------------------------------------------------------------------------
	//
	//
	//
	function selMutualRespected($identity_id = null) {
		
		$mutual_respected = array();
		
		if (!isset($identity_id) && !isset($this->user_id)) {
			$identity_id = $this->identity_id;
		}
		
		$query = "
			SELECT DISTINCT t1.identity_id_relation AS identity_id, i.identity_nic, 
			t1.module_id, t1.item_id, t1.relation_create_datetime, i2.file_id, 
			t2.relation_create_datetime AS relation_create_datetime_mutual, 
			t2.item_id AS item_id_mutual, t2.module_id AS module_id_mutual,
			t1.identity_id AS identity_id_mutual
			FROM " . $this->db->prefix . "_relation AS t1 
			INNER JOIN " . $this->db->prefix . "_relation AS t2 
			ON t1.identity_id=t2.identity_id_relation AND t1.identity_id_relation=t2.identity_id 
			INNER JOIN " . $this->db->prefix . "_user_identity i
			ON t1.identity_id_relation=i.identity_id
			LEFT JOIN " . $this->db->prefix . "_user_identity i2
			ON i.identity_id=i2.identity_id
			WHERE "
		;
		
		
		if (isset($this->user_id)) {
			$query .= "t1.user_id=" . $this->user_id;
		}
		else {
			$query .= "t1.identity_id=" . $identity_id . " AND t1.identity_id_relation != " . $identity_id . "";
		}
//    		echo $query; exit;
		
		$result = $this->db->Execute($query);
		if (isset($result->fields)) {
			while(!$result->EOF) {
			
				if (isset($this->file)) {
					if (isset($result->fields['file_id'])) {
						if (isset($this->file->thumb)) {
							$result->fields['image'] = $this->file->selFile($result->fields['file_id'], $this->file->thumb);
						}
						else {
							$result->fields['image'] = $this->file->selFile($result->fields['file_id'], "t2");
						}
					}
	 				else {
	 					$result->fields['image']['file_md5_name_view'] = '0-' . $this->file->no_image;
	 				}
				}
				
				array_push($mutual_respected, $result->fields);
				$result->moveNext();
			}
			$result->Close();
		}
		else {
			$error_info = "method=selMutualRespected class=Network.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
		
		return $mutual_respected;
	}//EO selMutualRespected
}
?>