<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


class Statistic {
	
	// Statistic --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 20th December 2004
	//
	function Statistic($db, $config){
		$this->db = $db;
		$this->config = $config;
	} // EO constructor
	
	
	
	// selStatistics ---------------------------------------------------------------
	// returns statistics
	// tom calthrop - 20th December 2004
	//
	function selStatistics() {
		
		$query = "
			SELECT s.statistic_type_id, s.total
			FROM " . $this->db->prefix . "_statistic s
			WHERE "
		;
		
		if (isset($this->module_id)) {
		    $query .= "s.module_id=" . $this->module_id . " AND ";
		}
		
		if (isset($this->item_id)) {
		    $query .= "s.item_id=" . $this->item_id . " AND ";
		}
		
		$query .= "1=1 ";
			
		$query .= "order by s.statistic_type_id";
		
		$result = $this->db->Execute($query);
	
		if (isset($result->fields)) {
	
			$temp = array();
	
			while (!$result->EOF) {
				$temp1 = $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}
	
			$result->Close();
	
			return $temp;
		}
		else {
			$error_info = "function=selStatistics class=Statistic.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selStatistics
	
	

	// setStatistic --------------------------------------------------------------------
	// set a statistic
	// tom calthrop - 21st Feb 2004
	//
	function setStatistic ($total = null) {
		if (empty($total)) {
		    $total = 0;
		}
		
		$query = "
			DELETE FROM " . $this->db->prefix . "_statistic
			WHERE
			statistic_type_id=" . $this->statistic_type_id . " AND "
		;
		
		if (isset($this->module_id)) {
		    $query .= " module_id=" . $this->module_id . " AND ";
		}
		
		if (isset($this->item_id)) {
		    $query .= " item_id=" . $this->item_id . " AND ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);
		
		
		if (!empty($this->item_id)) {
		    $item_id = $this->item_id;
		}
		else {
		    $item_id = "null";
		}
		
		if (!isset($this->module_id)) {
		    $this->module_id = 0;
		}
		
		$rec = array();
		$rec['module_id'] = $this->module_id;
		$rec['statistic_type_id'] = $this->statistic_type_id;
		$rec['total'] = $total;
		$rec['item_id'] = $item_id;
		
		$table = $this->db->prefix . "_statistic";
			
		$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
	} // EO setStatistic

	
	
	// selStatistic ---------------------------------------------------------------
	// returns a statistic
	// tom calthrop - 20th December 2004
	//
	function selStatistic() {
		
	$query = "
			SELECT s.total
			FROM " . $this->db->prefix . "_statistic s
			WHERE "
		;
		
		if (isset($this->module_id)) {
		    $query .= "s.module_id=" . $this->module_id . " AND ";
		}
		
		if (isset($this->statistic_type_id)) {
		    $query .= "s.statistic_type_id=" . $this->statistic_type_id . " AND ";
		}
		
		if (isset($this->item_id)) {
		    $query .= "s.item_id=" . $this->item_id . " AND ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);
	
		if (isset($result->fields)) {
			if (isset($result->fields['total']) && $result->fields['total'] > 0) {
			    return $result->fields['total'];
			}
			else {
				return "0";
			}
			$result->Close();
	
			
		}
		else {
			$error_info = "function=selStatistic class=Statistic.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	} // EO selStatistic
}
?>
