<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

class Skill {
	// CLASS FUNCTIONS
	// Skill
	// selSkill
	// updateSkill
	// insertSkill
	// selSkills
	// deleteSkill
	

	// Skill --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 6th December 2004
	//
	function Skill($db) {
		$this->db = $db;
	}//EO Skill



	// selSkill --------------------------------------------------------------------
	// gets a single record from the DB
	// tom calthrop - 22nd May 2004
	//
	function selSkill() {
		$query = "
			SELECT s.skill_id, s.skill_name, s.skill_rating, s.skill_experience,
			s.user_id, s.degree_id 
			FROM " . $this->db->prefix . "_user_skill s
			WHERE "
		;
		
		if (isset($this->skill_id)) {
		    $query .= "s.skill_id=" . $this->skill_id . " AND ";
		}
		
		if (!empty($this->user_id)) {
		    $query .= "s.user_id=" . $this->user_id . " AND ";
		}
		
		$query .= "1=1 ";
		
		$result = $this->db->SelectLimit($query, 1); //returns last 1 rows

		if (isset($result->fields)) {

			$temp = $result->fields;
			$this->skill_id = $temp['skill_id'];

			$result->Close();

			return $temp;
		}
		else {
			$error_info = "function=selSkill class=Skill.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO selSkill



	// updateSkill --------------------------------------------------------------------
	// updates a single skill record in DB
	// tom calthrop - 22nd May 2004
	//
	function updateSkill($data) {

		if(empty($data['skill_name'])) {
			$GLOBALS['am_error_log'][] = array(52, null, null);
		}
		
		if (empty($GLOBALS['am_error_log'])) {

			if (empty($data['skill_experience'])) {
			    $data['skill_experience'] = "null";
			}
			
			if (!empty($data['degree_id']) && $data['degree_id'] == "all") {
			    $data['degree_id'] = "null";
			}
			else {
			    $data['degree_id'] = 1; // 1st degree network only
			}
			
			$query = "
				SELECT * FROM " . $this->db->prefix . "_user_skill 
				WHERE 
				skill_id=" . $data['skill_id']
			;
			
			$result = $this->db->Execute($query);
			
			$rec = array();
			$rec['skill_name'] = $data['skill_name'];
			$rec['skill_rating'] = $data['skill_rating'];
			$rec['skill_experience'] = $data['skill_experience'];
			$rec['degree_id'] = $data['degree_id'];
			
			$table = $this->db->prefix . "_user_skill";
			
			$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			$this->skill_id = $data['skill_id'];
			
		}

	} //EO updateSkill



	// insertSkill --------------------------------------------------------------------
	// inserts a single skill in the DB
	// tom calthrop - 22nd May 2004
	//
	function insertSkill($data) {
		
		if(empty($data['skill_name'])) {
			$GLOBALS['am_error_log'][] = array(52, null, null);
		}

		if (empty($GLOBALS['am_error_log'])) {
			if (empty($data['skill_experience'])) {
			    $data['skill_experience'] = "null";
			}
			
			if (!empty($data['degree_id']) && $data['degree_id'] == "all") {
			    $data['degree_id'] = "null";
			}
			else {
			    $data['degree_id'] = 1; // 1st degree network only
			}
			
			$rec = array();
			$rec['skill_name'] = $data['skill_name'];
			$rec['skill_rating'] = $data['skill_rating'];
			$rec['skill_experience'] = $data['skill_experience'];
			$rec['user_id'] = $this->user_id;
			$rec['degree_id'] = $data['degree_id'];
			
			$table = $this->db->prefix . "_user_skill";
			
			$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
			
			if (isset($result->fields)) {
				$this->skill_id = $this->db->Insert_ID();
			}
			else {
				$error_info = "function=insertSkill class=Skill.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	} //EO insertSkill



	// selSkills --------------------------------------------------------------------
	// returns multiple rows of skills from DB
	// tom calthrop - 22nd May 2004
	//
	function selSkills($search=null, $full=null) {
		if (isset($search) || isset($full)) {
			$query = "SELECT s.skill_id, s.skill_name, s.skill_rating, s.skill_experience,
				s.user_id, s.degree_id 
				FROM " . $this->db->prefix . "_user_skill s 
				WHERE 
				(
				s.skill_name like " . $this->db->qstr("%" . $search . "%", get_magic_quotes_gpc()) . " OR 
				s.skill_experience like " . $this->db->qstr("%" . $search . "%", get_magic_quotes_gpc()) . ") AND "
			;
		}
		else {
			$query = "SELECT DISTINCT s.skill_name 
				FROM " . $this->db->prefix . "_user_skill s 
				WHERE "
			;
		}
		
		if (isset($this->user_id)) {
		    $query .= "s.user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->degree_id)) {
		    $query .= "s.degree_id=" . $this->degree_id . " AND ";
		}
		
		if (isset($this->user_ids)) {
			$user_ids = "";
			foreach($this->user_ids as $key => $i):
				$user_ids .= $i;
				if (count($this->user_ids) > $key+1) {
				    $user_ids .=",";
				}
			endforeach;
			$query .="s.user_id in (" . $user_ids . ") and ";
		}
		
		$query .="1=1 ";
		
		if (isset($this->order_by)) {
		    $query .= "order by " . $this->order_by;
		}
		else {
			$query .= "order by s.skill_rating desc";
		}
		//echo $query;
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		}
		else {
			$result = $this->db->Execute($query);
		}
		
		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {

				$temp1 = $result->fields;

				//format search results
				if (isset($search)) {
					$temp1['skill_name'] = searchTextFormat($search, $temp1['skill_name']);
					$temp1['skill_experience'] = searchTextFormat($search, $temp1['skill_experience']);
				}

				array_push($temp, $temp1);

				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selSkills class=Skill.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO selSkills()



	// deleteSkills --------------------------------------------------------------------
	// deletes multiple rows of skills from DB
	// tom calthrop - 22nd May 2004
	//
	function deleteSkills($del_arr) {
		$rownums = count ($del_arr);

		//echo $rownums;

		for ($i=0; $i < $rownums; $i++) {
			$query = "
				DELETE from " . $this->db->prefix . "_user_skill
				WHERE
				skill_id = " . $del_arr[$i]
			;

			$result = $this->db->Execute($query);

			if (empty($result)) {
				$error_info = "function=deleteSkills class=Skill.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	}//EO deleteSkills
}

?>
