<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<form action="node_user.php" method="post">
<input type="hidden" name="user_id" value="<?php echo $user['user_id'];?>" />

<div class="col_main">
	<?php
	if (isset($display) && $display == "view_user") {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_user'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<tr>
						<td colspan="2">
							<b><?php echo $user['user_firstname'] . " " . $user['user_surname'];?></b><br />
						</td>
					</tr>
					<tr>
						<td width="40%">
							<?php echo $lang['txt_user_id'];?><br />
						</td>
						<td width="60%">
							<?php echo $user['user_id'];?><br />
						</td>
					</tr>
					<tr>
						<td width="40%">
							<?php echo $lang['txt_user_number'];?><br />
						</td>
						<td width="60%">
							<?php echo $user['user_number'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_user_email'];?><br />
						</td>
						<td>
							<a href="mailto:<?php echo $user['user_email'];?>"><?php echo $user['user_email'];?></a><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_hometown'];?><br />
						</td>
						<td>
							<?php echo $user['user_hometown'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_dob'];?><br />
						</td>
						<td>
							<?php echo $user['user_dob'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_gender'];?><br />
						</td>
						<td>
							<?php echo $user['user_gender'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_language'];?><br />
						</td>
						<td>
							<?php echo $lang['arr_lang_name'][$user['language_id']];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_status'];?><br />
						</td>
						<td>
							<?php echo $lang['arr_user_status'][$user['status_id']];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_role'];?><br />
						</td>
						<td>
							<?php 
							if (isset($lang['arr_acs']['role'][$user['role_id']])) {
								echo $lang['arr_acs']['role'][$user['role_id']];
							}
							?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_user_create_datetime'];?><br />
						</td>
						<td>
							<?php echo $this->date->formatDate($user['user_create_datetime'], 1);?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_file_allocation'];?><br />
						</td>
						<td>
							<?php echo round($user['user_file_allocation']/1000, 2);?>kb<br />
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_profile'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<tr>
						<td valign="top" rowspan="12">
							<img src="get_file.php?file=<?php echo $profile['image']['file'];?>" align="left" border="0" class="picture" alt="<?php echo $profile['image']['file_title'];?>" /><br />
						</td>
						<td>
							<?php echo $lang['txt_profile_name'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_name'];?><br />
						</td>
					</tr>
					
					<tr>
						<td valign="top">
							<?php echo $lang['txt_profile_nic'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_nic'];?><br />
						</td>
					</tr>
					<?php
					if (!empty($lang['txt_profile_text1'])) {
					?>
					<tr>
						<td>
							<?php echo $lang['txt_profile_text1'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_text1'];?><br />
						</td>
					</tr>
					<?php }?>
					
					<?php
					if (!empty($lang['txt_profile_text2'])) {
					?>
					<tr>
						<td>
							<?php echo $lang['txt_profile_text2'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_text2'];?><br />
						</td>
					</tr>
					<?php }?>
					
					<?php
					if (!empty($lang['txt_profile_text3'])) {
					?>
					<tr>
						<td>
							<?php echo $lang['txt_profile_text3'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_text3'];?><br />
						</td>
					</tr>
					<?php }?>
					
					<?php
					if (!empty($lang['txt_profile_text4'])) {
					?>
					<tr>
						<td>
							<?php echo $lang['txt_profile_text4'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_text4'];?><br />
						</td>
					</tr>
					<?php }?>
					
					<?php
					if (!empty($lang['txt_profile_text5'])) {
					?>
					<tr>
						<td>
							<?php echo $lang['txt_profile_text5'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_text5'];?><br />
						</td>
					</tr>
					<?php }?>
					
					<?php
					if (!empty($lang['txt_profile_text6'])) {
					?>
					<tr>
						<td>
							<?php echo $lang['txt_profile_text6'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_text6'];?><br />
						</td>
					</tr>
					<?php }?>
					
					<?php
					if (!empty($lang['txt_profile_text7'])) {
					?>
					<tr>
						<td>
							<?php echo $lang['txt_profile_text7'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_text7'];?><br />
						</td>
					</tr>
					<?php }?>
					
					<?php
					if (!empty($lang['txt_profile_text8'])) {
					?>
					<tr>
						<td>
							<?php echo $lang['txt_profile_text8'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_text8'];?><br />
						</td>
					</tr>
					<?php }?>
					
					<?php
					if (!empty($lang['txt_profile_text9'])) {
					?>
					<tr>
						<td>
							<?php echo $lang['txt_profile_text9'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_text9'];?><br />
						</td>
					</tr>
					<?php }?>
					
					<?php
					if (!empty($lang['txt_profile_text10'])) {
					?>
					<tr>
						<td>
							<?php echo $lang['txt_profile_text10'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_text10'];?><br />
						</td>
					</tr>
					<?php }?>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
			
	<?php
	}
	elseif (isset($display) && $display == "edit_user") {
	?>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_user'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<tr>
						<td colspan="2">
							<b><?php echo $user['user_firstname'] . " " . $user['user_surname'];?></b><br />
						</td>
					</tr>
					<tr>
						<td>
							<label for="id_user_number"><?php echo $lang['txt_user_number'];?></label><br />
						</td>
						<td>
							<input id="id_user_number" type="text" name="user_number" size="30" value="<?php echo $user['user_number'];?>"><br />
						</td>
					</tr>
					<tr>
						<td>
							<label for="id_user_file_allocation"><?php echo $lang['txt_file_allocation'];?></label><br />
						</td>
						<td>
							<input id="id_user_file_allocation" type="text" name="user_file_allocation" size="10" value="<?php echo round($user['user_file_allocation']/1000, 2);?>">&nbsp;kb<br />
						</td>
					</tr>
					<tr>
						<td>
							<label for="id_status"><?php echo $lang['txt_status'];?></label><br />
						</td>
						<td>
							<select id="id_status" name="status_id" size="1">
							<?php foreach($lang['arr_user_status'] as $key => $i): 
							?>
							<option value="<?php echo $key;?>" <? if($user['status_id'] == $key) echo "selected=\"selected\"";?>><?php echo $i;?></option>
							<?php endforeach; ?>
							</select>
							<br />
						</td>
					</tr>
					<tr>
						<td>
							<label for="id_role"><?php echo $lang['txt_role'];?></label><br />
						</td>
						<td>
							<select id="id_role" name="role_id" size="1">
							<?php 
							foreach($lang['arr_acs']['role'] as $key => $i): 
							?>
							<option value="<?php echo $key;?>" <? if($user['role_id'] == $key) echo "selected=\"selected\"";?>><?php echo $i;?></option>
							<?php endforeach; ?>
							</select>
							<br />
						</td>
					</tr>
					<tr>
						<td align="right" colspan="2">
							<input type="submit" name="update_user" value="<?php echo $lang['sub_update_user'];?>" class="button_urgent"><br />
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php
	}
	else {
	?>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_user_list'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($users)) {
				$display_items = trimArray($users);
				?>
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					foreach($display_items as $key => $i):
					?>
					<tr>
						<td valign="top">
							<a href="node_user.php?user_id=<?php echo $i['user_id'];?>"><?php echo $i['user_id'];?></a><br />
						</td>
						<td valign="top">
							<b><?php echo $i['user_firstname'] . " " . $i['user_surname'];?></b><br />
						</td>
						<td>
							<?php echo dots(10, $i['user_hometown']);?><br />
						</td>
						<td valign="top">
							<?php echo $this->date->formatDate($i['user_create_datetime']);?><br />
						</td>
						<td valign="top">
							<?php
							if (isset($lang['arr_lang_name'][$i['language_id']])) {
								echo $lang['arr_lang_name'][$i['language_id']];
							}
							?>
						</td>
						<td valign="top">
							<?php
							if (isset($lang['arr_user_status'][$i['status_id']])) {
								echo $lang['arr_user_status'][$i['status_id']];
							}
							?>
						</td>
						<td valign="top" align="right">
							<?php
							if (isset($lang['arr_acs']['role'][$i['role_id']])) {
								echo $lang['arr_acs']['role'][$i['role_id']];
							}
							?>
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php
				echo createArrayList($users);
				}
				else {
				?>
				<p>
					<?php echo $lang['err_no_users'];?><br />
				</p>
				<?php }?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
</div>

<div class="col_side">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_menu'];?><br />
		</div>

		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($display) && $display == "view_user") {
				?>
				<a href="sn_profile.php?user_id=<?php echo $user['user_id'];?>"><?php echo $lang['href_go_to_user'];?></a><br />
				<a href="node_user.php?edit_user=1&amp;user_id=<?php echo $user['user_id'];?>"><?php echo $lang['href_edit_user'];?></a><br />
				<?php } ?>
				
				<a href="node_register_user.php"><?php echo $lang['href_add'];?></a><br />
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>
</form>
