<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

class Acs {
	// CLASS FUNCTIONS
	// Acs
	// getGroupRoles
	// getGroupRole
	// deleteGroupRole
	// insertGroupRole
	// updateGroupRole
	// insertPermission
	// deletePermissions
	// getPermission
	// checkPermission
	// getAllPermissions
	// findRoleIndex
	// getResources
	// updateGroupDefaultRole
	
	
	
	// Acs --------------------------------------------------------------------
	// the constuctor
	// erik sundelof - 29th Nov 2004
	//
	function Acs($role_id=null, $db=null, $role_type){
		$this->role_id = $role_id;
		$this->db = $db;
		$this->role_type = $role_type;
	}//EO Acs
	
	
	
	// getGroupRoles --------------------------------------------------------------------
	// return array of multiple roles
	// tom calthrop - 4th Nov 2004
	//
	function getGroupRoles() {
		$query = "
			SELECT r.*
			FROM " . $this->db->prefix . "_acs_group_role r
			where
			r.group_id=" . $this->group_id . "
			order by r.role_name"
		;
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				
				array_push($temp, $temp1);
				$result->MoveNext();
			}
			
			$result->Close();
			return $temp;
		
		}
		else {
			$GLOBALS['am_error_log'][] = array(1, 1, $query . "-" . $this->db->ErrorMsg());
		}
	} //EO GetGroupRoles
	
	
	
	// getGroupRole --------------------------------------------------------------------
	// return single group role
	// when joining a group the role_default is the default role that the new member gets
	// tom calthrop - 4th Nov 2004
	//
	function getGroupRole($role_default = null, $role_visitor = null) {
		$query = "
			SELECT r.*
			FROM " . $this->db->prefix . "_acs_group_role r
			where "
		;
		
		if (isset($this->role_id)) {
		    $query .= "r.role_id=" . $this->role_id . " and ";
		}
		
		if (isset($role_default)) {
			$query .= "r.group_id=" . $this->group_id . " and ";
		    $query .= "r.role_default=1 and ";
		}
		elseif (isset($role_visitor)) {
			$query .= "r.group_id=" . $this->group_id . " and ";
		    $query .= "r.role_visitor=1 and ";
		}
		
		$query .= "1=1 ";
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = $result->fields;
			$result->Close();
			return $temp;
		}
		else {
			$GLOBALS['am_error_log'][] = array(1, 1, $query . "-" . $this->db->ErrorMsg());
		}
	}//EO getGroupRole
	
	
	
	// deleteGroupRole --------------------------------------------------------------------
	// delete single group role
	// tom calthrop - 4th Nov 2004
	//
	function deleteGroupRole($data) {
		$query = "
			DELETE FROM " . $this->db->prefix . "_acs_group_role
			WHERE
			role_id=" . $data['role_id']
		;

		$result = $this->db->Execute($query);

	}//EO deleteGroupRole;
	
	
	
	// insertGroupRole --------------------------------------------------------------------
	// insert single group role
	// tom calthrop - 4th Nov 2004
	//
	function insertGroupRole($data, $role_default = null, $role_visitor = null) {
		
		if (isset($role_default)) {
		    $role_default = 1;
		}
		else {
			$role_default = "null";
		}
		
		if (isset($role_visitor)) {
		    $role_visitor = 1;
		}
		else {
			$role_visitor = "null";
		}
		
		$rec = array();
		$rec['role_name'] = $data['role_name'];
		$rec['group_id'] = $this->group_id;
		$rec['role_default'] = $role_default;
		$rec['role_visitor'] = $role_visitor;
		
		$table = $this->db->prefix . "_acs_group_role";
		
		$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
		if (!empty($result)) {
			$this->role_id = $this->db->Insert_ID();
		}
		else {
			$error_info = "function=insertGroupRole class=ACS.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, null, $error_info);
		}
	}//EO insertGroupRole
	
	
	
	// updateGroupRole --------------------------------------------------------------------
	// update single group role
	// tom calthrop - 4th Nov 2004
	//
	function updateGroupRole($data, $role_default = null) {
		
		if (!empty($data['role_default'])) {
		    $role_default = $data['role_default'];
		}
		
		if (isset($role_default)) {
		    $role_default = 1;
		}
		else {
			$role_default = "null";
		}
		
		$query = "
			SELECT * FROM " . $this->db->prefix . "_acs_group_role 
			WHERE 
			role_id=" . $data['role_id']
		;
		
		$result = $this->db->Execute($query);
			
		$rec = array();
		$rec['role_name'] = $data['role_name'];
		$rec['role_default'] = $role_default;
		
		$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
	}//EO updateGroupRole
	
	
	
	// insertPermission --------------------------------------------------------------------
	// insert permission
	// erik sundelof - 4th Nov 2004
	//
	function insertPermission($role_id, $resource_id, $privilege_id) {
		
		$rec = array();
		$rec['role_id'] = $role_id;
		$rec['role_type'] = $this->role_type;
		$rec['resource_id'] = $resource_id;
		$rec['privilege_id'] = $privilege_id;
		
		$table = $this->db->prefix . "_acs_permission";
		
		$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
	}//EO insertPermission
	
	
	
	// deletePermissions --------------------------------------------------------------------
	// delete single group role
	// erik sundelof - 29th Nov 2004
	//
	function deletePermissions() {
	
		$query = "
			DELETE FROM " . $this->db->prefix . "_acs_permission 
			WHERE 
			role_type= " . $this->role_type . " AND "
		;
		
		if (isset($this->role_id)) {
			$query .= "role_id=" . $this->role_id . " AND ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);
	}//EO deletePermissions
	
	
	
	// getPermission --------------------------------------------------------------------
	// get permission
	// tom calthrop - 4th Nov 2004
	//
	function getPermission($role_id, $resource_id, $privilege_id) {
		$query = "
			SELECT rp.*
			FROM " . $this->db->prefix . "_acs_permission rp
			where
			rp.role_id=" . $role_id . " AND 
			rp.resource_id=" . $resource_id . " AND 
			rp.privilege_id=" . $privilege_id . " AND 
			rp.role_type=" . $this->role_type
		;
		$result = $this->db->Execute($query);
		
		if (isset($result->fields) && !empty($result->fields['role_id'])) {
			return 1;
		}
		else {
			return 0;
		}
	} //EO getPermission
	
	
	
	// checkPermission --------------------------------------------------------------------
	// check permission for a given resource and privilege ID
	// erik sundelof - 29th Nov 2004
	//
	function checkPermission($resource_id, $privilege_id) {
		
		$tmp = $this->getPermission($this->role_id, $resource_id, $privilege_id);
		
		if(!empty($tmp)) {
			return true;
		}
		else {
			return false;
		}
	}// EO checkPermission
	
	
	
	// getAllPermissions --------------------------------------------------------------------
	// get all permissions for a given section
	// erik sundelof - 29th Nov 2004
	//
	function getAllPermissions() {
		$query = "
			SELECT rp.*
			FROM " . $this->db->prefix . "_acs_permission rp 
			WHERE 
			rp.role_type=" . $this->role_type
		;
		
		$result = $this->db->Execute($query);
	
		if (isset($result->fields)) {

			$temp = array();

			while (!$result->EOF) {
				
				array_push($temp, $result->fields);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
	}// EO getALLPermissions
	
	
	
	// findRoleIndex --------------------------------------------------------------------
	// find array with index that corresponds to a given role
	// erik sundelof - 29th Nov 2004
	//
	function findRoleIndex($role_id, $output_roles){
		foreach($output_roles as $key => $roles){
			if($roles["role_id"]==$role_id)
				return $key;
		}
	}//EO findRoleIndex
	
	
	
	// getResources --------------------------------------------------------------------
	// get resources and create structure
	// erik sundelof - 30th Nov 2004
	//
	function getResources($config_resources, $resource_privilege, $arr_acs, $output_roles){
	
		if (!empty($config_resources)) {
			$output_resources = array();
			
			if (isset($this->group_id)) {
				$resources = $arr_acs['resource']['group'];
			}
			else {
				$resources = $arr_acs['resource']['node'];
			}
			//loop through the array and get the name, desc from the language file
			foreach($config_resources as $key => $res):
			
				if(!is_array($resources['res'][$res])){
					$temp1['resource_name'] = $resources['res'][$res];
					$temp1['resource_id'] = $res;
					$temp1['resource_desc'] = $resources['desc'][$res];
				}
				else{
					$temp1['resource_name'] = $resources['res'][$res][0]." (sub-resources)";
					$temp1['resource_id'] = $res;
					$temp1['resource_desc'] = $resources['desc'][$res];
				}
				
				//get privileges attached to each resource
				$config_privileges = $resource_privilege[$res];
				
				$temp1['privileges'] = array();
				
				if (!empty($config_privileges)) {
					//loop through the array and get the name from the language file
					foreach($config_privileges as $key1 => $priv):
						$temp2['privilege_name'] = $arr_acs['privilege'][$priv];
						$temp2['privilege_id'] = $priv;
						
						//for each privilege we now see if the permission is set against the role
						if (!empty($output_roles)) {
							$temp2['permissions'] = array();
							
							//loop through the array and check the permission
							foreach($output_roles as $key2 => $role):
								
								if ($this->getPermission($role['role_id'], $res, $priv)) {
									$temp2['permissions'][] = 1;
								}
								else {
									$temp2['permissions'][] = 0;
								}
							endforeach;
						}
						array_push($temp1['privileges'], $temp2);
					endforeach;
				}
				//push this resource info to the main array
				array_push($output_resources, $temp1);
			endforeach;
		}
		else {
			$output_resources = array();
		}
		
		return $output_resources;

	}//EO getResources
	
	
	
	// updateGroupDefaultRole --------------------------------------------------------------------
	// updates the DB with the default group role ID
	// tom calthrop - 22nd December 2004
	//
	function updateGroupDefaultRole($default_role_id) {
		
		$query = "
			SELECT * FROM " . $this->db->prefix . "_acs_group_role 
			WHERE 
			group_id=" . $this->group_id
		;
		
		$result = $this->db->Execute($query);
			
		$rec = array();
		$rec['role_default'] = "null";
		
		$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
		$query = "
			SELECT * FROM " . $this->db->prefix . "_acs_group_role 
			WHERE 
			role_id=" . $default_role_id
		;
		
		$result = $this->db->Execute($query);
			
		$rec = array();
		$rec['role_default'] = 1;
		
		$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
	}//EO updateGroupDefaultRole
}

?>
