<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


/*
* check access code (registered random password)
* if ok, verify new password. If ok, update user password
* add friends
* move to welcome.php
*/

include "inc/header_pre_login.inc.php";




//setup useradmin (extends user)
require_once($c_node['dir']['class_path'] . 'User.class.php');
require_once($c_node['dir']['class_path'] . 'UserAdmin.class.php');
$user = new UserAdmin($db, $date);
$user->node_id = $c_node['node']['node_id'];


//form processing
if (isset($_POST['setup'])) {
	
	$data = $_POST['data'];
	$user->user_id = $data['user_id'];
   	$output_user = $user->getUser();
	
	//check the access code
	$query = "
		SELECT user_id
		FROM " . $db->prefix . "_user
		WHERE
		user_id=" . $data['user_id'] . " AND
		user_password=MD5('" . $data['access_code'] . "')"
	;
	
	$result = $db->Execute($query);
	
	if(!isset($result->fields['user_id']) || $result->fields['user_id'] < 0) {
		$GLOBALS['am_error_log'][] = array(27, null, null);//access code wrong
	}
	
	if(isset($data['user_password1']) && isset($data['user_password2']) && $data['user_password1'] != $data['user_password2']) {
		$GLOBALS['am_error_log'][] = array(15, null, null);
	}

	if(isset($data['user_password1']) && strlen($data['user_password1']) < 5) {
		$GLOBALS['am_error_log'][] = array(16, null, null);
	}
	
	if (!empty($data['to'])) {
		//check for emails
		$emails = trim($data['to']);
		$emails = preg_split("/[\s,]+/", $emails);

		//check each email
		foreach($emails as $key => $i):

			if(!preg_match('/^[-A-Za-z0-9_.]+[@][A-Za-z0-9_-]+([.][A-Za-z0-9_-]+)*[.][A-Za-z]{2,8}$/', $i)) {
				$GLOBALS['am_error_log'][] = array(3, null, $i); //email invalid
			}
		endforeach;
	}
	
	if (empty($GLOBALS['am_error_log'])) {
		
		require_once($languageTextPath . 'message.lang.php');
		
		//setup social network
		require_once($c_node['dir']['class_path'] . 'SocialNetwork.class.php');
		$sn = new SocialNetwork($user->user_id, $db, $c_node['node']['node_id'], $c_node['sn']['max_degree']);
		$sn->relation_type_ids = $c_node['user']['relation_type'];
		$sn->status_ids = $c_node['user']['status'];
		$user->sn = $sn;
		
		//setup statistics
		require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
		$statistic = new Statistic($db, 1, null);
		$user->statistic = $statistic;
		$user->total_login_stat_id = $c_node['statistic']['user']['total_logins'];
		
		//setup instant messaging
		require_once($c_node['dir']['class_path'] . 'IM.class.php');
		$im = new IM($output_user['user_id'], $db, $c_node['messaging']['message_box_max_size']);
		$im->setStatus($c_node['messaging']['message_status_unread'], $c_node['messaging']['message_status_read']);
		$im->setBoxes($c_node['messaging']['message_in_box'], $c_node['messaging']['message_save_box'], $c_node['messaging']['message_out_box']);
		$user->im = $im;
		
		$user->body_welcome_txt = readTxtFile($languageTextPath . "im_welcome.txt.php");
		$user->body_invitee_txt = readTxtFile($languageTextPath . "im_invitee_joined.txt.php");
		$user->user_firstname = $output_user['user_firstname'];
		$user->user_email = $output_user['user_email'];
		$user->user_language_id = $output_user['language_id'];
		$user->subject_im_welcome = $lang['subject_im_welcome'];
		$user->relation_type = $c_node['user']['relation_type'];
		$user->subject_im_joined = $lang['subject_im_joined'];
		$user->status_id = $c_node['user']['status']['active'];
		$user->txt_invite = $lang['txt_invite'];
		$user->user_preference_ids = $c_node['user']['preference'];
		
		$user->setupUser($_POST['data']);
		
		//send the invites
		if (!empty($data['to'])) {
			//setup email
			require_once($c_node['dir']['class_path'] . '/Mail/class.phpmailer.php');
			$mail = new PHPMailer();
			$mail->Host = 		$c_node['mail']['host'];
			$mail->Mailer = 	$c_node['mail']['mailer'];
			
			if (isset($c_node['mail']['smtp']['username'])) {
				$mail->SMTPAuth = true;
				$mail->Username = $c_node['mail']['smtp']['username'];
				$mail->Password = $c_node['mail']['smtp']['password'];
			}
				
			$mail->From = 		$c_node['mail']['no_reply_address'];
			$mail->FromName = 	$c_node['mail']['from_name'];
			$mail->WordWrap = 	$c_node['mail']['wordwrap'];
			$mail->Subject = 	$lang['txt_invite_message_txt'];
			$mail->AddReplyTo	($c_node['mail']['no_reply_address'], $lang['subject_noreply']);
			$mail->language = 	$c_node['mail']['language'];
			$user->mail = $mail;
			
			$user->body_file_mail_txt = readTxtFile($languageTextPath . "mail_invite.txt.php");
			$user->body_file_im_txt = readTxtFile($languageTextPath . "im_invite.txt.php");
		
			$user->subject_im_friendship_invite = $lang['subject_im_friendship_invite'];
			
	    	$user->userSetupInvites($data);
		}
	}
	else { //return vars to form
		$output_data = $data;
		$display = "setup";
	}
	
	if (empty($GLOBALS['am_error_log'])) {
	   	$user->relation_type = $c_node['user']['relation_type']['approved'];
		$user->total_login_stat_id = $c_node['statistic']['user']['total_logins'];

		$user->loginUser($output_user['user_email'],$data['user_password1'], $c_node['node']['node_id']);
	}
}
elseif (isset($_REQUEST['em'])) {
	//get user
	$user->user_email = $_REQUEST['em'];
	$output_user = $user->getUser();

	if ($output_user['status_id'] == $c_node['user']['status']['pending']) { //we can set up
		$display = "setup";
	}
	else{ //you have already setup.
		$display = "setup_already";
	}


}
else { //we error becuase we did not get the right vars passed to the page
	header("Location: index.php");
	exit;
}



//TEMPLATE
if ($c_node['node']['allow_setup_invites'] == 1) {
   $body->set('allow_setup_invites', 1);
}

if (isset($output_user)) {
    $body->set('user', $output_user);
}

if (isset($display)) {
    $body->set('display', $display);
}

if (isset($output_data)) {
    $body->set('formdata', $output_data);
}

$body->set('cron_enabled', $c_node['cron']['enabled']);

include "inc/footer_pre_login.inc.php";

?>

