<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_sn.inc.php";


//append language setup
require_once($languageArrayPath . 'arr_user.lang.php');


//setup bookmark items
require_once($c_node['dir']['class_path'] . 'Bookmark.class.php');
$bookmark = new Bookmark($db, null, $date, $user_id);
$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];

//get recommended item ids
$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
$blog_ids = $bookmark->getBookmarks();

$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
$schedule_ids = $bookmark->getBookmarks();

$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
$library_ids = $bookmark->getBookmarks();

$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
$subject_ids = $bookmark->getBookmarks();

$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['poll'];
$poll_ids = $bookmark->getBookmarks();

//setup file
$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][3]['name'];


//setup forum
require_once($c_node['dir']['class_path'] . 'Forum.class.php');
$forum = new Forum($db, $c_node['rsp']['item_type']['forum'], $date, $file);


//setup blog
require_once($c_node['dir']['class_path'] . 'Blog.class.php');
$blog = new Blog($db, $c_node['rsp']['item_type']['blog'], $date, $file);
$blog->user_id = $user_id;

//library setup
require_once($c_node['dir']['class_path'] . 'Library.class.php');
$library = new Library($db, $c_node['rsp']['item_type']['library'], $date, $file);
$library->user_id = $user_id;


//event setup
require_once($c_node['dir']['class_path'] . 'Schedule.class.php');
$schedule = new Schedule($db, $c_node['rsp']['item_type']['schedule'], $date, $file);
$schedule->user_id = $user_id;


// poll setup
require_once($c_node['dir']['class_path'] . 'Poll.class.php');
$poll = new Poll($db, $c_node['rsp']['item_type']['poll'], $date);
$poll->user_id = $user_id;


//get recommended user blogs
if (!empty($blog_ids)) {
	$blog->blog_ids = $blog_ids;
	$output_blogs = $blog->selBlogs();
}
//get recommended subjects
if (!empty($subject_ids)) {
	$forum->subject_ids = $subject_ids;
	$output_subjects = $forum->selSubjects();
}
//get recommended group library items
if (!empty($library_ids)) {
	$library->library_ids = $library_ids;
	$output_library_items = $library->selLibraryItems();
}
//get recommended events
if (!empty($schedule_ids)) {
	$schedule->schedule_ids = $schedule_ids;
	$output_schedule_items = $schedule->selScheduleItems();
}
//get recommended polls
if (!empty($poll_ids)) {
	$poll->poll_ids = $poll_ids;
	$output_polls = $poll->selPolls();
}


//move to template
if (isset($output_subjects)) {
	$body->set('subjects', $output_subjects);
}

if (isset($output_library_items)) {
	$body->set('library', $output_library_items);
}

if (isset($output_schedule_items)) {
	$body->set('schedule_items', $output_schedule_items);
}

if (isset($output_blogs)) {
	$body->set('blogs', $output_blogs);
}

if (isset($output_polls)) {
	$body->set('polls', $output_polls);
}

if (!empty($output_profile)) {
   $body->set('profile', $output_profile);
}

if (!empty($output_relationship)) {
    $body->set('relationship', $output_relationship);
}

if (!empty($output_statistic)) {
	$body->set('profile_statistic', $output_statistic);
}

$template_pageLink =  $lang['txt_recommended'];
$template_pageLinkNote = $lang['txt_recommended'] . ": " . $output_profile['profile_nic'];

include "inc/footer.inc.php";

?>
