<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_frm.inc.php";

if (!empty($_REQUEST['group_id'])) { // page under group section
    
	if (!isset($_REQUEST['subject_id'])) {
		header("Location: frm_list.php?group_id=" . $_REQUEST['group_id'] . "&" . SID);
		exit;
	}
	
	//ACS check
	if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_forum'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
		header("Location: g_group.php?group_id=" . $_REQUEST['group_id']."&".SID);
		exit;
	}
	
	//ACS check
	if ($group_acs->checkPermission($c_acs['arr_acs']['resource']['group_forum'], $c_acs['arr_acs']['privilege']['allow_hidden'])) { //resourece_id, Priv_id
		$forum->include_hidden = 1;
	}
}
else {
	if (!isset($_REQUEST['subject_id'])) {
		header("Location: frm_list.php?" . SID);
		exit;
	}
}


//setup comment
require_once($c_node['dir']['class_path'] . 'Comment.class.php');
$comment = new Comment($db, $c_node['rsp']['item_type']['forum'], $date);
$comment->user_id = $me['user_id'];
if (isset($group_id)) {
    $comment->group_id = $group_id;
}


if (isset($_POST['preview'])) {
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	$output_comment['display_comment_body'] = nl2br(htmlspecialchars($output_comment["comment_body"], ENT_QUOTES));
	$output_comment['comment_body'] = str_replace ('"', '&quot;', $output_comment['comment_body']);
	
	$display = "preview_comment";

}
elseif (isset($_POST['insert'])) {
	$comment->item_id = $forum->subject_id;
	$comment->insertComment($frmdata);
		
	if (empty($GLOBALS['am_error_log'])) {
		//setup statistics
		require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
		$statistic = new Statistic($db, $date);
		//update stats
		if (!empty($_REQUEST['group_id'])) { // page under group section
			//group member comments
			unset($comment->rsp_item_type_id, $comment->item_id);
			$comment->user_id = $me['user_id'];
			$statistic->statistic_type_id = $c_node['statistic']['group_member']['total_comments'];
			$statistic->user_id = $me['user_id'];
			$statistic->setStatistic($comment->getCommentCount());
			//group stats
			unset($comment->user_id, $statistic->user_id);
			$statistic->statistic_type_id = $c_node['statistic']['group']['total_comments'];
			$statistic->setStatistic($comment->getCommentCount());
		}

		$statistic->statistic_type_id = $c_node['statistic']['user']['total_comments'];
		$comment->user_id = $me['user_id'];
		unset($comment->item_id, $comment->rsp_item_type_id, $comment->section_id, $comment->section_item_id);
		$statistic->user_id = $me['user_id'];
		$statistic->setStatistic($comment->getCommentCount());
		
		if (!empty($_REQUEST['group_id'])) { // page under group section
			return header("Location: frm_item.php?group_id=". $_REQUEST['group_id'] . "&subject_id=". $forum->subject_id . "&" . SID);
		}
		else {
			return header("Location: frm_item.php?subject_id=". $forum->subject_id . "&" . SID);
		}	
		exit;
	}
}
elseif (isset($_POST['edit_again'])) {
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
}
elseif (isset($_POST['delete_subject'])) {
	$forum->deleteSubject($forum->subject_id);
	
	if (!empty($_REQUEST['group_id'])) { // page under group section
		return header("Location: frm_list.php?group_id=". $_REQUEST['group_id'] . "&user_id=". $forum->user_id . "&" . SID);
	}
	else {
		return header("Location: frm_list.php?user_id=". $forum->user_id . "&" . SID);
	}	
	exit;
}




//get subject
$output_subject = $forum->getSubject();

if (isset($output_subject)) {
	//get the group and/or the author
	$user->user_id = $output_subject['user_id'];
	$output_author = $user->getProfile();
	
	
	//setup bookmarks --------------------------------------------------
	require_once($c_node['dir']['class_path'] . 'Bookmark.class.php');
	$bookmark = new Bookmark($db, $c_node['rsp']['item_type']['forum'], $date, $me['user_id']);
	$bookmark->item_id = $forum->subject_id;
	
	//watching
	$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
	//set or unset bookmarks
	if (isset($_REQUEST['watch'])) {
		$bookmark->insertBookmark();
	}
	elseif (isset($_REQUEST['unwatch'])) {
		$bookmark->deleteBookmark();
	}
	//get and update bookmark
	if ($bookmark->getBookmark()) {
		$bookmark->updateBookmark();
		$tpl->set('toolbar_watch', 1);
	}
	
	//recommended
	$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
	//set or unset bookmarks
	if (isset($_REQUEST['recommend'])) {
		$bookmark->insertBookmark();
	}
	elseif (isset($_REQUEST['unrecommend'])) {
		$bookmark->deleteBookmark();
	}
	//get and update bookmark
	if ($bookmark->getBookmark()) {
		$bookmark->updateBookmark();
		$tpl->set('toolbar_recommend', 1);
	}
	
	//get comments
	unset($comment->user_id);
	$output_comments = $comment->selComments($forum->subject_id);
	
	
	$forum->topic_id = $output_subject['topic_id'];
	
	//get subject image
	if (isset($output_subject['file_id'])) {
		$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
		$file->file_id = $output_subject['file_id'];
		$output_subject['image'] = $file->getFileRecord();
	}
	
	
	//get RSP items if I am looking at my blog
	if ($output_subject['user_id'] == $me['user_id']) {
		require_once($languageArrayPath . 'arr_rsp.lang.php');
		require_once($c_node['dir']['class_path'] . 'Rsp.class.php');
		$rsp = new Rsp($db, $c_node['rsp']['item_type']['forum']);
		$output_subject['rsp'] = $rsp->selRspItem($forum->subject_id);
		
		$body->set('rsp_config', $c_node['rsp']); 
	}
}

unset($forum->file);
$output_subjects = $forum->selSubjects();

$output_topics = $forum->getTopics();




//move to template
if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($output_subject)) {
	$body->set('subject', $output_subject);
}

if (!empty($output_subjects)) {
	$body->set('subjects', $output_subjects);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_comment)) {
	$body->set('comment', $output_comment);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($output_topics)) {
	$body->set('topics', $output_topics);
}

if (!empty($output_author)) {
	$body->set('author', $output_author);
}

if (isset($output_subject['subject_id'])) {
	$template_pageLink = $lang['txt_subject'];
	$template_pageLinkNote = $output_subject['subject_title'];


	//setup print options
	$tpl->set('toolbar_print', 'print_item.php?subject_id=' . $output_subject['subject_id']);
	$tpl->set('toolbar_printc', 'print_item.php?subject_id=' . $output_subject['subject_id'] . '&amp;inc_comment=1');
	
	if (isset($_REQUEST['group_id'])) {
		$tpl->set('toolbar_bookmark_url', 'frm_item.php?group_id=' . $_REQUEST['group_id'].'&amp;subject_id=' . $output_subject['subject_id']);
	}
	else {
		$tpl->set('toolbar_bookmark_url', 'frm_item.php?subject_id=' . $output_subject['subject_id']);
	}
}

include "inc/footer.inc.php";

?>
