<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";


//append language setup
require_once($languageArrayPath . 'arr_category.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');


$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][1]['name'];


//setup Wiki
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');
$wiki =& new Text_Wiki();
$wiki->disableRule('freelink');
$wiki->disableRule('wikilink');
$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'group/');
$wiki->setRenderConf('xhtml', 'swf', 'base', $c_node['dir']['asset_path'] . 'group/');

$output_group['group_home_synopsis'] = $wiki->transform($output_group['group_home_synopsis'], 'Xhtml');
	


//get group image
if (!empty($output_group['file_id'])) {
	$file->file_id = $output_group['file_id'];
	$output_group['image'] = $file->getFileRecord();
}
else {
	$output_group['image']['file_title'] = "";
	$output_group['image']['file'] = $file->noimage;
}


$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][3]['name'];


//setup statistics
require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
$statistic = new Statistic($db, null, $date);
$statistic->group_id = $group_id;
$output_statistic = $statistic->getStatistics();


//get subjects  -----------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Forum.class.php');
$forum = new Forum($db, $c_node['rsp']['item_type']['forum'], $date, $file);
$forum->rsp_level_id = $c_node['rsp']['rsp_level']['group']['home'];
$forum->rsp_status_id = $c_node['rsp']['status']['live'];
$forum->group_id = $group_id;
$forum->limit = 10;
$output_subjects = $forum->selRspSubjects();


//get blogs -----------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Blog.class.php');
$blog = new Blog($db, $c_node['rsp']['item_type']['blog'], $date, $file);
$blog->rsp_level_id = $c_node['rsp']['rsp_level']['group']['home'];
$blog->rsp_status_id = $c_node['rsp']['status']['live'];
$blog->group_id = $group_id;
$blog->limit = 10;
$output_blogs = $blog->selRspBlogs();


//get group poll ids -----------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Poll.class.php');
$poll = new Poll($db, $c_node['rsp']['item_type']['poll'], $date);
$poll->order_by = "poll_start_datetime desc";
$poll->rsp_level_id = $c_node['rsp']['rsp_level']['group']['home'];
$poll->rsp_status_id = $c_node['rsp']['status']['live'];
$poll->group_id = $group_id;
$poll->limit = 10;
$output_polls = $poll->selRspPolls();


//get library items -----------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Library.class.php');
$library = new Library($db, $c_node['rsp']['item_type']['library'], $date, $file);
$library->rsp_level_id = $c_node['rsp']['rsp_level']['group']['home'];
$library->rsp_status_id = $c_node['rsp']['status']['live'];
$library->group_id = $group_id;
$library->limit = 10;
$output_library_items = $library->selRspLibraryItems();


//schedule setup ----------------------------------------------------------------
require_once($c_node['dir']['class_path'] . 'Schedule.class.php');
$schedule = new Schedule($db, $c_node['rsp']['item_type']['schedule'], $date, $file);
$schedule->rsp_level_id = $c_node['rsp']['rsp_level']['group']['home'];
$schedule->rsp_status_id = $c_node['rsp']['status']['live'];
$schedule->group_id = $group_id;
$schedule->limit = 10;
$schedule->schedule_type_id = $c_node['schedule']['type']['event'];
$output_activities = $schedule->selRspScheduleItems();
$schedule->schedule_type_id = $c_node['schedule']['type']['task'];
$output_tasks = $schedule->selRspScheduleItems();


//get the user details for the rss feed link
$user->user_id = $me['user_id'];
$output_user = $user->getUser();
	

//move to template
if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($output_subjects)) {
	$body->set('subjects', $output_subjects);
}

if (!empty($output_library)) {
	$body->set('library', $output_library);
}

if (!empty($output_activities)) {
	$body->set('activities', $output_activities);
}

if (!empty($output_tasks)) {
	$body->set('tasks', $output_tasks);
}

if (!empty($output_statistic)) {
	$body->set('group_statistic', $output_statistic);
}

if (!empty($output_blogs)) {
	$body->set('blogs', $output_blogs);
}

if (!empty($output_polls)) {
	$body->set('polls', $output_polls);
}

if (!empty($output_user)) {
	$body->set('user', $output_user);
}

if (!empty($output_group['group_title'])) {
	$template_pageLink = $lang['txt_group'];
	$template_pageLinkNote = $output_group['group_title'];
}

include "inc/footer.inc.php";

?>
