<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------



class Comment {
	// CLASS FUNCTIONS
	// Comment
	// getCommentCount
	// selComments
	// insertComment
	
	
	
	// Comment --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 23rd December 2004
	//
	function Comment($db, $rsp_item_type_id, $date) {
		$this->db = $db;
		$this->rsp_item_type_id = $rsp_item_type_id;
		$this->date = $date;
	}//EO Comment

	
	
	// getCommentCount --------------------------------------------------------------------
	// returns a count if a particular item
	// tom calthrop - 23rd December 2004
	//
	function getCommentCount($item_id = null, $lastviewdate = null) {
		
		if (!isset($item_id) && isset($this->item_id)) {
		    $item_id = $this->item_id;
		}
		
		$query = "
			SELECT count(comment_id) as total 
			FROM " . $this->db->prefix . "_comment 
			where "
		;
		
		if (isset($this->rsp_item_type_id)) {
			$query .= "rsp_item_type_id=" . $this->rsp_item_type_id . " AND ";
		}
		
		if (isset($this->rsp_item_type_ids)) { //used for bookmarks
			$rsp_item_type_ids = "";
			foreach($this->rsp_item_type_ids as $key => $i):
				$rsp_item_type_ids .= $i;
				if (count($this->rsp_item_type_ids) > $key+1) {
					$rsp_item_type_ids .=",";
				}
			endforeach;
			$query .= "rsp_item_type_id in (" . $rsp_item_type_ids . ") AND ";
		}
		
		
		if (isset($this->group_id)) {
			$query .= "group_id=" . $this->group_id . " AND ";
		}
		
		if (isset($item_id)) {
			$query .= "item_id=" . $item_id . " and ";
		}
		
		if (isset($this->user_id)) {
			$query .= "user_id=" . $this->user_id . " and ";
		}
		
		if (isset($lastviewdate)) {
			$query .= "comment_create_datetime > '" . $lastviewdate . "' AND ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);

		if (isset($result->fields['total'])) {
			
			return $result->fields['total'];
		}
		else {
			$error_info = "function=getCommentCount class=Comment.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getCommentCount

	
	
	// selComments --------------------------------------------------------------------
	// returns a count if a particular item
	// tom calthrop - 23rd December 2004
	//
	function selComments($item_id = null) {
		
		if (!isset($item_id) && isset($this->item_id)) {
		    $item_id = $this->item_id;
		}
		
		$query = "
			SELECT c.comment_id, c.comment_parent_id, c.comment_body, c.user_id, c.item_id, 
			c.comment_create_datetime, c.rsp_item_type_id, 
			p.profile_nic, p.profile_hometown, p.profile_create_datetime 
			FROM " . $this->db->prefix . "_comment c, " . $this->db->prefix . "_user_profile p "
		;
		
		if (isset($this->group_id)) {
		    $query .= "
				LEFT JOIN " . $this->db->prefix . "_group_membership gm ON c.user_id=gm.user_id "
			;
		}
		
		$query .= "WHERE ";
		
		if (isset($this->group_id)) {
		    $query .= "
				gm.profile_id=p.profile_id AND 
				gm.group_id=" . $this->group_id . " AND "
			;
		}
		else {
		    $query .= "c.user_id=p.user_id AND p.profile_default=1 AND ";
		}
		
		if (isset($this->user_id)) {
		    $query .= "c.user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->no_user_id)) {
		    $query .= "c.user_id!=" . $this->no_user_id . " AND ";
		}
		
		if (isset($this->rsp_item_type_id)) {
			$query .= "c.rsp_item_type_id=" . $this->rsp_item_type_id . " AND ";
		}
		
		if (isset($item_id)) {
			$query .= "c.item_id=" . $item_id . " and ";
		}
		
		$query .= "1=1 ";
		//echo $query;
		if (isset($this->orderby)) {
			$query .= "order by " . $this->orderby;
		}
		else {
			$query .= "order by c.comment_create_datetime";
		}
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		} else {
			$result = $this->db->Execute($query);
		}

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				
				$temp1['comment_create_datetime'] = $this->date->formatDate($temp1['comment_create_datetime'], 1);
				$temp1['profile_create_datetime'] = $this->date->formatDate($temp1['profile_create_datetime']);
				
				$temp1['comment_body'] = nl2br($temp1['comment_body']);
				
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
			
		}
		else {
			$error_info = "function=selComments class=Comment.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO selComments
	
	
	
	// insertComment --------------------------------------------------------------------
	// inserts a comment
	// tom calthrop - 24th December 2004
	//
	function insertComment($data) {
		if (empty($data['comment_body'])) {
		    $GLOBALS['am_error_log'][] = array(12, null, null);
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			
			$datetime = date("Y-m-d H:i:s");
			$datetime = $this->db->DBDate($datetime);
	
			$data['comment_body'] = htmlspecialchars($data['comment_body']);
			
			if (isset($this->group_id)) {
			    $group_id = $this->group_id;
			}
			else {
				$group_id = "null";
			}
			
			$query = "
				INSERT INTO " . $this->db->prefix . "_comment (
				item_id, 
				group_id, 
				rsp_item_type_id, 
				comment_body, 
				comment_create_datetime, 
				user_id
				) values (
				" . $this->item_id . ",
				" . $group_id . ",
				" . $this->rsp_item_type_id . ",
				'" . $data['comment_body'] . "',
				" . $datetime . ",
				" . $this->user_id . ")"
			;
			
			$result = $this->db->Execute($query);
	
			if (empty($result)) {
				$error_info = "function=insertComment class=Comment.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	}//EO insertComment

	
	
	// getComment --------------------------------------------------------------------
	// returns a row
	// tom calthrop - 23rd December 2004
	//
	function getComment($item_id = null, $profile_type=null) {
		
		if (!isset($item_id) && isset($this->item_id)) {
		    $item_id = $this->item_id;
		}
		
		$query = "
			SELECT comment_id, comment_create_datetime 
			FROM " . $this->db->prefix . "_comment 
			WHERE 
			rsp_item_type_id=" . $this->rsp_item_type_id . " AND 
			item_id=" . $item_id
		;
		
		$result = $this->db->SelectLimit($query, 1);

		if (isset($result->fields)) {
			$temp = $result->fields;
			
			$temp['comment_create_datetime'] = $this->date->formatDate($temp['comment_create_datetime']);
			
			$result->Close();
			return $temp;
			
		}
		else {
			$error_info = "function=getComment class=Comment.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getComment
}
?>
