<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "user";

include "inc/header.inc.php";
require_once($c_node['class_dir'] . 'User/Blog.class.php');
require_once($c_node['class_dir'] . 'Group/Group.class.php');
require_once($c_node['class_dir'] . 'Poll.class.php');

//append language setup
require_once($languageArrayPath . 'arr_user_online_status.lang.php');
require_once($languageArrayPath . 'arr_links.lang.php');
require_once($languageArrayPath . 'arr_genre.lang.php');
require_once($languageArrayPath . 'arr_group_type.lang.php');


//setup poll
$poll = new Poll();
$poll->db = $db;
$poll->date = $date;


//friends
$user->limit = 2;
$user->orderby = "user_create_datetime desc";
$output_friends = $user->getSocialNetwork($user_id);

//setup blog
$blog = new Blog($me['user_id'], $db, $date);
$blog->publish = $c_node['user_publish']['all'];
$blog->limit = 2;
$blogs_latest = $blog->getBlogs();

//get featured images
if (isset($blogs_latest[0])) {
	if ($blogs_latest[0]['blog_image_id']) {
		$blogs_latest[0]['image'] = $image->getImage($blogs_latest[0]['blog_image_id'], 't2', 'user', $blogs_latest[0]['user_id']);
	}

	if (!isset($blogs_latest[0]['image']['image_id'])) {
		$blogs_latest[0]['image']['image'] = "blog/no_blog_t2.gif";
		$blogs_latest[0]['image']['image_title'] = $blogs_latest[0]['blog_title'];
	}
}

if (isset($blogs_latest[1])) {
	if ($blogs_latest[1]['blog_image_id']) {
		$blogs_latest[1]['image'] = $image->getImage($blogs_latest[1]['blog_image_id'], 't2', 'user', $blogs_latest[1]['user_id']);
	}

	if (!isset($blogs_latest[1]['image']['image_id'])) {
		$blogs_latest[1]['image']['image'] = "blog/no_blog_t2.gif";
		$blogs_latest[1]['image']['image_title'] = $blogs_latest[1]['blog_title'];;
	}

}


//get latest groups
$lastest_groups = getLatestGroups($c_node['group_status']['active']);


//get recommended discussions
$discussions_recommended = getRecommendedSubjects($c_node['group_status']['active'], $c_node['group_type']['node_home']);


//move to template
if (isset($output_user)) {
    $body->set('user', $output_user);
}

if (isset($lastest_groups)) {
	$body->set('latest_groups', $lastest_groups);
}

if (isset($output_friends)) {
	$body->set('friends', $output_friends);
}

if (isset($blogs_latest)) {
	$body->set('blogs', $blogs_latest);
}

if (isset($discussions_recommended)) {
	$body->set('discussions_recommended', $discussions_recommended);
}

$template_pageLink = $lang['txt_welcome'] . " " . $output_user['user_firstname'] . "!";
include "inc/footer.inc.php";



/*
* getLatestGroups
* Tom Calthrop 7th April 2004
*/
function getLatestGroups ($group_status) {

	global $db, $me, $c_node, $log;

	$query = "
		SELECT g.group_title, g.group_synopsis, g.group_id, g.genre_id, g.group_type,
		g.group_create_datetime, g.group_image_id, g.group_from_age, g.group_to_age
		FROM " . $db->prefix . "_group g
		WHERE
		g.group_status=" . $group_status . " and
		(g.group_type=" . $c_node['group_type']['open'] . " or
		g.group_type=" . $c_node['group_type']['registration_required'] . ")
		order by g.group_create_datetime desc limit 3"
		;


	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {

		$temp = array();

		while (!$result->EOF) {

			$temp1 = $result->fields;

			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
}//EO getLatestGroups();





/*
* getRecommendedSubjects
* Tom Calthrop 7th April 2004
*/
function getRecommendedSubjects ($group_status, $level_id) {

	global $db, $me, $image, $c_node, $poll, $log;
	$query = "
				SELECT s.subject_title, s.subject_id, s.subject_body,
				s.poll_id, t.topic_body, t.topic_id, g.group_id
				FROM " . $db->prefix . "_forum_subject s
				RIGHT JOIN " . $db->prefix . "_forum_topic t ON s.topic_id=t.topic_id
				RIGHT JOIN " . $db->prefix . "_forum_section fs ON t.section_id=fs.section_id
				RIGHT JOIN " . $db->prefix . "_group g ON fs.group_id=g.group_id
				where
				g.group_status=" . $group_status . " and
				(g.group_type=" . $c_node['group_type']['open'] . " or
				g.group_type=" . $c_node['group_type']['registration_required'] . ") and
				s.level_id=" . $level_id . "
				order by s.subject_title limit 2"
				;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {

		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;
			$temp1['subject_body'] = nl2br($temp1['subject_body']);

			if (isset($temp1['poll_id']) && $temp1['poll_id'] > 0) {
				$poll->poll_id = $temp1['poll_id'];
		    	$temp1['poll'] = $poll->getPoll();
			}

			array_push($temp, $temp1);
			$result->MoveNext();
		}
		$result->Close();

		return $temp;
	}
} //EO recommendedSubjects();


?>
