<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "group";
include "inc/header.inc.php";

require_once($c_node['class_dir'] . 'Poll.class.php');
require_once($c_node['class_dir'] . 'Group/Forum.class.php');


//append language setup
require_once($languageArrayPath . 'arr_user_priv.lang.php');
require_once($languageArrayPath . 'arr_group_type.lang.php');
require_once($languageArrayPath . 'arr_group_statistics.lang.php');
require_once($languageArrayPath . 'arr_genre.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');


//setup poll
$poll = new Poll();
$poll->db = $db;
$poll->date = $date;


//setup group
if (isset($output_group['group_image_id'])) {
	$output_group['image'] = $image->getImage($output_group['group_image_id'], 't1', 'group', $output_group['group_id']);
}


//update bookmarks
if (isset($_REQUEST['watch'])) {
	$group->updateBookmark('watch');
}
elseif (isset($_REQUEST['recommend'])) {
	$group->updateBookmark('recommend');
}
elseif (isset($_REQUEST['unwatch'])) {
	$group->updateBookmark('unwatch');
}
elseif (isset($_REQUEST['unrecommend'])) {
	$group->updateBookmark('unrecommend');
}

//movement
$output_group['bookmarks'] = $group->getBookmarks();


//recommended forum
$output_topics = recommendedTopics ($group_id, $c_node['level_id_local_homepage']);
$output_subjects = recommendedSubjects ($group_id, $c_node['level_id_local_homepage']);

//recommended event
$output_event = recommendedEvent ($group_id, $c_node['level_id_local_homepage']);

//recommended event
$output_library = recommendedLibrary ($group_id, $c_node['level_id_local_homepage']);

//group statistics
$output_statistic = $group->groupStatistics();


//move to template
if (isset($output_group_member_level)) {
	$body->set('group_member_level', $output_group_member_level);
}

if (isset($output_group)) {
	$body->set('group', $output_group);
}

if (isset($output_topics)) {
	$body->set('topics', $output_topics);
}

if (isset($output_subjects)) {
	$body->set('subjects', $output_subjects);
}

if (isset($output_library)) {
	$body->set('library', $output_library);
}

if (isset($output_event)) {
	$body->set('events', $output_event);
}

if (isset($output_statistic)) {
	$body->set('group_statistic', $output_statistic);
}


if (isset($output_group['group_title'])) {
	$template_pageLink = $lang['txt_group'];
	$template_pageLinkNote = $output_group['group_title'];
}

if (isset($group->log)) {
	$log = $group->log;
}

include "inc/footer.inc.php";



/*
* recommendedTopics
* Tom Calthrop 7th April 2004
*/
function recommendedTopics ($group_id, $homepage) {

	global $db, $me, $image, $log;

	$query = "
				SELECT t.topic_title, t.topic_id, t.topic_body, t.topic_image_id, fs.group_id
				FROM " . $db->prefix . "_forum_topic t
				LEFT JOIN " . $db->prefix . "_forum_section fs ON t.section_id=fs.section_id
				where
				t.level_id=" . $homepage . " and
				fs.group_id=" . $group_id . "
				order by t.topic_title"
				;

	$result = $db->Execute($query);

	if (isset($result->fields)) {

		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;
			$temp1['topic_body'] = nl2br($temp1['topic_body']);

			if ($temp1['topic_image_id']) {
			    $temp1['image'] = $image->getImage($temp1['topic_image_id'], 't2', 'group', $temp1['group_id']);
			}
			array_push($temp, $temp1);
			$result->MoveNext();
		}
		$result->Close();

		return $temp;
	}
}//EO recommendedTopics();


/*
* recommendedSubjects
* Tom Calthrop 7th April 2004
*/
function recommendedSubjects ($group_id, $homepage) {

	global $db, $me, $image, $poll, $log;
	$query = "
				SELECT s.subject_title, s.subject_id, s.subject_body, s.poll_id, t.topic_body, t.topic_id
				FROM " . $db->prefix . "_forum_subject s
				LEFT JOIN " . $db->prefix . "_forum_topic t ON s.topic_id=t.topic_id
				LEFT JOIN " . $db->prefix . "_forum_section fs ON t.section_id=fs.section_id
				where
				s.level_id=" . $homepage . "  and
				fs.group_id=" . $group_id . "
				order by s.subject_title"
				;

	$result = $db->Execute($query);

	if (isset($result->fields)) {

		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;
			$temp1['subject_body'] = nl2br($temp1['subject_body']);

			if (isset($temp1['poll_id'])) {
				$poll->poll_id = $temp1['poll_id'];
		    	$temp1['poll'] = $poll->getPoll();
			}

			array_push($temp, $temp1);
			$result->MoveNext();
		}
		$result->Close();

		return $temp;
	}
} //EO recommendedSubjects();



/*
* recommendedEvent
* Tom Calthrop 7th April 2004
*/
function recommendedEvent ($group_id, $homepage) {

	global $db, $me, $image, $date, $log;

	$query = "
				SELECT e.event_title, e.event_id, e.event_description,
				e.event_start_datetime,
				e.event_image_id, e.group_id
				FROM " . $db->prefix . "_event e
				where
				e.level_id>=" . $homepage . " and
				e.group_id=" . $group_id . "
				order by e.event_start_datetime"
				;

	$result = $db->Execute($query);

	if (isset($result->fields)) {

		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;
			$temp1['event_description'] = nl2br($temp1['event_description']);
			$temp1['event_start_datetime'] = $date->formatDate($temp1['event_start_datetime']);

			if ($temp1['event_image_id']) {
			    $temp1['image'] = $image->getImage($temp1['event_image_id'], 't2', 'group', $temp1['group_id']);
			}
			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
}// EO recommendedEvent();


/*
* recommendedLibrary
* Tom Calthrop 7th April 2004
*/
function recommendedLibrary ($group_id, $homepage) {

	global $db, $me, $image, $log;

	$query = "
		SELECT l.library_title, l.library_synopsis, l.library_id, l.library_image_id,
		l.library_page_name, l.group_id
		FROM " . $db->prefix . "_group_library l
		where
		l.level_id=" . $homepage . " and
		l.group_id=" . $group_id . "
		group by l.library_page_name
		order by l.library_title"
	;
	//echo $query;
	$result = $db->Execute($query);

	if (isset($result->fields)) {

		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;

			if ($temp1['library_image_id']) {
			    $temp1['image'] = $image->getImage($temp1['library_image_id'], 't2');
			}

			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
}// EO recommendedLibrary();



?>
