<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------



class Group {

	var $group_id, $db, $query, $result, $temp, $date, $image_id, $node_id, $group_status, $ftp, $log;

	function Group($group_id = null) {
		$this->group_id = $group_id;
	}


	/*
	* GROUP DETAILS
	* tom calthrop
	* 21st Feb 2004
	*/
	function groupDetails () {
		$query = "
			SELECT g.*
			FROM " . $this->db->prefix . "_group g
			where
			g.group_id=" . $this->group_id
		;

		$result = $this->db->Execute($query);
	
		if (isset($result->fields)) {
			$temp = $result->fields;
			$temp['group_create_datetime'] = $this->date->formatDate($temp['group_create_datetime']);
			$temp['display_group_election_date'] = $this->date->formatDate($temp['group_election_date']);
			$temp['display_group_rules'] = nl2br($temp['group_rules']);
			
			return $temp;
		}
		else {
			$this->log[]  = array('error', 1, $query . "-" . $this->db->ErrorMsg(), null);
		}
		
		$result->Close();
		
	}


	/*
	* IS THE USER A MEMBER OF THE GROUP, RETURN LEVEL
	* tom calthrop
	* 21st Feb 2004
	*/
	function groupMemberLevel ($user_id, $group_type, $group_type_ids, $group_level_ids, $my_user_level) {
		$query = "
			SELECT gm.level_id
			FROM " . $this->db->prefix . "_group_member gm
			where
			gm.group_id=" . $this->group_id . " and
			gm.user_id=" . $user_id
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			$temp = $result->fields;
			$user_level_id = $temp['level_id'];

			//we will overrule if I am a node admin
			if ($my_user_level >= $group_level_ids['node_administrator']) {
		    	$user_level_id = $group_level_ids['node_administrator'];
			}

			//barred
			if ($user_level_id == $group_level_ids['barred']) {
		    	header("Location: g_groups.php?" . SID);
				exit;
			}

			//closed group, no membership
			if (($group_type == $group_type_ids['closed']) && ($user_level_id < $group_level_ids['member'])) {
		    	header("Location: g_groups.php?" . SID);
				exit;
			}

			//register group, no membership
			if (($group_type == $group_type_ids['registration_required']) && ($user_level_id < $group_level_ids['member'])) {

				if (substr(basename($_SERVER['REQUEST_URI']), 0,7) != "g_apply") {
				    header("Location: g_apply.php?group_id=" . $this->group_id . "&amp;" . SID);
					exit;
				}
			}


			if (!isset($temp['level_id']) && $group_type_ids['open']) {
				//insert the user and set to visitor status
				$datetime = date("Y-m-d H:i:s");
				$datetime = $this->db->DBDate($datetime);

				$query = "
					INSERT INTO " . $this->db->prefix . "_group_member
					(
					group_id, user_id, level_id, member_create_datetime, node_id
					) values (
					" . $this->group_id . ",
					" . $user_id . ",
					" . $group_level_ids['visitor'] . ",
					" . $datetime . ",
					" . $this->node_id . "
					)"
				;

				$result = $this->db->Execute($query);
				$result->Close();
		
				if (isset($result->fields)) {
					$user_level_id = $group_level_ids['visitor'];	
				}
				else {
					header("Location: g_groups.php?" . SID);
					exit;
				}
			}

			//return group level and group level name for template
			foreach($group_level_ids as $key => $i):
				if ($i == $user_level_id) {
				    $user_level = $key;
				}
			endforeach;

			$group_user_priv = array();
			$group_user_priv['user_level_id'] = $user_level_id;

			if (isset($user_level)) {
			    $group_user_priv['user_level'] = $user_level;
				$group_user_priv['user_id'] = $user_id;
			}
			$result->Close();
			return $group_user_priv;
			
		}
		else {
			header("Location: g_groups.php?" . SID);
			exit;
		}
	}




	/*
	* GROUP STATISTICS
	* tom calthrop
	* 21st Feb 2004
	*/
	function groupStatistics () {
		$query = "
			SELECT gs.statistic_type_id, gs.total
			FROM " . $this->db->prefix . "_group_statistic gs
			where
			gs.group_id=" . $this->group_id . "
			order by gs.statistic_type_id"
		;

		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}
			$result->Close();
			return $temp;
		}
		else {
			$this->log[] = array('error', 1, $query . "-" . $this->db->ErrorMsg(), null);
		}
		
	}



	/*
	* getGroups
	* tom calthrop
	* 25th Jan 2004
	*/
	function getGroups($group_status, $level_id = null) {
		$query = "
			SELECT g.group_title, g.group_id, g.group_synopsis, g.group_image_id
			FROM " . $this->db->prefix . "_group g
			where
			g.group_status=" . $group_status
		;

		if (isset($level_id)) {
			$query .= " and g.level_id=" . $level_id;
		}

		$query .= " order by g.group_title";

		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {

			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;

				if ($temp1['group_image_id']) {
					$temp1['image'] = $this->image->getImage($temp1['group_image_id'], 't2', 'group', $temp1['group_id']);
				}

				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$this->log[]  = array('error', 1, $query . "-" . $this->db->ErrorMsg(), null);
		}
	}//EO getGroups();

	/*
	* getMembership
	* Tom Calthrop 8th April 2004
	*/
	function getMembership ($group_id, $level_id = null) {

		$query = "
			SELECT u.user_id, u.user_nic, u.user_hometown, u.user_create_datetime,
			gm.*
			FROM " . $this->db->prefix . "_group_member gm
			RIGHT JOIN br_user u ON gm.user_id=u.user_id
			WHERE
			gm.group_id=" . $group_id
		;

		if (isset($level_id)) {
			$query .= " and gm.level_id=" . $level_id;
		}

		$query .= " order by u.user_nic";

		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;

				$temp1['member_create_datetime'] = $this->date->formatDate($temp1['member_create_datetime']);
				$temp1['user_create_datetime'] = $this->date->formatDate($temp1['user_create_datetime']);

				array_push($temp, $temp1);

				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$this->log[]  = array('error', 1, $query . "-" . $this->db->ErrorMsg(), null);
		}
	} //EO getMembership();




	/*
	*SET GROUP STATISTIC
	* tom calthrop
	* 6th May 2004
	*/
	function setStatistic ($statistic_type_id, $total = null) {

		//get total
		$query = "
			SELECT total
			FROM " . $this->db->prefix . "_group_statistic
			WHERE
			statistic_type_id=" . $statistic_type_id . " and
			group_id=" . $this->group_id . " limit 1"
		;

		$result = $this->db->Execute($query);
		
		if (isset($result->fields['total'])) {
			//we update
			if (empty($total)) {
			    $total = $result->fields['total']+1;
			}


			$query = "
				UPDATE " . $this->db->prefix . "_group_statistic
				SET total=" . $total . "
				WHERE
				group_id=" . $this->group_id . " and
				statistic_type_id=" . $statistic_type_id
			;

			$result1 = $this->db->Execute($query);

		}
		else {
			//we need to insert
			if (empty($total)) {
			    $total = 1;
			}

			$query = "
				INSERT INTO " . $this->db->prefix . "_group_statistic
				(group_id, statistic_type_id, total) values
				(
				" . $this->group_id . ",
				" . $statistic_type_id . ",
				" . $total . ")"
			;

			$result1 = $this->db->Execute($query);

		}
		$result->Close();
		
		if (isset($result1->fields)) {
			$result1->Close();
			return true;
		}
		else {
			$this->log[]  = array('error', 1, $query . "-" . $this->db->ErrorMsg(), null);
		}
	}



	/*
	*SET GROUP MEMBER STATISTIC
	* tom calthrop
	* 6th May 2004
	*/
	function setGroupMemberStatistic ($statistic_type_id, $user_id, $total = null) {

		//get total
		$query = "
			SELECT total
			FROM " . $this->db->prefix . "_group_member_statistic
			WHERE
			statistic_type_id=" . $statistic_type_id . " and
			group_id=" . $this->group_id . " and
			user_id=" . $user_id . " limit 1"
		;

		$result = $this->db->Execute($query);
		
		if (isset($result->fields['total'])) {
			//we update
			if (empty($total)) {
			    $total = $result->fields['total'] +1;
			}


			$query = "
				UPDATE " . $this->db->prefix . "_group_member_statistic
				SET total=" . $total . "
				WHERE
				group_id=" . $this->group_id . " and
				user_id=" . $user_id . " and
				statistic_type_id=" . $statistic_type_id
			;

			$result1 = $this->db->Execute($query);

		}
		else {
			//we need to insert
			if (empty($total)) {
			    $total = 1;
			}

			$query = "
				INSERT INTO " . $this->db->prefix . "_group_member_statistic
				(group_id, statistic_type_id, user_id, total) values
				(
				" . $this->group_id . ",
				" . $statistic_type_id . ",
				" . $user_id . ",
				" . $total . ")"
			;

			$result1 = $this->db->Execute($query);

		}
		$result->Close();
		if (isset($result1->fields)) {
			$result1->Close();
			return true;
		}
		else {
			$this->log[]  = array('error', 1, $query . "-" . $this->db->ErrorMsg(), null);
		}
	}


	/*
	* deleteGroup
	* tom calthrop
	* 15th May 2004
	*/
	function deleteGroup ($group_id) {
		$query = "
			DELETE FROM " . $this->db->prefix . "_group
			WHERE
			group_id=" . $group_id
		;
		
		$result = $this->db->Execute($query);
		$result->Close();
		
		header("Location: node_admin.php?list_groups=1"."&amp;".SID);
		exit;

	}//EO deleteGroup();


	/*
	* setupGroup
	* tom calthrop
	* 15th May 2004
	*/
	function setupGroup ($group_id) {

		//FTP create image directory
		$path = $this->ftp['asset_path'] . "group/";

		$connection = @ftp_connect($this->ftp['server']);
		$username = $this->ftp['user'];
		$pass = $this->ftp['pass'];

		if (@ftp_login($connection, $username, $pass)) {
			$log_note =  "Connected as " . $username . "@" . $connection . "\n";

			$newDir = $group_id;

			ftp_chdir($connection,$path);

			if (@ftp_mkdir($connection, $newDir)) {
				$log_note .=  "\nsuccessfully created " . $newDir . "\n";

				//small hack - can swap for ftp_chmod in php5 / tom
				$chmod_cmd="CHMOD 777 /".$path . $newDir;
				$chmod=@ftp_site($connection, $chmod_cmd);

			} else {
				$log_note .=  "\nThere was a problem while creating " . $newDir . "\n";
			}
		} else {
			$log_note =  "Couldn't connect as " . $username . "\n";
		}

		@ftp_close($connection);


		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);


		//create default forum section
		$query = "
			INSERT INTO " . $this->db->prefix . "_forum_section
			(group_id, section_title, section_create_datetime, user_id)
			values (
			'" . $group_id . "',
			'" . $this->default_section_title . "',
			" . $datetime . ",
			'" . $this->user_id . "')"
		;
		$result = $this->db->Execute($query);
		

		//create default library item
		$query = "
			INSERT INTO " . $this->db->prefix . "_group_library
			(library_title, library_synopsis, library_body, library_page_name, library_create_datetime, user_id, library_default, group_id)
			values (
			'" . $this->default_library_title . "',
			'" . $this->default_library_synopsis . "',
			'" . $this->default_library_body . "',
			'" . $this->default_library_page_name . "',
			" . $datetime . ",
			" . $this->user_id . ",
			1,
			" . $group_id . ")"
		;
		
		$result = $this->db->Execute($query);
		
		return true;

	}//EO setupGroup();
	
	
	
	/*
	* updateBookmark
	* bookmark this item or recommend this item
	* Tom Calthrop 23rd Nov 2004
	*/
	function updateBookmark($bookmark_type) {
	
		if ($bookmark_type == "watch") {
		    $query = "
				INSERT INTO " . $this->db->prefix . "_group_bookmark 
				(user_id, group_id, node_id, bookmark_type) VALUES (
				" . $this->user_id . ", 
				" . $this->group_id . ", 
				" . $this->node_id . ", 
				1)"
			;
		}
		elseif ($bookmark_type == "recommend") {
		    $query = "
				INSERT INTO " . $this->db->prefix . "_group_bookmark 
				(user_id, group_id, node_id, bookmark_type) VALUES (
				" . $this->user_id . ", 
				" . $this->group_id . ", 
				" . $this->node_id . ", 
				2)"
			;
		}
		elseif ($bookmark_type == "unwatch") {
		    $query = "
				DELETE FROM " . $this->db->prefix . "_group_bookmark 
				WHERE 
				user_id=" . $this->user_id . " and 
				group_id=" . $this->group_id . " and 
				node_id=" . $this->node_id . " and 
				bookmark_type=1"
			;
		}
		elseif ($bookmark_type == "unrecommend") {
		    $query = "
				DELETE FROM " . $this->db->prefix . "_group_bookmark 
				WHERE 
				user_id=" . $this->user_id . " and 
				group_id=" . $this->group_id . " and 
				node_id=" . $this->node_id . " and 
				bookmark_type=2"
			;
		}
		
		$result = $this->db->Execute($query);
			
		if (isset($result->fields)) {
			$result->Close();
		}
	} //EO updateBookmark();
	
	
	/*
	* GET BOOKMARKS
	* Tom Calthrop 23rd Nov 2004
	*/
	function getBookmarks () {
	
		$query = "
			SELECT bookmark_type  
			FROM " . $this->db->prefix . "_group_bookmark
			WHERE
			group_id=" . $this->group_id . " and
			user_id=" . $this->user_id . " and
			node_id=" . $this->node_id
		;
		
		$result = $this->db->Execute($query);
			
		if (isset($result->fields)) {
			while (!$result->EOF) {
				if ($result->fields['bookmark_type'] == 1) {
				    $temp['watch'] = 1;
				}
				
				if ($result->fields['bookmark_type'] == 2) {
				    $temp['recommend'] = 1;
				}

				$result->MoveNext();
			}
		
			$result->Close();
			
			if (isset($temp)) {
			    return $temp;
			}
			
		}
	} //EO getBookmarks();
}

?>
