<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------



class Acs { //Access Control System
	/*
	Terms and definitions
	Section - an area or level within the software
	Role - a job function or assigned role or a level of membership
	Pprivilige - approval to perform a task on a resource
	resource - a system resource such as a library document or a forum subject
	*/


	var $db, $query, $result, $temp, $section_id, $role_id;

	
	/*
	* GET ROLES
	* tom calthrop
	* 4th Nov 2004
	*/
	function getGroupRoles() {
		$query = "
			SELECT r.*
			FROM " . $this->db->prefix . "_acs_group_role r
			where
			r.group_id=" . $this->group_id . "
			order by r.role_name"
		;
		
		$result = $this->db->Execute($query);

		if (!$result) {
			$error = $this->db->ErrorMsg();
		}
		else {

			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
	}
	
	
	/*
	* GET ROLE
	* tom calthrop
	* 4th Nov 2004
	*/
	function getGroupRole() {
		//forum Subject polls attached
		$query = "
			SELECT r.*
			FROM " . $this->db->prefix . "_acs_group_role r
			where
			r.role_id=" . $this->role_id
		;
		
		$result = $this->db->Execute($query);

		if (!$result) {
			$error = $this->db->ErrorMsg();
		}
		else {

			$temp = $result->fields;
			$result->Close();
			return $temp;
		}
	}//EO getRole()
	
	
	/*
	* DELETE ROLE
	* tom calthrop
	* 4th Nov 2004
	*/
	function deleteGroupRole($data) {
		$query = "
			DELETE FROM " . $this->db->prefix . "_acs_group_role
			WHERE
			role_id=" . $data['role_id']
		;
		//echo $query . "<br>";

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$state[]  = array('success', 4);
			$result->Close();
		}

		return $state;
	}//EO deleteRoll();
	
	
	
	/*
	* UPDATE ROLE
	* tom calthrop
	* 4th Nov 2004
	*/
	function updateGroupRole($data) {
		
		$query = "
			UPDATE " . $this->db->prefix . "_acs_group_role SET
			role_name='" . $data['role_name'] . "' 
			WHERE
			role_id=" . $data['role_id']
		;
		//echo $query . "<br>";

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {
			$state[]  = array('success', 3);
			$result->Close();
		}

		return $state;
	}//EO updateRole();
	
	
	
	/*
	* ADD ROLE
	* tom calthrop
	* 4th Nov 2004
	*/
	function insertGroupRole($data) {
		$query = "
			INSERT INTO " . $this->db->prefix . "_acs_group_role
			(role_name, group_id)
			VALUES (
			'" . $data['role_name'] . "', 
			" . $this->group_id . "
			)"
		;
		
		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
	}//EO insertRole();

	
	
	
	/*
	* GET PERMISSIONS
	* tom calthrop
	* 4th Nov 2004
	*/
	function getPermission($role_id, $resource_id, $privilege_id) {
		$query = "
			SELECT rp.*
			FROM " . $this->db->prefix . "_acs_permission rp
			where
			rp.role_id=" . $role_id . " and 
			rp.resource_id=" . $resource_id . " and 
			rp.privilege_id=" . $privilege_id . " and 
			rp.section_id=" . $this->section_id
		;
		$result = $this->db->Execute($query);
			
		if ($result->fields['role_id']) {
			return 1;
			$result->Close();
		}
	}
}

?>
