/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.debug.RunnerException;
import processing.app.debug.Target;
import processing.app.debug.Uploader;

public class AvrdudeUploader
extends Uploader {
    public boolean uploadUsingPreferences(String string, String string2, boolean bl) throws RunnerException {
        this.verbose = bl;
        Map<String, String> map = Base.getBoardPreferences();
        String string3 = map.get("upload.using");
        if (string3 == null) {
            string3 = Preferences.get("upload.using");
        }
        if (string3.equals("bootloader")) {
            return this.uploadViaBootloader(string, string2);
        }
        Collection collection = this.getProgrammerCommands(Base.getTarget().getName(), string3);
        collection.add("-Uflash:w:" + string + File.separator + string2 + ".hex:i");
        return this.avrdude(collection);
    }

    private boolean uploadViaBootloader(String string, String string2) throws RunnerException {
        Map<String, String> map = Base.getBoardPreferences();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = map.get("upload.protocol");
        if (string3.equals("stk500")) {
            string3 = "stk500v1";
        }
        arrayList.add("-c" + string3);
        arrayList.add("-P" + (Base.isWindows() ? "\\\\.\\" : "") + Preferences.get("serial.port"));
        arrayList.add("-b" + Integer.parseInt(map.get("upload.speed")));
        arrayList.add("-D");
        arrayList.add("-Uflash:w:" + string + File.separator + string2 + ".hex:i");
        if (map.get("upload.disable_flushing") == null || map.get("upload.disable_flushing").toLowerCase().equals("false")) {
            this.flushSerialBuffer();
        }
        return this.avrdude(arrayList);
    }

    public boolean burnBootloader(String string, String string2) throws RunnerException {
        return this.burnBootloader(this.getProgrammerCommands(string, string2));
    }

    private Collection getProgrammerCommands(String string, String string2) {
        Target target = Base.targetsTable.get(string);
        Map<String, String> map = target.getProgrammers().get(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-c" + map.get("protocol"));
        if ("usb".equals(map.get("communication"))) {
            arrayList.add("-Pusb");
        } else if ("serial".equals(map.get("communication"))) {
            arrayList.add("-P" + (Base.isWindows() ? "\\\\.\\" : "") + Preferences.get("serial.port"));
            if (map.get("speed") != null) {
                arrayList.add("-b" + Integer.parseInt(map.get("speed")));
            }
        }
        if (map.get("force") != null && map.get("force").toLowerCase().equals("true")) {
            arrayList.add("-F");
        }
        if (map.get("delay") != null) {
            arrayList.add("-i" + map.get("delay"));
        }
        return arrayList;
    }

    protected boolean burnBootloader(Collection collection) throws RunnerException {
        Object object;
        Target target;
        Map<String, String> map = Base.getBoardPreferences();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-e");
        arrayList.add("-Ulock:w:" + map.get("bootloader.unlock_bits") + ":m");
        if (map.get("bootloader.extended_fuses") != null) {
            arrayList.add("-Uefuse:w:" + map.get("bootloader.extended_fuses") + ":m");
        }
        arrayList.add("-Uhfuse:w:" + map.get("bootloader.high_fuses") + ":m");
        arrayList.add("-Ulfuse:w:" + map.get("bootloader.low_fuses") + ":m");
        if (!this.avrdude(collection, arrayList)) {
            return false;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String string = map.get("bootloader.path");
        if (string.indexOf(58) == -1) {
            target = Base.getTarget();
        } else {
            object = string.substring(0, string.indexOf(58));
            target = Base.targetsTable.get(object);
            string = string.substring(string.indexOf(58) + 1);
        }
        object = new File(target.getFolder(), "bootloaders");
        File file = new File((File)object, string);
        string = file.getAbsolutePath();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("-Uflash:w:" + string + File.separator + map.get("bootloader.file") + ":i");
        arrayList2.add("-Ulock:w:" + map.get("bootloader.lock_bits") + ":m");
        return this.avrdude(collection, arrayList2);
    }

    public boolean avrdude(Collection collection, Collection collection2) throws RunnerException {
        ArrayList arrayList = new ArrayList(collection);
        arrayList.addAll(collection2);
        return this.avrdude(arrayList);
    }

    public boolean avrdude(Collection collection) throws RunnerException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("avrdude");
        if (Base.isLinux()) {
            arrayList.add("-C" + Base.getHardwarePath() + "/tools/avrdude.conf");
        } else {
            arrayList.add("-C" + Base.getHardwarePath() + "/tools/avr/etc/avrdude.conf");
        }
        if (this.verbose || Preferences.getBoolean("upload.verbose")) {
            arrayList.add("-v");
            arrayList.add("-v");
            arrayList.add("-v");
            arrayList.add("-v");
        } else {
            arrayList.add("-q");
            arrayList.add("-q");
        }
        arrayList.add("-p" + Base.getBoardPreferences().get("build.mcu"));
        arrayList.addAll(collection);
        return this.executeUploadCommand(arrayList);
    }
}

