/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.debug.MessageConsumer;
import processing.app.debug.MessageSiphon;
import processing.app.debug.MessageStream;
import processing.app.debug.RunnerException;
import processing.app.debug.Target;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compiler
implements MessageConsumer {
    static final String BUGS_URL = "https://developer.berlios.de/bugs/?group_id=3590";
    static final String SUPER_BADNESS = "Compiler error, please submit this code to https://developer.berlios.de/bugs/?group_id=3590";
    Sketch sketch;
    String buildPath;
    String primaryClassName;
    RunnerException exception;
    boolean firstErrorFound;
    boolean secondErrorFound;

    public boolean compile(Sketch sketch, String string, String string2, Target target) throws RunnerException {
        this.sketch = sketch;
        this.buildPath = string;
        this.primaryClassName = string2;
        MessageStream messageStream = new MessageStream(this);
        String string3 = Base.getAvrBasePath();
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        arrayList2.add((File)((Object)target.getPath()));
        String string4 = string + File.separator + "core.a";
        List<File> list = this.compileFiles(string3, string, arrayList2, Compiler.findFilesInPath(target.getPath(), "c", true), Compiler.findFilesInPath(target.getPath(), "cpp", true));
        ArrayList<String> arrayList3 = new ArrayList<String>(Arrays.asList(string3 + "avr-ar", "rcs", string4));
        for (File object2 : list) {
            ArrayList<String> arrayList4 = new ArrayList<String>(arrayList3);
            arrayList4.add(object2.getAbsolutePath());
            this.execAsynchronously(arrayList4);
        }
        for (File file : sketch.getImportedLibraries()) {
            arrayList2.add((File)((Object)file.getPath()));
        }
        for (File file : sketch.getImportedLibraries()) {
            File file2 = new File(string, file.getName());
            Compiler.createFolder(file2);
            arrayList2.add((File)((Object)(file.getPath() + File.separator + "utility")));
            arrayList.addAll(this.compileFiles(string3, file2.getAbsolutePath(), arrayList2, Compiler.findFilesInFolder(file, "c", false), Compiler.findFilesInFolder(file, "cpp", false)));
            File file3 = new File(file2, "utility");
            Compiler.createFolder(file3);
            arrayList.addAll(this.compileFiles(string3, file3.getAbsolutePath(), arrayList2, Compiler.findFilesInFolder(new File(file, "utility"), "c", false), Compiler.findFilesInFolder(new File(file, "utility"), "cpp", false)));
            arrayList2.remove(arrayList2.size() - 1);
        }
        arrayList.addAll(this.compileFiles(string3, string, arrayList2, Compiler.findFilesInPath(string, "c", false), Compiler.findFilesInPath(string, "cpp", false)));
        ArrayList<String> arrayList4 = new ArrayList<String>(Arrays.asList(string3 + "avr-gcc", "-Os", "-Wl,--gc-sections", "-mmcu=" + Preferences.get("boards." + Preferences.get("board") + ".build.mcu"), "-o", string + File.separator + string2 + ".elf"));
        for (File file : arrayList) {
            arrayList4.add(file.getAbsolutePath());
        }
        arrayList4.add(string4);
        arrayList4.add("-L" + string);
        arrayList4.add("-L" + target.getPath());
        String string5 = Preferences.get("boards." + Preferences.get("board") + ".build.ldflags");
        if (string5 != null) {
            arrayList4.add(string5);
        }
        arrayList4.add("-lm");
        this.execAsynchronously(arrayList4);
        ArrayList<String> arrayList5 = new ArrayList<String>(Arrays.asList(string3 + "avr-objcopy", "-O", "-R"));
        ArrayList<String> arrayList6 = new ArrayList<String>(arrayList5);
        arrayList6.add(2, "ihex");
        arrayList6.set(3, "-j");
        arrayList6.add(".eeprom");
        arrayList6.add("--set-section-flags=.eeprom=alloc,load");
        arrayList6.add("--no-change-warnings");
        arrayList6.add("--change-section-lma");
        arrayList6.add(".eeprom=0");
        arrayList6.add(string + File.separator + string2 + ".elf");
        arrayList6.add(string + File.separator + string2 + ".eep");
        this.execAsynchronously(arrayList6);
        arrayList6 = new ArrayList<String>(arrayList5);
        arrayList6.add(2, "ihex");
        arrayList6.add(".eeprom");
        arrayList6.add(string + File.separator + string2 + ".elf");
        arrayList6.add(string + File.separator + string2 + ".hex");
        this.execAsynchronously(arrayList6);
        return true;
    }

    private List<File> compileFiles(String string, String string2, List<File> list, List<File> list2, List<File> list3) throws RunnerException {
        String string3;
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : list2) {
            string3 = string2 + File.separator + file.getName() + ".o";
            arrayList.add(new File(string3));
            this.execAsynchronously(Compiler.getCommandCompilerC(string, list, file.getAbsolutePath(), string3));
        }
        for (File file : list3) {
            string3 = string2 + File.separator + file.getName() + ".o";
            arrayList.add(new File(string3));
            this.execAsynchronously(Compiler.getCommandCompilerCPP(string, list, file.getAbsolutePath(), string3));
        }
        return arrayList;
    }

    private void execAsynchronously(List list) throws RunnerException {
        Process process;
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        int n = 0;
        if (Preferences.getBoolean("build.verbose")) {
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.print(stringArray[i] + " ");
            }
            System.out.println();
        }
        this.firstErrorFound = false;
        this.secondErrorFound = false;
        try {
            process = Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            RunnerException runnerException = new RunnerException(iOException.getMessage());
            runnerException.hideStackTrace();
            throw runnerException;
        }
        MessageSiphon messageSiphon = new MessageSiphon(process.getInputStream(), this);
        MessageSiphon messageSiphon2 = new MessageSiphon(process.getErrorStream(), this);
        boolean bl = true;
        while (bl) {
            try {
                if (messageSiphon.thread != null) {
                    messageSiphon.thread.join();
                }
                if (messageSiphon2.thread != null) {
                    messageSiphon2.thread.join();
                }
                n = process.waitFor();
                bl = false;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (n > 1) {
            System.err.println(stringArray[0] + " returned " + n);
        }
        if (n != 0) {
            RunnerException runnerException = new RunnerException("Error compiling.");
            runnerException.hideStackTrace();
            throw runnerException;
        }
    }

    @Override
    public void message(String string) {
        if (string.indexOf("warning") != -1) {
            return;
        }
        if (string.indexOf("In file included from") != -1) {
            return;
        }
        String string2 = this.buildPath.replace(File.separatorChar, File.separatorChar) + File.separatorChar;
        String string3 = null;
        int n = -1;
        int n2 = -1;
        string3 = string2 + this.primaryClassName;
        n = string.indexOf(string3);
        if (n != -1) {
            n2 = 0;
        } else {
            for (int i = 0; i < this.sketch.getCodeCount(); ++i) {
                if (this.sketch.getCode(i).isExtension("pde") || (n = string.indexOf(string3 = string2 + this.sketch.getCode(i).getFileName())) == -1) continue;
                n2 = i;
                break;
            }
        }
        if (n != -1) {
            int n3;
            int n4;
            String string4 = string.substring(n + string3.length() + 1);
            int n5 = string4.indexOf(58);
            if (string4.indexOf("In function") != -1 || n5 == -1) {
                System.err.print(string4);
                return;
            }
            try {
                n4 = Integer.parseInt(string4.substring(0, n5));
            }
            catch (NumberFormatException numberFormatException) {
                System.err.print(string4);
                return;
            }
            if (n2 == 0) {
                for (n3 = 1; n3 < this.sketch.getCodeCount(); ++n3) {
                    if (!this.sketch.getCode(n3).isExtension("pde") || this.sketch.getCode(n3).getPreprocOffset() >= n4) continue;
                    n2 = n3;
                }
                n4 -= this.sketch.getCode(n2).getPreprocOffset();
            }
            if ((n3 = string4.indexOf(":")) != -1) {
                if (this.firstErrorFound) {
                    this.secondErrorFound = true;
                    return;
                }
                this.firstErrorFound = true;
                String string5 = string4.substring(n3 += ":".length());
                string5 = string5.trim();
                System.err.print(string5);
                this.exception = new RunnerException(string5, n2, n4 - 1, -1, false);
            } else {
                System.err.println("i suck: " + string);
            }
        } else if (!this.secondErrorFound) {
            System.err.println(string);
        }
    }

    private static List getCommandCompilerC(String string, List list, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string + "avr-gcc", "-c", "-g", "-Os", "-w", "-ffunction-sections", "-fdata-sections", "-mmcu=" + Preferences.get("boards." + Preferences.get("board") + ".build.mcu"), "-DF_CPU=" + Preferences.get("boards." + Preferences.get("board") + ".build.f_cpu")));
        String string4 = Preferences.get("boards." + Preferences.get("board") + ".build.boardid");
        if (string4 != null) {
            arrayList.add("-D" + string4 + "=1");
        }
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add("-I" + (String)list.get(i));
        }
        arrayList.add(string2);
        arrayList.add("-o" + string3);
        return arrayList;
    }

    private static List getCommandCompilerCPP(String string, List list, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string + "avr-g++", "-c", "-g", "-Os", "-w", "-fno-exceptions", "-ffunction-sections", "-fdata-sections", "-mmcu=" + Preferences.get("boards." + Preferences.get("board") + ".build.mcu"), "-DF_CPU=" + Preferences.get("boards." + Preferences.get("board") + ".build.f_cpu")));
        String string4 = Preferences.get("boards." + Preferences.get("board") + ".build.boardid");
        if (string4 != null) {
            arrayList.add("-D" + string4 + "=1");
        }
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add("-I" + (String)list.get(i));
        }
        arrayList.add(string2);
        arrayList.add("-o" + string3);
        return arrayList;
    }

    private static void createFolder(File file) throws RunnerException {
        if (file.isDirectory()) {
            return;
        }
        if (!file.mkdir()) {
            throw new RunnerException("Couldn't create: " + file);
        }
    }

    public static String[] headerListFromIncludePath(String string) {
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".h");
            }
        };
        return new File(string).list(filenameFilter);
    }

    public static ArrayList<File> findFilesInPath(String string, String string2, boolean bl) {
        return Compiler.findFilesInFolder(new File(string), string2, bl);
    }

    public static ArrayList<File> findFilesInFolder(File file, String string, boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file.listFiles() == null) {
            return arrayList;
        }
        for (File file2 : file.listFiles()) {
            if (file2.getName().equals(".") || file2.getName().equals("..")) continue;
            if (file2.getName().endsWith("." + string)) {
                arrayList.add(file2);
            }
            if (!bl || !file2.isDirectory()) continue;
            arrayList.addAll(Compiler.findFilesInFolder(file2, string, true));
        }
        return arrayList;
    }

    public static String contentsToClassPath(File file) {
        if (file == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("path.separator");
        try {
            String string2 = file.getCanonicalPath();
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith(".") || !stringArray[i].toLowerCase().endsWith(".jar") && !stringArray[i].toLowerCase().endsWith(".zip")) continue;
                stringBuffer.append(string);
                stringBuffer.append(string2);
                stringBuffer.append(stringArray[i]);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public static String[] packageListFromClassPath(String string) {
        Object object;
        int n;
        Hashtable hashtable = new Hashtable();
        String[] stringArray = PApplet.split((String)string, (char)File.pathSeparatorChar);
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].length() == 0) continue;
            if (stringArray[n].toLowerCase().endsWith(".jar") || stringArray[n].toLowerCase().endsWith(".zip")) {
                Compiler.packageListFromZip(stringArray[n], hashtable);
                continue;
            }
            object = new File(stringArray[n]);
            if (!((File)object).exists() || !((File)object).isDirectory()) continue;
            Compiler.packageListFromFolder((File)object, null, hashtable);
        }
        n = hashtable.size();
        object = new String[n];
        int n2 = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object[n2++] = ((String)enumeration.nextElement()).replace('/', '.');
        }
        return object;
    }

    private static void packageListFromZip(String string, Hashtable hashtable) {
        try {
            ZipFile zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                String string2;
                int n;
                String string3;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory() || !(string3 = zipEntry.getName()).endsWith(".class") || (n = string3.lastIndexOf(47)) == -1 || hashtable.get(string2 = string3.substring(0, n)) != null) continue;
                hashtable.put(string2, new Object());
            }
        }
        catch (IOException iOException) {
            System.err.println("Ignoring " + string + " (" + iOException.getMessage() + ")");
        }
    }

    private static void packageListFromFolder(File file, String string, Hashtable hashtable) {
        boolean bl = false;
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(".") || stringArray[i].equals("..")) continue;
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                String string2 = string == null ? stringArray[i] : string + "." + stringArray[i];
                Compiler.packageListFromFolder(file2, string2, hashtable);
                continue;
            }
            if (bl || !stringArray[i].endsWith(".class")) continue;
            hashtable.put(string, new Object());
            bl = true;
        }
    }
}

