/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.debug.MessageConsumer;
import processing.app.debug.MessageSiphon;
import processing.app.debug.MessageStream;
import processing.app.debug.RunnerException;
import processing.app.debug.Target;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compiler
implements MessageConsumer {
    static final String BUGS_URL = "http://code.google.com/p/arduino/issues/list";
    static final String SUPER_BADNESS = "Compiler error, please submit this code to http://code.google.com/p/arduino/issues/list";
    Sketch sketch;
    String buildPath;
    String primaryClassName;
    boolean verbose;
    RunnerException exception;
    boolean firstErrorFound;
    boolean secondErrorFound;

    public boolean compile(Sketch sketch, String string, String string2, boolean bl) throws RunnerException {
        Serializable serializable;
        Serializable serializable2;
        Object object2;
        String string3;
        Serializable serializable3;
        Object object3;
        this.sketch = sketch;
        this.buildPath = string;
        this.primaryClassName = string2;
        this.verbose = bl;
        MessageStream messageStream = new MessageStream(this);
        String string4 = Base.getAvrBasePath();
        Map<String, String> map = Base.getBoardPreferences();
        String string5 = map.get("build.core");
        if (string5.indexOf(58) == -1) {
            object3 = Base.getTarget();
            serializable3 = new File(new File(((Target)object3).getFolder(), "cores"), string5);
            string3 = ((File)serializable3).getAbsolutePath();
        } else {
            object3 = Base.targetsTable.get(string5.substring(0, string5.indexOf(58)));
            serializable3 = new File(((Target)object3).getFolder(), "cores");
            object2 = new File((File)serializable3, string5.substring(string5.indexOf(58) + 1));
            string3 = ((File)object2).getAbsolutePath();
        }
        object3 = new ArrayList();
        serializable3 = new ArrayList();
        serializable3.add(string3);
        object2 = string + File.separator + "core.a";
        List<File> list = this.compileFiles(string4, string, (List<File>)((Object)serializable3), Compiler.findFilesInPath(string3, "S", true), Compiler.findFilesInPath(string3, "c", true), Compiler.findFilesInPath(string3, "cpp", true), map);
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string4 + "avr-ar", "rcs", object2));
        for (File object4 : list) {
            serializable2 = new ArrayList<String>(arrayList);
            serializable2.add((String)object4.getAbsolutePath());
            this.execAsynchronously((List)((Object)serializable2));
        }
        for (File file : sketch.getImportedLibraries()) {
            serializable3.add(file.getPath());
        }
        for (File file : sketch.getImportedLibraries()) {
            serializable2 = new File(string, file.getName());
            serializable = new File(file, "utility");
            Compiler.createFolder(serializable2);
            serializable3.add(((File)serializable).getAbsolutePath());
            object3.addAll(this.compileFiles(string4, ((File)serializable2).getAbsolutePath(), (List<File>)((Object)serializable3), Compiler.findFilesInFolder(file, "S", false), Compiler.findFilesInFolder(file, "c", false), Compiler.findFilesInFolder(file, "cpp", false), map));
            serializable2 = new File((File)serializable2, "utility");
            Compiler.createFolder((File)serializable2);
            object3.addAll(this.compileFiles(string4, ((File)serializable2).getAbsolutePath(), (List<File>)((Object)serializable3), Compiler.findFilesInFolder((File)serializable, "S", false), Compiler.findFilesInFolder((File)serializable, "c", false), Compiler.findFilesInFolder((File)serializable, "cpp", false), map));
            serializable3.remove(serializable3.size() - 1);
        }
        object3.addAll(this.compileFiles(string4, string, (List<File>)((Object)serializable3), Compiler.findFilesInPath(string, "S", false), Compiler.findFilesInPath(string, "c", false), Compiler.findFilesInPath(string, "cpp", false), map));
        ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(string4 + "avr-gcc", "-Os", "-Wl,--gc-sections", "-mmcu=" + map.get("build.mcu"), "-o", string + File.separator + string2 + ".elf"));
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            serializable2 = (File)iterator.next();
            arrayList2.add(((File)serializable2).getAbsolutePath());
        }
        arrayList2.add((String)object2);
        arrayList2.add("-L" + string);
        arrayList2.add("-L" + string3);
        String string6 = map.get("build.ldflags");
        if (string6 != null) {
            arrayList2.add(string6);
        }
        arrayList2.add("-lm");
        this.execAsynchronously(arrayList2);
        serializable2 = new ArrayList<String>(Arrays.asList(string4 + "avr-objcopy", "-O", "-R"));
        serializable = new ArrayList(serializable2);
        serializable.add(2, "ihex");
        serializable.set(3, "-j");
        serializable.add(".eeprom");
        serializable.add("--set-section-flags=.eeprom=alloc,load");
        serializable.add("--no-change-warnings");
        serializable.add("--change-section-lma");
        serializable.add(".eeprom=0");
        serializable.add(string + File.separator + string2 + ".elf");
        serializable.add(string + File.separator + string2 + ".eep");
        this.execAsynchronously((List)((Object)serializable));
        serializable = new ArrayList(serializable2);
        serializable.add(2, "ihex");
        serializable.add(".eeprom");
        serializable.add(string + File.separator + string2 + ".elf");
        serializable.add(string + File.separator + string2 + ".hex");
        this.execAsynchronously((List)((Object)serializable));
        return true;
    }

    private List<File> compileFiles(String string, String string2, List<File> list, List<File> list2, List<File> list3, List<File> list4, Map<String, String> map) throws RunnerException {
        String string3;
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : list2) {
            string3 = string2 + File.separator + file.getName() + ".o";
            arrayList.add(new File(string3));
            this.execAsynchronously(Compiler.getCommandCompilerS(string, list, file.getAbsolutePath(), string3, map));
        }
        for (File file : list3) {
            string3 = string2 + File.separator + file.getName() + ".o";
            arrayList.add(new File(string3));
            this.execAsynchronously(Compiler.getCommandCompilerC(string, list, file.getAbsolutePath(), string3, map));
        }
        for (File file : list4) {
            string3 = string2 + File.separator + file.getName() + ".o";
            arrayList.add(new File(string3));
            this.execAsynchronously(Compiler.getCommandCompilerCPP(string, list, file.getAbsolutePath(), string3, map));
        }
        return arrayList;
    }

    private void execAsynchronously(List list) throws RunnerException {
        Process process;
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        int n = 0;
        if (this.verbose || Preferences.getBoolean("build.verbose")) {
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.print(stringArray[i] + " ");
            }
            System.out.println();
        }
        this.firstErrorFound = false;
        this.secondErrorFound = false;
        try {
            process = Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            RunnerException runnerException = new RunnerException(iOException.getMessage());
            runnerException.hideStackTrace();
            throw runnerException;
        }
        MessageSiphon messageSiphon = new MessageSiphon(process.getInputStream(), this);
        MessageSiphon messageSiphon2 = new MessageSiphon(process.getErrorStream(), this);
        boolean bl = true;
        while (bl) {
            try {
                if (messageSiphon.thread != null) {
                    messageSiphon.thread.join();
                }
                if (messageSiphon2.thread != null) {
                    messageSiphon2.thread.join();
                }
                n = process.waitFor();
                bl = false;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (n > 1) {
            System.err.println(stringArray[0] + " returned " + n);
        }
        if (n != 0) {
            RunnerException runnerException = new RunnerException("Error compiling.");
            runnerException.hideStackTrace();
            throw runnerException;
        }
    }

    @Override
    public void message(String string) {
        if (string.indexOf("warning") != -1) {
            return;
        }
        if (string.indexOf("In file included from") != -1) {
            return;
        }
        String string2 = this.buildPath.replace(File.separatorChar, File.separatorChar) + File.separatorChar;
        String string3 = null;
        int n = -1;
        int n2 = -1;
        string3 = string2 + this.primaryClassName;
        n = string.indexOf(string3);
        if (n != -1) {
            n2 = 0;
        } else {
            for (int i = 0; i < this.sketch.getCodeCount(); ++i) {
                if (this.sketch.getCode(i).isExtension("pde") || (n = string.indexOf(string3 = string2 + this.sketch.getCode(i).getFileName())) == -1) continue;
                n2 = i;
                break;
            }
        }
        if (n != -1) {
            int n3;
            int n4;
            String string4 = string.substring(n + string3.length() + 1);
            int n5 = string4.indexOf(58);
            if (string4.indexOf("In function") != -1 || n5 == -1) {
                System.err.print(string4);
                return;
            }
            try {
                n4 = Integer.parseInt(string4.substring(0, n5));
            }
            catch (NumberFormatException numberFormatException) {
                System.err.print(string4);
                return;
            }
            if (n2 == 0) {
                for (n3 = 1; n3 < this.sketch.getCodeCount(); ++n3) {
                    if (!this.sketch.getCode(n3).isExtension("pde") || this.sketch.getCode(n3).getPreprocOffset() >= n4) continue;
                    n2 = n3;
                }
                n4 -= this.sketch.getCode(n2).getPreprocOffset();
            }
            if ((n3 = string4.indexOf(":")) != -1) {
                if (this.firstErrorFound) {
                    this.secondErrorFound = true;
                    return;
                }
                this.firstErrorFound = true;
                String string5 = string4.substring(n3 += ":".length());
                string5 = string5.trim();
                System.err.print(string5);
                this.exception = new RunnerException(string5, n2, n4 - 1, -1, false);
            } else {
                System.err.println("i suck: " + string);
            }
        } else if (!this.secondErrorFound) {
            System.err.println(string);
        }
    }

    private static List getCommandCompilerS(String string, List list, String string2, String string3, Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string + "avr-gcc", "-c", "-g", "-assembler-with-cpp", "-mmcu=" + map.get("build.mcu"), "-DF_CPU=" + map.get("build.f_cpu"), "-DARDUINO=18"));
        String string4 = map.get("build.boardid");
        if (string4 != null) {
            arrayList.add("-D" + string4 + "=1");
        }
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add("-I" + (String)list.get(i));
        }
        arrayList.add(string2);
        arrayList.add("-o" + string3);
        return arrayList;
    }

    private static List getCommandCompilerC(String string, List list, String string2, String string3, Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string + "avr-gcc", "-c", "-g", "-Os", "-w", "-ffunction-sections", "-fdata-sections", "-mmcu=" + map.get("build.mcu"), "-DF_CPU=" + map.get("build.f_cpu"), "-DARDUINO=18"));
        String string4 = map.get("build.boardid");
        if (string4 != null) {
            arrayList.add("-D" + string4 + "=1");
        }
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add("-I" + (String)list.get(i));
        }
        arrayList.add(string2);
        arrayList.add("-o" + string3);
        return arrayList;
    }

    private static List getCommandCompilerCPP(String string, List list, String string2, String string3, Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string + "avr-g++", "-c", "-g", "-Os", "-w", "-fno-exceptions", "-ffunction-sections", "-fdata-sections", "-mmcu=" + map.get("build.mcu"), "-DF_CPU=" + map.get("build.f_cpu"), "-DARDUINO=18"));
        String string4 = map.get("build.boardid");
        if (string4 != null) {
            arrayList.add("-D" + string4 + "=1");
        }
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add("-I" + (String)list.get(i));
        }
        arrayList.add(string2);
        arrayList.add("-o" + string3);
        return arrayList;
    }

    private static void createFolder(File file) throws RunnerException {
        if (file.isDirectory()) {
            return;
        }
        if (!file.mkdir()) {
            throw new RunnerException("Couldn't create: " + file);
        }
    }

    public static String[] headerListFromIncludePath(String string) {
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".h");
            }
        };
        return new File(string).list(filenameFilter);
    }

    public static ArrayList<File> findFilesInPath(String string, String string2, boolean bl) {
        return Compiler.findFilesInFolder(new File(string), string2, bl);
    }

    public static ArrayList<File> findFilesInFolder(File file, String string, boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file.listFiles() == null) {
            return arrayList;
        }
        for (File file2 : file.listFiles()) {
            if (file2.getName().equals(".") || file2.getName().equals("..")) continue;
            if (file2.getName().endsWith("." + string)) {
                arrayList.add(file2);
            }
            if (!bl || !file2.isDirectory()) continue;
            arrayList.addAll(Compiler.findFilesInFolder(file2, string, true));
        }
        return arrayList;
    }

    public static String contentsToClassPath(File file) {
        if (file == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("path.separator");
        try {
            String string2 = file.getCanonicalPath();
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith(".") || !stringArray[i].toLowerCase().endsWith(".jar") && !stringArray[i].toLowerCase().endsWith(".zip")) continue;
                stringBuffer.append(string);
                stringBuffer.append(string2);
                stringBuffer.append(stringArray[i]);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public static String[] packageListFromClassPath(String string) {
        Object object;
        int n;
        Hashtable hashtable = new Hashtable();
        String[] stringArray = PApplet.split((String)string, (char)File.pathSeparatorChar);
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].length() == 0) continue;
            if (stringArray[n].toLowerCase().endsWith(".jar") || stringArray[n].toLowerCase().endsWith(".zip")) {
                Compiler.packageListFromZip(stringArray[n], hashtable);
                continue;
            }
            object = new File(stringArray[n]);
            if (!((File)object).exists() || !((File)object).isDirectory()) continue;
            Compiler.packageListFromFolder((File)object, null, hashtable);
        }
        n = hashtable.size();
        object = new String[n];
        int n2 = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object[n2++] = ((String)enumeration.nextElement()).replace('/', '.');
        }
        return object;
    }

    private static void packageListFromZip(String string, Hashtable hashtable) {
        try {
            ZipFile zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                String string2;
                int n;
                String string3;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory() || !(string3 = zipEntry.getName()).endsWith(".class") || (n = string3.lastIndexOf(47)) == -1 || hashtable.get(string2 = string3.substring(0, n)) != null) continue;
                hashtable.put(string2, new Object());
            }
        }
        catch (IOException iOException) {
            System.err.println("Ignoring " + string + " (" + iOException.getMessage() + ")");
        }
    }

    private static void packageListFromFolder(File file, String string, Hashtable hashtable) {
        boolean bl = false;
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(".") || stringArray[i].equals("..")) continue;
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                String string2 = string == null ? stringArray[i] : string + "." + stringArray[i];
                Compiler.packageListFromFolder(file2, string2, hashtable);
                continue;
            }
            if (bl || !stringArray[i].endsWith(".class")) continue;
            hashtable.put(string, new Object());
            bl = true;
        }
    }
}

