/* Copyright (c) 2008 Axel Wachtler
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

/* $Id: xmpl_radio_stream.c,v 1.1 2009/06/09 20:17:09 awachtler Exp $ */
/* Example use of the radio stream functions */
#include <stdio.h>
#include "board.h"
#include "hif.h"
#include "radio.h"
#include "xmpl.h"

#define PROMPT() PRINTF("\n\ruracoli[%02d]> ",lc++)

void incb(buffer_t *pbuf);
void outcb(buffer_t *pbuf);

buffer_stream_t Rstream;
uint8_t frame_header[] = {0x01, 0x80, 0, 0x11,0x22,0x33,0x44};
#define XMPL_FRAME_SIZE (40)
uint8_t ibuf[sizeof(buffer_t) + XMPL_FRAME_SIZE + 2];
uint8_t obuf[sizeof(buffer_t) + XMPL_FRAME_SIZE + 2];


int main(void)
{
uint8_t rxbuf[MAX_FRAME_SIZE];
char txbuf[]="\x01\x80Z\x11\x22\x33\x44Hallo Welt!CC";
uint8_t cnt = 0;


    /* setup buffers */
    buffer_init(ibuf, sizeof(ibuf)-2, 0);
    buffer_init(obuf, sizeof(obuf)-2, sizeof(frame_header));

    /* setup buffer stream structure and stdio */
    buffer_stream_init(&Rstream, &incb, &outcb);
    /* todo add buffer assignment as parameters to buffer_stream_init! */
    Rstream.pbufin  = ibuf;
    Rstream.pbufout = obuf;
    stdout = stdin = &Rstream.bstream;

    /* setup hardware */
    LED_INIT();
    radio_init(rxbuf, MAX_FRAME_SIZE);
    radio_set_param(RP_CHANNEL(CHANNEL));
    radio_set_state(STATE_TXAUTO);

    while(1)
    {
        printf_P(PSTR("Hello World %d\n\r"),cnt++);
        WAIT_MS(500);
    }
}

void incb(buffer_t *pbuf)
{

}

void outcb(buffer_t *pbuf)
{
static uint8_t frame_header[] = {0x01, 0x80, 0, 0x11,0x22,0x33,0x44};
char lastchar;

    lastchar = BUFFER_LAST_CHAR(pbuf);
    if ((BUFFER_FREE_AT_END(pbuf) < 1) || (lastchar == '\r'))
    {
        /* prepare send */
        buffer_prepend_block(pbuf, frame_header, sizeof(frame_header));
        radio_set_state(STATE_TX);
        radio_send_frame(BUFFER_SIZE(pbuf)+ 2, BUFFER_PDATA(pbuf), 0);
        /* clean buffer */
        BUFFER_RESET(pbuf, sizeof(frame_header));
        frame_header[2]++;
        /* blink LED if done. */
        LED_TOGGLE(0);
    }
}

/* XEOF */

