/* $Id: HelloRadio.pde,v 1.4 2010/01/20 20:20:14 awachtler Exp $ */
/**
 * Use of the radio functions
 */

/* Meshbean LED's */
#define LED1 0
#define LED2 1

/* some statistic counter */
volatile uint16_t txerr=0, txcnt=0, rxcnt=0;

/* character captured from UART */
int incomingByte = 0;


void setup() {
  pinMode(LED1, OUTPUT);  
  pinMode(LED2, OUTPUT);  

  radioInit();
  radioSetChannel(17);
  radioSetIdleState(STATE_RX);
  radioState(STATE_OFF);

  Serial.begin(9600);
  Serial.println("HelloRadio V$Release$");  
}

void loop() {

  static uint8_t txbuf[] = {
      1, 0, 0, /* 802.15.4 data frame. */
      'H','e','l','l','o',' ',
      'A','r','d','u','i','n','o','!', /* data */
      'X','X' /* CRC bytes, radio generates values actually. */
  };

  radioTransmit((uint8_t)sizeof(txbuf), txbuf);
  digitalWrite(LED1, HIGH);
  /* increment sequence number */
  txbuf[2]++;

  /* print tx/rx statistic */
  if (Serial.available() > 0) {         
      // read the incoming byte:        
      incomingByte = Serial.read();     
      if (incomingByte == 'd')          
      {                                 
          Serial.print("counters tx="); 
          Serial.print(txcnt);          
          Serial.print(" txerr=");       
          Serial.print(txerr);          
          Serial.print(" rxcnt=");       
          Serial.println(rxcnt);          
      }                                 
  }                                     
                                          
  delay(500);  
}

/* This function is called from the Radio IRQ Context */
void transmitDoneCallback(txdone_t status)
{
    digitalWrite(LED1, LOW);
    if (status == TX_OK)
    {
      digitalWrite(LED2, LOW);
      txcnt++;
    }
    else
    {
      digitalWrite(LED2, HIGH);
      txerr++;
    }   
}

/* This function is called on a frame reception */
uint8_t* receiveFrameCallback( uint8_t len, 
                               uint8_t * frm, 
                               uint8_t lqi, 
                               uint8_t rssi, 
                               uint8_t crc_fail)
{
    rxcnt ++;
    Serial.println(len);
    /* return a buffer, where the next RXd frame can be stored. */
    return frm;
}
