/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import processing.app.Base;
import processing.app.Preferences;
import processing.app.Theme;
import processing.app.syntax.DefaultInputHandler;
import processing.app.syntax.InputHandler;
import processing.app.syntax.SyntaxDocument;
import processing.app.syntax.SyntaxStyle;
import processing.app.syntax.TextAreaDefaults;

public class PdeTextAreaDefaults
extends TextAreaDefaults {
    public PdeTextAreaDefaults() {
        this.inputHandler = new DefaultInputHandler();
        String string = Base.isMacOS() ? "A" : "C";
        this.inputHandler.addKeyBinding("BACK_SPACE", InputHandler.BACKSPACE);
        this.inputHandler.addKeyBinding("DELETE", InputHandler.DELETE);
        this.inputHandler.addKeyBinding("S+BACK_SPACE", InputHandler.DELETE);
        this.inputHandler.addKeyBinding("S+DELETE", InputHandler.DELETE);
        this.inputHandler.addKeyBinding(string + "+BACK_SPACE", InputHandler.BACKSPACE_WORD);
        this.inputHandler.addKeyBinding(string + "+DELETE", InputHandler.DELETE_WORD);
        this.inputHandler.addKeyBinding("INSERT", InputHandler.OVERWRITE);
        if (Base.isMacOS()) {
            this.inputHandler.addKeyBinding("HOME", InputHandler.DOCUMENT_HOME);
            this.inputHandler.addKeyBinding("END", InputHandler.DOCUMENT_END);
            this.inputHandler.addKeyBinding("S+HOME", InputHandler.SELECT_DOC_HOME);
            this.inputHandler.addKeyBinding("S+END", InputHandler.SELECT_DOC_END);
        } else {
            this.inputHandler.addKeyBinding("HOME", InputHandler.HOME);
            this.inputHandler.addKeyBinding("END", InputHandler.END);
            this.inputHandler.addKeyBinding("S+HOME", InputHandler.SELECT_HOME);
            this.inputHandler.addKeyBinding("S+END", InputHandler.SELECT_END);
            this.inputHandler.addKeyBinding("C+HOME", InputHandler.DOCUMENT_HOME);
            this.inputHandler.addKeyBinding("C+END", InputHandler.DOCUMENT_END);
            this.inputHandler.addKeyBinding("CS+HOME", InputHandler.SELECT_DOC_HOME);
            this.inputHandler.addKeyBinding("CS+END", InputHandler.SELECT_DOC_END);
        }
        if (Base.isMacOS()) {
            this.inputHandler.addKeyBinding("M+LEFT", InputHandler.HOME);
            this.inputHandler.addKeyBinding("M+RIGHT", InputHandler.END);
            this.inputHandler.addKeyBinding("MS+LEFT", InputHandler.SELECT_HOME);
            this.inputHandler.addKeyBinding("MS+RIGHT", InputHandler.SELECT_END);
        } else {
            this.inputHandler.addKeyBinding("C+LEFT", InputHandler.HOME);
            this.inputHandler.addKeyBinding("C+RIGHT", InputHandler.END);
            this.inputHandler.addKeyBinding("CS+HOME", InputHandler.SELECT_HOME);
            this.inputHandler.addKeyBinding("CS+END", InputHandler.SELECT_END);
        }
        this.inputHandler.addKeyBinding("PAGE_UP", InputHandler.PREV_PAGE);
        this.inputHandler.addKeyBinding("PAGE_DOWN", InputHandler.NEXT_PAGE);
        this.inputHandler.addKeyBinding("S+PAGE_UP", InputHandler.SELECT_PREV_PAGE);
        this.inputHandler.addKeyBinding("S+PAGE_DOWN", InputHandler.SELECT_NEXT_PAGE);
        this.inputHandler.addKeyBinding("LEFT", InputHandler.PREV_CHAR);
        this.inputHandler.addKeyBinding("S+LEFT", InputHandler.SELECT_PREV_CHAR);
        this.inputHandler.addKeyBinding(string + "+LEFT", InputHandler.PREV_WORD);
        this.inputHandler.addKeyBinding(string + "S+LEFT", InputHandler.SELECT_PREV_WORD);
        this.inputHandler.addKeyBinding("RIGHT", InputHandler.NEXT_CHAR);
        this.inputHandler.addKeyBinding("S+RIGHT", InputHandler.SELECT_NEXT_CHAR);
        this.inputHandler.addKeyBinding(string + "+RIGHT", InputHandler.NEXT_WORD);
        this.inputHandler.addKeyBinding(string + "S+RIGHT", InputHandler.SELECT_NEXT_WORD);
        this.inputHandler.addKeyBinding("UP", InputHandler.PREV_LINE);
        this.inputHandler.addKeyBinding(string + "+UP", InputHandler.PREV_LINE);
        this.inputHandler.addKeyBinding("S+UP", InputHandler.SELECT_PREV_LINE);
        this.inputHandler.addKeyBinding("DOWN", InputHandler.NEXT_LINE);
        this.inputHandler.addKeyBinding(string + "+DOWN", InputHandler.NEXT_LINE);
        this.inputHandler.addKeyBinding("S+DOWN", InputHandler.SELECT_NEXT_LINE);
        this.inputHandler.addKeyBinding("MS+UP", InputHandler.SELECT_DOC_HOME);
        this.inputHandler.addKeyBinding("CS+UP", InputHandler.SELECT_DOC_HOME);
        this.inputHandler.addKeyBinding("MS+DOWN", InputHandler.SELECT_DOC_END);
        this.inputHandler.addKeyBinding("CS+DOWN", InputHandler.SELECT_DOC_END);
        this.inputHandler.addKeyBinding(string + "+ENTER", InputHandler.REPEAT);
        this.document = new SyntaxDocument();
        this.editable = true;
        this.electricScroll = 3;
        this.cols = 80;
        this.rows = 15;
        this.styles = new SyntaxStyle[11];
        this.styles[1] = Theme.getStyle("comment1");
        this.styles[2] = Theme.getStyle("comment2");
        this.styles[6] = Theme.getStyle("keyword1");
        this.styles[7] = Theme.getStyle("keyword2");
        this.styles[8] = Theme.getStyle("keyword3");
        this.styles[3] = Theme.getStyle("literal1");
        this.styles[4] = Theme.getStyle("literal2");
        this.styles[5] = Theme.getStyle("label");
        this.styles[9] = Theme.getStyle("operator");
        this.styles[10] = Theme.getStyle("invalid");
        this.font = Preferences.getFont("editor.font");
        this.fgcolor = Theme.getColor("editor.fgcolor");
        this.bgcolor = Theme.getColor("editor.bgcolor");
        this.caretVisible = true;
        this.caretBlinks = Preferences.getBoolean("editor.caret.blink");
        this.caretColor = Theme.getColor("editor.caret.color");
        this.selectionColor = Theme.getColor("editor.selection.color");
        this.lineHighlight = Theme.getBoolean("editor.linehighlight");
        this.lineHighlightColor = Theme.getColor("editor.linehighlight.color");
        this.bracketHighlight = Theme.getBoolean("editor.brackethighlight");
        this.bracketHighlightColor = Theme.getColor("editor.brackethighlight.color");
        this.eolMarkers = Theme.getBoolean("editor.eolmarkers");
        this.eolMarkerColor = Theme.getColor("editor.eolmarkers.color");
        this.paintInvalid = Theme.getBoolean("editor.invalid");
    }
}

