/* $Id: TspSample.java,v 1.2 2006/06/04 08:33:45 erk Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : Consumer
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : 
 * 
 * -----------------------------------------------------------------------
 */

package tsp.core.common;

/**
 * The TSP Sample is the minimal
 * information stored by the {@link TspStreamReader}
 * when reading TSP sample on a TSP stream.
 */
public class TspSample {

    public TspSample(int timeStamp,
		     int pgi,
		     Object value) {
	this.timeStamp   = timeStamp;
	this.pgi         = pgi;
	this.value       = value;
	this.index       = 0;
    }
    
    public TspSample(int timeStamp,
		     int pgi,
		     Object value,
		     int index) {
	this.timeStamp   = timeStamp;
	this.pgi         = pgi;
	this.value       = value;
	this.index       = index;
   }
    /**
     * The TSP time stamp
     */
    private  int timeStamp;
    /**
     * The provider global index.
     * (see TSP specs.).
     */
    private int pgi;
    /**
     * The value of the sample
     */
    private  Object value;
    
    /**
     * The index of the sample in an array
     */
    private int index;
    
	public int getPgi() {
		return pgi;
	}
	public int getTimeStamp() {
		return timeStamp;
	}
	
	public Object getValue() {
		return value;
	}
	
	public int getIndex() {
		return index;
	}
	

	/* FIXME : 
	 * This method has been added to stub old consumer while implementing multi-type handling */
	
	public double getCastedDoubleValue() {
		if (value instanceof Double) {
			return ((Double)value).doubleValue();
		} else {
			return 0.;
		}
	}	
	
	public double getDoubleValue() throws TspException {
		if (value instanceof Double) {
			return ((Double)value).doubleValue();
		} else {
			throw new TspException("Not a double sample");
		}
	}	
	
	public float getFloatValue() throws TspException {
		if (value instanceof Float) {
			return ((Float)value).floatValue();
		} else {
			throw new TspException("Not a float sample");
		}
	}	

	public int getLongValue() throws TspException {
		if (value instanceof Long) {
			return ((Long)value).intValue();
		} else {
			throw new TspException("Not a long sample");
		}
	}
	
	public int getIntValue() throws TspException {
		if (value instanceof Integer) {
			return ((Integer)value).intValue();
		} else {
			throw new TspException("Not a integer sample");
		}
	}
	
	public char getCharValue() throws TspException {
		if (value instanceof Character) {
			return ((Character)value).charValue();
		} else {
			throw new TspException("Not a character sample");
		}
	}
	
	public byte getByteValue() throws TspException {
		if (value instanceof Byte) {
			return ((Byte)value).byteValue();
		} else {
			throw new TspException("Not a raw sample");
		}
	}
	
	public boolean isDouble(){
		if (value instanceof Double)
			return true;
		else
			return false;	
	}
	
	public boolean isFloat(){
		if (value instanceof Float)
			return true;
		else
			return false;	
	}

	public boolean isLong(){
		if (value instanceof Long)
			return true;
		else
			return false;	
	}
	
	public boolean isInt(){
		if (value instanceof Integer)
			return true;
		else
			return false;	
	}

	public boolean isCharacter(){
		if (value instanceof Character)
			return true;
		else
			return false;	
	}

	public boolean isRaw(){
		if (value instanceof Byte)
			return true;
		else
			return false;	
	}
	
    public String toString() {
    	return value.toString();
        }
}
