/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.plugins.jfreechart;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.Vector;
import org.jfree.data.AbstractDataset;
import org.jfree.data.XYDataset;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceCollection;
import simtools.data.DataSourceListener;
import simtools.data.DataSourcePool;
import simtools.data.EndNotificationListener;
import simtools.data.UnsupportedOperation;

public class SourceXYDataset
extends AbstractDataset
implements XYDataset,
DataSourceListener,
EndNotificationListener {
    static final long serialVersionUID = 2534350549886932663L;
    protected transient Vector sources = new Vector();
    protected transient boolean dirty = false;
    protected boolean notifySourceChange = false;
    protected boolean nameAccordingToYOnly = true;
    protected DataInfo info = null;

    public boolean isNameAccordingToYOnly() {
        return this.nameAccordingToYOnly;
    }

    public void setNameAccordingToYOnly(boolean bl) {
        this.nameAccordingToYOnly = bl;
    }

    public SourceXYDataset() {
        this.notifySourceChange = true;
    }

    public SourceXYDataset(DataSourceCollection dataSourceCollection) {
        this.setDataSourceCollection(dataSourceCollection);
        this.notifySourceChange = true;
    }

    public void setDataSourceCollection(DataSourceCollection dataSourceCollection) {
        boolean bl = this.notifySourceChange;
        this.notifySourceChange = false;
        this.clear();
        this.info = dataSourceCollection.getInformation();
        this.addXSource((DataSource)dataSourceCollection.get(0));
        for (int i = 1; i < dataSourceCollection.size(); ++i) {
            this.addYSource((DataSource)dataSourceCollection.get(i));
        }
        this.notifySourceChange = bl;
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public void setDataSourceCollectionAsCouples(DataSourceCollection dataSourceCollection) {
        boolean bl = this.notifySourceChange;
        this.notifySourceChange = false;
        this.clear();
        this.info = dataSourceCollection.getInformation();
        for (int i = 0; i < (dataSourceCollection.size() & 0xFFFFFFFE); ++i) {
            if (i % 2 == 0) {
                this.addXSource((DataSource)dataSourceCollection.get(i));
                continue;
            }
            this.addYSource((DataSource)dataSourceCollection.get(i));
        }
        this.notifySourceChange = bl;
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public void addDataSourceCollection(DataSourceCollection dataSourceCollection) {
        boolean bl = this.notifySourceChange;
        this.notifySourceChange = false;
        for (int i = 0; i < dataSourceCollection.size(); ++i) {
            this.addYSource((DataSource)dataSourceCollection.get(i));
        }
        this.notifySourceChange = bl;
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public void setXSource(DataSource dataSource) {
        if (this.sources.size() == 0) {
            this.addXSource(dataSource);
            return;
        }
        for (int i = 0; i < this.sources.size(); ++i) {
            SourceCouple sourceCouple = (SourceCouple)this.sources.get(i);
            if (sourceCouple.x != null) {
                sourceCouple.x.removeListener((DataSourceListener)this);
                sourceCouple.x.removeEndNotificationListener((EndNotificationListener)this);
            }
            sourceCouple.x = dataSource;
            sourceCouple.x.addListener((DataSourceListener)this);
            sourceCouple.x.addEndNotificationListener((EndNotificationListener)this);
        }
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public int setXSource(DataSource dataSource, int n) {
        if (n >= this.sources.size()) {
            this.addXSource(dataSource);
            return this.sources.size() - 1;
        }
        SourceCouple sourceCouple = (SourceCouple)this.sources.get(n);
        if (sourceCouple.x != null) {
            sourceCouple.x.removeListener((DataSourceListener)this);
            sourceCouple.x.removeEndNotificationListener((EndNotificationListener)this);
        }
        sourceCouple.x = dataSource;
        sourceCouple.x.addListener((DataSourceListener)this);
        sourceCouple.x.addEndNotificationListener((EndNotificationListener)this);
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
        return n;
    }

    public int setYSource(DataSource dataSource, int n) {
        if (n >= this.sources.size()) {
            this.addYSource(dataSource);
            return this.sources.size() - 1;
        }
        SourceCouple sourceCouple = (SourceCouple)this.sources.get(n);
        if (sourceCouple.y != null) {
            sourceCouple.y.removeListener((DataSourceListener)this);
            sourceCouple.y.removeEndNotificationListener((EndNotificationListener)this);
        }
        sourceCouple.y = dataSource;
        sourceCouple.y.addListener((DataSourceListener)this);
        sourceCouple.y.addEndNotificationListener((EndNotificationListener)this);
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
        return n;
    }

    public DataSource getXSource(int n) {
        return ((SourceCouple)this.sources.get((int)n)).x;
    }

    public DataSource getYSource(int n) {
        return ((SourceCouple)this.sources.get((int)n)).y;
    }

    public void addXSource(DataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        this.sources.add(new SourceCouple(dataSource, null));
        dataSource.addListener((DataSourceListener)this);
        dataSource.addEndNotificationListener((EndNotificationListener)this);
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public void removeXSource(DataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        dataSource.removeListener((DataSourceListener)this);
        dataSource.removeEndNotificationListener((EndNotificationListener)this);
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            SourceCouple sourceCouple = (SourceCouple)iterator.next();
            if (!sourceCouple.x.equals((Object)dataSource)) continue;
            iterator.remove();
        }
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public void removeXSource(int n) {
        SourceCouple sourceCouple = (SourceCouple)this.sources.get(n);
        if (sourceCouple.x != null) {
            sourceCouple.x.removeListener((DataSourceListener)this);
            sourceCouple.x.removeEndNotificationListener((EndNotificationListener)this);
        }
        if (sourceCouple.y != null) {
            sourceCouple.y.removeListener((DataSourceListener)this);
            sourceCouple.y.removeEndNotificationListener((EndNotificationListener)this);
        }
        this.sources.remove(n);
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public void addYSource(DataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        SourceCouple sourceCouple = null;
        if (this.sources.size() > 0) {
            sourceCouple = (SourceCouple)this.sources.lastElement();
        }
        if (sourceCouple == null) {
            this.sources.add(new SourceCouple(null, dataSource));
        } else if (sourceCouple.y == null) {
            sourceCouple.y = dataSource;
        } else {
            this.sources.add(new SourceCouple(sourceCouple.x, dataSource));
        }
        dataSource.addListener((DataSourceListener)this);
        dataSource.addEndNotificationListener((EndNotificationListener)this);
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public void removeYSource(DataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        dataSource.removeListener((DataSourceListener)this);
        dataSource.removeEndNotificationListener((EndNotificationListener)this);
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            SourceCouple sourceCouple = (SourceCouple)iterator.next();
            if (!sourceCouple.y.equals((Object)dataSource)) continue;
            iterator.remove();
        }
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public void removeYSource(int n) {
        SourceCouple sourceCouple = (SourceCouple)this.sources.get(n);
        if (sourceCouple.y != null) {
            sourceCouple.y.removeListener((DataSourceListener)this);
            sourceCouple.y.removeEndNotificationListener((EndNotificationListener)this);
        }
        if (n > 0) {
            this.sources.remove(n);
        } else {
            sourceCouple.y = null;
        }
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public void add(DataSource dataSource, DataSource dataSource2) {
        this.sources.add(new SourceCouple(dataSource, dataSource2));
    }

    public void clear() {
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            SourceCouple sourceCouple = (SourceCouple)iterator.next();
            if (sourceCouple.x != null) {
                sourceCouple.x.removeListener((DataSourceListener)this);
                sourceCouple.x.removeEndNotificationListener((EndNotificationListener)this);
            }
            if (sourceCouple.y != null) {
                sourceCouple.y.removeListener((DataSourceListener)this);
                sourceCouple.y.removeEndNotificationListener((EndNotificationListener)this);
            }
            iterator.remove();
        }
        this.info = null;
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public void setName(int n, String string) {
        SourceCouple sourceCouple = (SourceCouple)this.sources.get(n);
        sourceCouple.name = string;
    }

    public void setName(String string) {
        if (this.info == null) {
            this.info = new DataInfo(string);
        } else {
            this.info.label = string;
        }
    }

    public String getName() {
        if (this.info == null) {
            return "";
        }
        return this.info.label;
    }

    public String getXLabel(int n) {
        String string = DataInfo.getLabel((Object)this.getXSource(n));
        if (string == null) {
            return "";
        }
        return string;
    }

    public String getYLabel(int n) {
        String string = DataInfo.getLabel((Object)this.getYSource(n));
        if (string == null) {
            return "";
        }
        return string;
    }

    public int getItemCount(int n) {
        DataSource dataSource = this.getXSource(n);
        DataSource dataSource2 = this.getYSource(n);
        if (dataSource == null || dataSource2 == null) {
            return 0;
        }
        try {
            long l;
            long l2 = dataSource.computeLastIndex();
            if (l2 < 0L) {
                return 0;
            }
            long l3 = dataSource.computeStartIndex();
            if (l3 < 0L) {
                return 0;
            }
            long l4 = dataSource2.computeLastIndex();
            if (l4 < 0L) {
                return 0;
            }
            long l5 = dataSource2.computeStartIndex();
            if (l5 < 0L) {
                return 0;
            }
            ((SourceCouple)this.sources.get((int)n)).startIndex = l = Math.max(l3, l5);
            int n2 = (int)Math.min(l2 - l, l4 - l) + 1;
            return Math.max(n2, 0);
        }
        catch (UnsupportedOperation unsupportedOperation) {
            return 0;
        }
    }

    public Number getXValue(int n, int n2) {
        SourceCouple sourceCouple = (SourceCouple)this.sources.get(n);
        if (sourceCouple.x == null) {
            return null;
        }
        Object object = null;
        try {
            object = sourceCouple.x.getValue((long)n2 + sourceCouple.startIndex);
        }
        catch (DataException dataException) {
            dataException.printStackTrace();
        }
        if (object == null) {
            return null;
        }
        if (object instanceof Double) {
            double d = ((Number)object).doubleValue();
            if (Double.isNaN(d)) {
                return null;
            }
            if (Double.isInfinite(d)) {
                return null;
            }
            return (Double)object;
        }
        if (object instanceof Float) {
            float f = ((Number)object).floatValue();
            if (Float.isNaN(f)) {
                return null;
            }
            if (Float.isInfinite(f)) {
                return null;
            }
            return (Float)object;
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        return null;
    }

    public Number getYValue(int n, int n2) {
        SourceCouple sourceCouple = (SourceCouple)this.sources.get(n);
        if (sourceCouple.y == null) {
            return null;
        }
        Object object = null;
        try {
            object = sourceCouple.y.getValue((long)n2 + sourceCouple.startIndex);
        }
        catch (DataException dataException) {
            dataException.printStackTrace();
        }
        if (object == null) {
            return null;
        }
        if (object instanceof Double) {
            double d = ((Number)object).doubleValue();
            if (Double.isNaN(d)) {
                return null;
            }
            if (Double.isInfinite(d)) {
                return null;
            }
            return (Double)object;
        }
        if (object instanceof Float) {
            float f = ((Number)object).floatValue();
            if (Float.isNaN(f)) {
                return null;
            }
            if (Float.isInfinite(f)) {
                return null;
            }
            return (Float)object;
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        return null;
    }

    public Vector getSources() {
        return this.sources;
    }

    public int getSeriesCount() {
        int n = this.sources.size();
        if (n <= 0) {
            return n;
        }
        if (((SourceCouple)this.sources.get((int)(n - 1))).y == null) {
            return n - 1;
        }
        return n;
    }

    public String getSeriesName(int n) {
        SourceCouple sourceCouple = (SourceCouple)this.sources.get(n);
        if (sourceCouple.name != null) {
            return sourceCouple.name;
        }
        if (this.nameAccordingToYOnly) {
            return this.getYLabel(n);
        }
        return this.getYLabel(n) + "/" + this.getXLabel(n);
    }

    public void DataSourceValueChanged(DataSource dataSource, long l, long l2) {
        this.dirty = true;
    }

    public void DataSourceIndexRangeChanged(DataSource dataSource, long l, long l2) {
        this.dirty = true;
    }

    public void DataSourceInfoChanged(DataSource dataSource, DataInfo dataInfo) {
        this.dirty = true;
    }

    public void DataSourceValueRangeChanged(DataSource dataSource) {
        this.dirty = true;
    }

    public void DataSourceOrderChanged(DataSource dataSource, int n) {
    }

    public void notificationEnd(Object object) {
        if (this.dirty) {
            this.fireDatasetChanged();
            this.dirty = false;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.sources.size();
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            SourceCouple sourceCouple = (SourceCouple)this.sources.get(i);
            DataSourcePool.global.writeDataSource(objectOutputStream, sourceCouple.x);
            DataSourcePool.global.writeDataSource(objectOutputStream, sourceCouple.y);
            objectOutputStream.writeLong(sourceCouple.startIndex);
            objectOutputStream.writeObject(sourceCouple.name);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.sources = new Vector();
        for (int i = 0; i < n; ++i) {
            SourceCouple sourceCouple = new SourceCouple(DataSourcePool.global.readDataSource(objectInputStream), DataSourcePool.global.readDataSource(objectInputStream), objectInputStream.readLong());
            this.sources.add(sourceCouple);
            sourceCouple.name = (String)objectInputStream.readObject();
            if (sourceCouple.x != null) {
                sourceCouple.x.addListener((DataSourceListener)this);
                sourceCouple.x.addEndNotificationListener((EndNotificationListener)this);
            }
            if (sourceCouple.y == null) continue;
            sourceCouple.y.addListener((DataSourceListener)this);
            sourceCouple.y.addEndNotificationListener((EndNotificationListener)this);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SourceXYDataset sourceXYDataset = (SourceXYDataset)((Object)super.clone());
        sourceXYDataset.sources = new Vector();
        sourceXYDataset.info = DataInfo.clone((DataInfo)this.info);
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            SourceCouple sourceCouple = (SourceCouple)iterator.next();
            Vector vector = sourceXYDataset.sources;
            SourceXYDataset sourceXYDataset2 = sourceXYDataset;
            ((Object)((Object)sourceXYDataset2)).getClass();
            vector.add(sourceXYDataset2.new SourceCouple(sourceCouple.x, sourceCouple.y, sourceCouple.startIndex, sourceCouple.name));
            if (sourceCouple.x != null) {
                sourceCouple.x.addListener((DataSourceListener)sourceXYDataset);
                sourceCouple.x.addEndNotificationListener((EndNotificationListener)sourceXYDataset);
            }
            if (sourceCouple.y == null) continue;
            sourceCouple.y.addListener((DataSourceListener)sourceXYDataset);
            sourceCouple.y.addEndNotificationListener((EndNotificationListener)sourceXYDataset);
        }
        return sourceXYDataset;
    }

    public SourceXYDataset cloneSet() {
        try {
            return (SourceXYDataset)((Object)this.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public class SourceCouple {
        public DataSource x;
        public DataSource y;
        public long startIndex;
        public String name;

        public SourceCouple(DataSource dataSource, DataSource dataSource2) {
            this(dataSource, dataSource2, 0L);
        }

        public SourceCouple(DataSource dataSource, DataSource dataSource2, long l) {
            this(dataSource, dataSource2, l, null);
        }

        public SourceCouple(DataSource dataSource, DataSource dataSource2, long l, String string) {
            this.x = dataSource;
            this.y = dataSource2;
            this.startIndex = l;
            this.name = string;
        }
    }
}

