/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.plugins.jfreechart;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jsynoptic.plugins.jfreechart.CategoryClassifier;
import jsynoptic.plugins.jfreechart.CategoryClassifierListener;
import org.jfree.data.AbstractDataset;
import org.jfree.data.CategoryDataset;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceCollection;
import simtools.data.DataSourceListener;
import simtools.data.DataSourcePool;
import simtools.data.EndNotificationListener;
import simtools.data.UnsupportedOperation;

public class SourceCategoryDataset
extends AbstractDataset
implements CategoryDataset,
DataSourceListener,
CategoryClassifierListener,
EndNotificationListener {
    static final long serialVersionUID = 4732659452902199039L;
    protected transient Vector sources = new Vector();
    protected transient ArrayList holdersToUpdate = null;
    protected transient boolean dirty = false;
    protected CategoryClassifier classifier;
    protected boolean notifySourceChange = false;
    protected DataInfo info = null;

    public CategoryClassifier getClassifier() {
        return this.classifier;
    }

    public void setClassifier(CategoryClassifier categoryClassifier) {
        if (this.classifier != null) {
            this.classifier.removeListener(this);
        }
        this.classifier = categoryClassifier;
        if (this.classifier != null) {
            this.classifier.addListener(this);
        }
        this.fireDatasetChanged();
    }

    public SourceCategoryDataset() {
        this.notifySourceChange = true;
    }

    public SourceCategoryDataset(DataSourceCollection dataSourceCollection) {
        this.setDataSourceCollection(dataSourceCollection);
        this.notifySourceChange = true;
    }

    public void setDataSourceCollection(DataSourceCollection dataSourceCollection) {
        boolean bl = this.notifySourceChange;
        this.notifySourceChange = false;
        this.clear();
        this.info = dataSourceCollection.getInformation();
        for (int i = 0; i < dataSourceCollection.size(); ++i) {
            this.addSource((DataSource)dataSourceCollection.get(i));
        }
        this.notifySourceChange = bl;
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public void addDataSourceCollection(DataSourceCollection dataSourceCollection) {
        boolean bl = this.notifySourceChange;
        this.notifySourceChange = false;
        for (int i = 0; i < dataSourceCollection.size(); ++i) {
            this.addSource((DataSource)dataSourceCollection.get(i));
        }
        this.notifySourceChange = bl;
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public DataSource getSource(int n) {
        return ((SourceHolder)this.sources.get((int)n)).source;
    }

    public void addSource(DataSource dataSource) {
        this.addSource(dataSource, 0L);
    }

    public void addSource(DataSource dataSource, long l) {
        if (dataSource == null) {
            return;
        }
        this.sources.add(new SourceHolder(dataSource, l));
        dataSource.addListener((DataSourceListener)this);
        dataSource.addEndNotificationListener((EndNotificationListener)this);
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public void removeSource(DataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        dataSource.removeListener((DataSourceListener)this);
        dataSource.removeEndNotificationListener((EndNotificationListener)this);
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            SourceHolder sourceHolder = (SourceHolder)iterator.next();
            if (sourceHolder.source == null || !sourceHolder.source.equals((Object)dataSource)) continue;
            sourceHolder.source.removeListener((DataSourceListener)this);
            sourceHolder.source.removeEndNotificationListener((EndNotificationListener)this);
            iterator.remove();
        }
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public void removeSource(int n) {
        SourceHolder sourceHolder = (SourceHolder)this.sources.get(n);
        if (sourceHolder.source != null) {
            sourceHolder.source.removeListener((DataSourceListener)this);
            sourceHolder.source.removeEndNotificationListener((EndNotificationListener)this);
        }
        this.sources.remove(n);
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public void clear() {
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            SourceHolder sourceHolder = (SourceHolder)iterator.next();
            if (sourceHolder.source != null) {
                sourceHolder.source.removeListener((DataSourceListener)this);
                sourceHolder.source.removeEndNotificationListener((EndNotificationListener)this);
            }
            iterator.remove();
        }
        this.info = null;
        if (this.notifySourceChange) {
            this.fireDatasetChanged();
        }
    }

    public void setName(int n, String string) {
        SourceHolder sourceHolder = (SourceHolder)this.sources.get(n);
        sourceHolder.name = string;
    }

    public String getName(int n) {
        SourceHolder sourceHolder = (SourceHolder)this.sources.get(n);
        return sourceHolder.toString();
    }

    public void setName(String string) {
        if (this.info == null) {
            this.info = new DataInfo(string);
        } else {
            this.info.label = string;
        }
    }

    public String getName() {
        if (this.info == null) {
            return "";
        }
        return this.info.label;
    }

    public Comparable getRowKey(int n) {
        return (Comparable)this.sources.get(n);
    }

    public int getRowIndex(Comparable comparable) {
        return this.sources.indexOf(comparable);
    }

    public List getRowKeys() {
        return this.sources;
    }

    public Comparable getColumnKey(int n) {
        if (this.classifier == null) {
            return null;
        }
        return (Comparable)this.classifier.categories.get(n);
    }

    public int getColumnIndex(Comparable comparable) {
        if (this.classifier == null) {
            return -1;
        }
        return this.classifier.categories.indexOf(comparable);
    }

    public List getColumnKeys() {
        if (this.classifier == null) {
            return new Vector();
        }
        return this.classifier.categories;
    }

    public Number getValue(Comparable comparable, Comparable comparable2) {
        return new Integer(((SourceHolder)comparable).getCategoryValue((String)((Object)comparable2)));
    }

    public int getRowCount() {
        return this.sources.size();
    }

    public int getColumnCount() {
        if (this.classifier == null) {
            return 0;
        }
        return this.classifier.categories.size();
    }

    public Number getValue(int n, int n2) {
        return new Integer(((SourceHolder)this.sources.get(n)).getCategoryValue(n2));
    }

    public void DataSourceValueChanged(DataSource dataSource, long l, long l2) {
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            SourceHolder sourceHolder = (SourceHolder)iterator.next();
            if (!dataSource.equals((Object)sourceHolder.source)) continue;
            if (sourceHolder.startIndex > l) {
                sourceHolder.needCompute = true;
            } else {
                if (this.holdersToUpdate == null) {
                    this.holdersToUpdate = new ArrayList();
                }
                this.holdersToUpdate.add(sourceHolder);
            }
            this.dirty = true;
            break;
        }
    }

    public void DataSourceIndexRangeChanged(DataSource dataSource, long l, long l2) {
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            SourceHolder sourceHolder = (SourceHolder)iterator.next();
            if (!dataSource.equals((Object)sourceHolder.source)) continue;
            if (sourceHolder.startIndex > l2 || sourceHolder.startIndex < l) {
                sourceHolder.reset();
                sourceHolder.startIndex = l;
            }
            if (this.holdersToUpdate == null) {
                this.holdersToUpdate = new ArrayList();
            }
            this.holdersToUpdate.add(sourceHolder);
            this.dirty = true;
            break;
        }
    }

    public void DataSourceInfoChanged(DataSource dataSource, DataInfo dataInfo) {
        this.dirty = true;
    }

    public void DataSourceValueRangeChanged(DataSource dataSource) {
    }

    public void DataSourceOrderChanged(DataSource dataSource, int n) {
    }

    public void notificationEnd(Object object) {
        if (this.dirty) {
            if (this.holdersToUpdate != null) {
                Iterator iterator = this.holdersToUpdate.iterator();
                while (iterator.hasNext()) {
                    SourceHolder sourceHolder = (SourceHolder)iterator.next();
                    sourceHolder.update();
                }
                this.holdersToUpdate = null;
            }
            this.dirty = false;
            this.fireDatasetChanged();
        }
    }

    public void classifierModified(CategoryClassifier categoryClassifier) {
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            ((SourceHolder)iterator.next()).needCompute = true;
        }
        this.fireDatasetChanged();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.sources.size();
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            SourceHolder sourceHolder = (SourceHolder)this.sources.get(i);
            DataSourcePool.global.writeDataSource(objectOutputStream, sourceHolder.source);
            objectOutputStream.writeLong(sourceHolder.startIndex);
            objectOutputStream.writeObject(sourceHolder.name);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.sources = new Vector();
        for (int i = 0; i < n; ++i) {
            SourceHolder sourceHolder = new SourceHolder(DataSourcePool.global.readDataSource(objectInputStream), objectInputStream.readLong());
            this.sources.add(sourceHolder);
            sourceHolder.name = (String)objectInputStream.readObject();
            if (sourceHolder.source == null) continue;
            sourceHolder.source.addListener((DataSourceListener)this);
            sourceHolder.source.addEndNotificationListener((EndNotificationListener)this);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SourceCategoryDataset sourceCategoryDataset = (SourceCategoryDataset)super.clone();
        sourceCategoryDataset.sources = new Vector();
        sourceCategoryDataset.info = DataInfo.clone((DataInfo)this.info);
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            SourceHolder sourceHolder = (SourceHolder)iterator.next();
            Vector vector = sourceCategoryDataset.sources;
            SourceCategoryDataset sourceCategoryDataset2 = sourceCategoryDataset;
            sourceCategoryDataset2.getClass();
            vector.add(sourceCategoryDataset2.new SourceHolder(sourceHolder.source, sourceHolder.startIndex, sourceHolder.name, sourceHolder.categoryCount, sourceHolder.needCompute));
            if (sourceHolder.source == null) continue;
            sourceHolder.source.addListener((DataSourceListener)sourceCategoryDataset);
            sourceHolder.source.addEndNotificationListener((EndNotificationListener)sourceCategoryDataset);
        }
        return sourceCategoryDataset;
    }

    public SourceCategoryDataset cloneSet() {
        try {
            return (SourceCategoryDataset)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public class SourceHolder
    implements Comparable {
        public DataSource source;
        public long startIndex;
        public String name;
        protected int[] categoryCount;
        public boolean needCompute;

        public SourceHolder(DataSource dataSource) {
            this(dataSource, 0L);
        }

        public SourceHolder(DataSource dataSource, long l) {
            this.source = dataSource;
            this.startIndex = l;
            this.needCompute = true;
        }

        public SourceHolder(DataSource dataSource, long l, String string, int[] nArray, boolean bl) {
            this.name = string;
            this.source = dataSource;
            this.startIndex = l;
            this.needCompute = bl;
            this.categoryCount = nArray;
        }

        public int compareTo(Object object) {
            SourceHolder sourceHolder = (SourceHolder)object;
            return SourceCategoryDataset.this.sources.indexOf(this) - SourceCategoryDataset.this.sources.indexOf(object);
        }

        public String toString() {
            if (this.name != null) {
                return this.name;
            }
            String string = DataInfo.getLabel((Object)this.source);
            if (string != null) {
                return string;
            }
            return super.toString();
        }

        public int getCategoryValue(String string) {
            return this.getCategoryValue(SourceCategoryDataset.this.classifier.categories.indexOf(string));
        }

        public int getCategoryValue(int n) {
            if (this.needCompute) {
                this.compute();
            }
            return this.categoryCount[n];
        }

        public void compute() {
            this.reset();
            try {
                this.startIndex = this.source.computeStartIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                try {
                    this.startIndex = this.source.getStartIndex();
                }
                catch (UnsupportedOperation unsupportedOperation2) {
                    this.startIndex = 0L;
                }
            }
            this.update();
            this.needCompute = false;
        }

        public void reset() {
            List list = SourceCategoryDataset.this.classifier.categories;
            this.categoryCount = new int[list.size()];
        }

        public void update() {
            List list = SourceCategoryDataset.this.classifier.categories;
            long l = this.startIndex;
            while (true) {
                int n;
                Object object;
                try {
                    object = this.source.getValue(l);
                }
                catch (DataException dataException) {
                    this.startIndex = l;
                    break;
                }
                String string = SourceCategoryDataset.this.classifier.getMapper().getString(object);
                if (string != null && (n = list.indexOf(string)) != -1) {
                    int n2 = n;
                    this.categoryCount[n2] = this.categoryCount[n2] + 1;
                }
                ++l;
            }
        }
    }
}

