/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ProtocolException;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.web.Base64;
import org.acplt.oncrpc.web.HttpClientConnection;

public class XdrHttpDecodingStream
extends XdrDecodingStream {
    private HttpClientConnection httpClient;
    private byte[] buffer;
    private int bufferSize;
    private byte[] asciiBuffer;
    private int asciiBufferSize;
    private int bufferIndex;
    private int bufferHighmark;

    public XdrHttpDecodingStream(HttpClientConnection httpClient) {
        this.httpClient = httpClient;
        int lines = 100;
        int bufferSize = lines * 48;
        int asciiBufferSize = lines * 66;
        this.buffer = new byte[bufferSize];
        this.bufferSize = bufferSize;
        this.asciiBuffer = new byte[asciiBufferSize];
        this.asciiBufferSize = asciiBufferSize;
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
    }

    public InetAddress getSenderAddress() {
        return null;
    }

    public int getSenderPort() {
        return 0;
    }

    public void beginDecoding() throws IOException, OncRpcException {
        this.httpClient.beginDecoding();
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
    }

    public void endDecoding() throws IOException, OncRpcException {
        try {
            this.httpClient.endDecoding();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
    }

    public void close() throws IOException, OncRpcException {
        this.httpClient = null;
        this.buffer = null;
    }

    private void fill() throws IOException, OncRpcException {
        int charsRead;
        try {
            int remaining = this.httpClient.getRemainingContentLength();
            charsRead = remaining < 0 ? this.httpClient.readContentBytes(this.asciiBuffer, 0, this.asciiBufferSize) : this.httpClient.readContentBytes(this.asciiBuffer, 0, remaining);
        }
        catch (ProtocolException e) {
            throw new OncRpcException(43);
        }
        int decoded = 0;
        int encoded = 0;
        while (charsRead > 0) {
            int toDecode = charsRead >= 64 ? 64 : charsRead - 2;
            decoded += Base64.decode((byte[])this.asciiBuffer, (int)encoded, (int)toDecode, (byte[])this.buffer, (int)decoded);
            encoded += toDecode + 2;
            charsRead -= toDecode + 2;
        }
        this.bufferIndex = 0;
        this.bufferHighmark = decoded - 4;
    }

    public int xdrDecodeInt() throws IOException, OncRpcException {
        if (this.bufferIndex > this.bufferHighmark) {
            this.fill();
        }
        int value = this.buffer[this.bufferIndex++] & 0xFF;
        value = (value << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
        value = (value << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
        value = (value << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
        return value;
    }

    public byte[] xdrDecodeOpaque(int length) throws IOException, OncRpcException {
        int padding = 4 - (length & 3) & 3;
        int offset = 0;
        byte[] bytes = new byte[length];
        if (this.bufferIndex > this.bufferHighmark) {
            this.fill();
        }
        while (length > 0) {
            int toCopy = this.bufferHighmark - this.bufferIndex + 4;
            if (toCopy >= length) {
                System.arraycopy(this.buffer, this.bufferIndex, bytes, offset, length);
                this.bufferIndex += length;
                break;
            }
            System.arraycopy(this.buffer, this.bufferIndex, bytes, offset, toCopy);
            this.bufferIndex += toCopy;
            offset += toCopy;
            length -= toCopy;
            this.fill();
        }
        this.bufferIndex += padding;
        return bytes;
    }

    public void xdrDecodeOpaque(byte[] opaque, int offset, int length) throws IOException, OncRpcException {
        int padding = 4 - (length & 3) & 3;
        if (this.bufferIndex > this.bufferHighmark) {
            this.fill();
        }
        while (length > 0) {
            int toCopy = this.bufferHighmark - this.bufferIndex + 4;
            if (toCopy >= length) {
                System.arraycopy(this.buffer, this.bufferIndex, opaque, offset, length);
                this.bufferIndex += length;
                break;
            }
            System.arraycopy(this.buffer, this.bufferIndex, opaque, offset, toCopy);
            this.bufferIndex += toCopy;
            offset += toCopy;
            length -= toCopy;
            this.fill();
        }
        this.bufferIndex += padding;
    }
}

