/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import simtools.data.DataSource;
import simtools.diagram.DiagramParameters;
import simtools.ui.ColorMapper;
import simtools.ui.DynamicColorChooser;
import simtools.ui.JPropertiesPanel;
import simtools.ui.NumberField;
import simtools.ui.ResourceFinder;

public class PropertiesPanel1D
extends JPropertiesPanel {
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$builtin$Abstract1DShape == null ? (class$jsynoptic$builtin$Abstract1DShape = PropertiesPanel1D.class$("jsynoptic.builtin.Abstract1DShape")) : class$jsynoptic$builtin$Abstract1DShape);
    protected JButton bdrawcolor;
    protected Color noColor;
    protected JCheckBox cbResize;
    protected JCheckBox cbRatio;
    protected JCheckBox cbdraw;
    protected JLabel lwidth;
    protected JLabel lheight;
    protected NumberField nfWidth;
    protected NumberField nfHeight;
    protected Color drawColor;
    protected ColorMapper drawMapper;
    protected transient DataSource drawMapperSource;
    private transient String[] mods = new String[]{"STROKE_COLOR", "ALLOW_RESIZE", "FIXED_RATIO", "WIDTH", "HEIGHT", "DRAW_MAPPER", "DRAW_MAPPER_SOURCE"};
    static /* synthetic */ Class class$jsynoptic$builtin$Abstract1DShape;

    public PropertiesPanel1D() {
        this.setLayout(new BorderLayout());
        this.add(this.createContent());
    }

    public PropertiesPanel1D(boolean bl, boolean bl2) {
        this.setLayout(new BorderLayout());
        this.add(this.createContent(bl, bl2));
    }

    public JComponent createContent() {
        return this.createContent(true);
    }

    public JComponent createContent(boolean bl) {
        return this.createContent(true, false);
    }

    public JComponent createContent(boolean bl, boolean bl2) {
        this.drawColor = Color.BLACK;
        this.drawMapper = null;
        this.drawMapperSource = null;
        Box box = Box.createVerticalBox();
        Box box2 = Box.createHorizontalBox();
        if (bl2) {
            this.cbdraw = new JCheckBox(this.lineColorLabel(), true);
            box2.add(this.cbdraw);
        } else {
            this.cbdraw = null;
            box2.add(new JLabel(this.lineColorLabel()));
        }
        box2.add(Box.createHorizontalGlue());
        this.bdrawcolor = new JButton("    ");
        box2.add(this.bdrawcolor);
        this.noColor = this.bdrawcolor.getBackground();
        this.bdrawcolor.setFocusPainted(false);
        this.bdrawcolor.setBackground(this.drawColor);
        box.add(box2);
        box2 = Box.createHorizontalBox();
        this.cbResize = new JCheckBox(resources.getString("AllowResize"), false);
        box2.add(this.cbResize);
        box2.add(Box.createHorizontalGlue());
        this.cbRatio = new JCheckBox(resources.getString("FixedRatio"), false);
        box2.add(this.cbRatio);
        if (bl) {
            box.add(box2);
        }
        box2 = Box.createHorizontalBox();
        this.lwidth = new JLabel(resources.getString("Width"));
        box2.add(this.lwidth);
        this.nfWidth = new NumberField(0);
        box2.add(this.nfWidth);
        this.nfWidth.setHorizontalAlignment(4);
        this.lheight = new JLabel(resources.getString("Height"));
        box2.add(this.lheight);
        this.nfHeight = new NumberField(0);
        box2.add(this.nfHeight);
        this.nfHeight.setHorizontalAlignment(4);
        if (bl) {
            box.add(box2);
        }
        this.bdrawcolor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = DynamicColorChooser.showDialog(null, PropertiesPanel1D.this.lineColorChooserTitle(), null, PropertiesPanel1D.this.drawColor, PropertiesPanel1D.this.drawMapperSource, PropertiesPanel1D.this.drawMapper);
                if (color == null) {
                    return;
                }
                PropertiesPanel1D.this.drawColor = color;
                PropertiesPanel1D.this.drawMapperSource = DynamicColorChooser.getSource();
                PropertiesPanel1D.this.drawMapper = DynamicColorChooser.getMapper();
                PropertiesPanel1D.this.bdrawcolor.setBackground(PropertiesPanel1D.this.drawColor);
                if (PropertiesPanel1D.this.cbdraw != null) {
                    PropertiesPanel1D.this.cbdraw.setSelected(true);
                }
            }
        });
        return box;
    }

    protected String lineColorLabel() {
        return resources.getString("LineColor");
    }

    protected String lineColorChooserTitle() {
        return resources.getString("ChooseLineColor");
    }

    public String[] getPropertyNames() {
        return this.mods;
    }

    public Object getPropertyValue(String string) {
        Object object = null;
        if (string.equalsIgnoreCase("STROKE_COLOR")) {
            object = this.cbdraw == null || this.cbdraw.isSelected() ? this.drawColor : null;
        } else if (string.equalsIgnoreCase("ALLOW_RESIZE")) {
            object = new Boolean(this.cbResize.isSelected());
        } else if (string.equalsIgnoreCase("FIXED_RATIO")) {
            object = new Boolean(this.cbRatio.isSelected());
        } else if (string.equalsIgnoreCase("WIDTH")) {
            object = new Integer((int)this.nfWidth.getLongValue());
        } else if (string.equalsIgnoreCase("HEIGHT")) {
            object = new Integer((int)this.nfHeight.getLongValue());
        } else if (string.equalsIgnoreCase("DRAW_MAPPER")) {
            object = this.drawMapper;
        } else if (string.equalsIgnoreCase("DRAW_MAPPER_SOURCE")) {
            object = this.drawMapperSource;
        }
        return object;
    }

    public void setPropertyValue(String string, Object object) {
        if (string.equalsIgnoreCase("STROKE_COLOR")) {
            if (object instanceof Color) {
                this.drawColor = (Color)object;
                if (this.cbdraw != null) {
                    this.cbdraw.setSelected(true);
                }
            } else {
                this.drawColor = DiagramParameters.DEFAULT_COLOR;
                if (this.cbdraw != null) {
                    this.cbdraw.setSelected(false);
                }
            }
            this.bdrawcolor.setBackground(this.drawColor);
        } else if (string.equalsIgnoreCase("ALLOW_RESIZE")) {
            if (object instanceof Boolean) {
                this.cbResize.setSelected((Boolean)object);
            }
        } else if (string.equalsIgnoreCase("FIXED_RATIO")) {
            if (object instanceof Boolean) {
                this.cbRatio.setSelected((Boolean)object);
            }
        } else if (string.equalsIgnoreCase("WIDTH")) {
            if (object instanceof Integer) {
                this.nfWidth.setValue(((Integer)object).intValue());
            }
        } else if (string.equalsIgnoreCase("HEIGHT")) {
            if (object instanceof Integer) {
                this.nfHeight.setValue(((Integer)object).intValue());
            }
        } else if (string.equalsIgnoreCase("DRAW_MAPPER")) {
            if (object instanceof ColorMapper) {
                this.drawMapper = (ColorMapper)object;
            }
        } else if (string.equalsIgnoreCase("DRAW_MAPPER_SOURCE") && object instanceof DataSource) {
            this.drawMapperSource = (DataSource)object;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

