/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import jsynoptic.builtin.GaussianRandomSource;
import jsynoptic.builtin.RandomSource;
import jsynoptic.builtin.UniformRandomSource;
import simtools.data.DataSource;
import simtools.data.DataSourceCollection;
import simtools.data.DataSourcePool;
import simtools.data.DataSourceProvider;

public class RandomSourceProvider
implements DataSourceProvider {
    public Object getOptionalInformation(DataSource dataSource, DataSourceCollection dataSourceCollection) {
        if (!(dataSource instanceof RandomSource)) {
            return null;
        }
        RandomSource randomSource = (RandomSource)dataSource;
        Double d = new Double(randomSource.param1);
        Double d2 = new Double(randomSource.param2);
        String string = randomSource.getInformation().label;
        Long l = randomSource.seed;
        Long l2 = new Long(randomSource.maxIndex + 1L);
        return new Object[]{string, l, d, d2, l2};
    }

    public DataSource provide(String string, String string2, Object object, DataSourcePool dataSourcePool) {
        if (!string.startsWith("GaussianRandomSource:") && !string.startsWith("UniformRandomSource:")) {
            return null;
        }
        if (!(object instanceof Object[])) {
            return null;
        }
        Object[] objectArray = (Object[])object;
        if (objectArray.length != 5) {
            return null;
        }
        RandomSource randomSource = null;
        if (string.startsWith("GaussianRandomSource:")) {
            randomSource = objectArray[1] == null ? new GaussianRandomSource((String)objectArray[0], (Double)objectArray[2], (double)((Double)objectArray[3]), (Long)objectArray[4]) : new GaussianRandomSource((String)objectArray[0], (Long)objectArray[1], (Double)objectArray[2], (Double)objectArray[3], (Long)objectArray[4]);
        } else if (string.startsWith("UniformRandomSource:")) {
            randomSource = objectArray[1] == null ? new UniformRandomSource((String)objectArray[0], (Double)objectArray[2], (double)((Double)objectArray[3]), (Long)objectArray[4]) : new UniformRandomSource((String)objectArray[0], (Long)objectArray[1], (Double)objectArray[2], (Double)objectArray[3], (Long)objectArray[4]);
        }
        if (dataSourcePool != null) {
            dataSourcePool.addDataSource(randomSource);
        }
        return randomSource;
    }
}

