/* $Id: TspSimpleSessionImpl.java,v 1.3 2005/07/02 13:38:50 erk Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : Consumer
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : 
 * 
 * -----------------------------------------------------------------------
 */
package tsp.core.consumer.simple;

import java.util.NoSuchElementException;

import tsp.core.common.TspAnswerSample;
import tsp.core.common.TspRequestSample;
import tsp.core.common.TspSample;
import tsp.core.consumer.TspConsumer;
import tsp.core.consumer.TspConsumerException;
import tsp.core.consumer.TspSession;
import tsp.core.rpc.TSP_sample_symbol_info_list_t;

public class TspSimpleSessionImpl implements TspSimpleSession {
	
	private int sessionId;
	private TspConsumer complexConsumer;
	private TspSession complexSession;
	private TspSimpleSample sample = new TspSimpleSample();
		
	/**
	 * @param sessionId
	 * @param complexConsumer
	 * @param complexSession
	 */
	TspSimpleSessionImpl(int sessionId, TspConsumer complexConsumer,
			TspSession complexSession) {
		super();
		this.sessionId = sessionId;
		this.complexConsumer = complexConsumer;
		this.complexSession = complexSession;
	}
	
    public TspSimpleAnswerSample requestInfos() throws TspConsumerException {
    	TspAnswerSample requestInfo = complexConsumer.requestInfos(sessionId);
    	return new TspSimpleAnswerSample(requestInfo);
    }

    /**
	 * Send a TSP request sample on an opened session.
	 * @req the TSP request Sample
	 */
	public TspSimpleAnswerSample requestSample(TspSimpleRequestSample req) throws TspConsumerException {
		
		int[] fw = { 0, 0, 0, 0 }; /* not used */

		TspRequestSample rqs =
			new TspRequestSample(
					complexSession.answerOpen.theAnswer.version_id,
					complexSession.answerOpen.theAnswer.channel_id,
				fw,
				1,
				new TSP_sample_symbol_info_list_t());

		rqs.setTspSSIArray(req.createInfo_tArray());
		
		return new TspSimpleAnswerSample(complexSession.requestSample(rqs));
	}
	
	/**
	 * Send a TSP request sample Init on an opened session.
	 * This ask for beginning the sample process and 
	 * to open the socket for receiving sample.
	 */
	public void requestSampleInit() throws TspConsumerException {
		complexSession.requestSampleInit();
	}
	
	public void requestSampleFinalize() throws TspConsumerException {
		complexSession.requestSampleFinalize();
	}
	
	 public TspSimpleSample getSample() throws NoSuchElementException {
	 	TspSample complexSample = complexSession.getSampleSet().getSample();
	 	sample.setIndex(complexSample.provider_global_index);
	 	sample.setValue(complexSample.value);
		return sample;
	}

	
	public void waitForData(){
		// Ouch ! to be replaced by wait/notify
		while (complexSession.getSampleSet().nbSample() == 0) {
			System.out.print(".");
			try {
				Thread.sleep(100);
			}
			catch (InterruptedException e) {				
			}
		}
	}
	
	public boolean isDataAvailable(){
		return !(complexSession.getSampleSet().nbSample() == 0);
	}
	
	/**
	 * Close the session
	 * @throws TspConsumerException
	 */
	public void close() throws TspConsumerException{
		complexConsumer.closeSession(sessionId);
	}
}
