/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcDumpResult;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcGetPortResult;
import org.acplt.oncrpc.OncRpcProgramNotRegisteredException;
import org.acplt.oncrpc.OncRpcServerIdent;
import org.acplt.oncrpc.OncRpcTcpClient;
import org.acplt.oncrpc.OncRpcUdpClient;
import org.acplt.oncrpc.XdrBoolean;
import org.acplt.oncrpc.XdrVoid;

public class OncRpcPortmapClient {
    public static final int PMAP_PORT = 111;
    public static final int PMAP_PROGRAM = 100000;
    public static final int PMAP_VERSION = 2;
    protected OncRpcClient portmapClient;

    public OncRpcPortmapClient(InetAddress host) throws IOException, OncRpcException {
        this(host, 17, 0);
    }

    public OncRpcPortmapClient(InetAddress host, int protocol) throws IOException, OncRpcException {
        this(host, protocol, -1);
    }

    public OncRpcPortmapClient(InetAddress host, int protocol, int timeout) throws IOException, OncRpcException {
        switch (protocol) {
            case 17: {
                this.portmapClient = new OncRpcUdpClient(host, 100000, 2, 111);
                break;
            }
            case 6: {
                this.portmapClient = new OncRpcTcpClient(host, 100000, 2, 111, 0, timeout);
                break;
            }
            default: {
                throw new OncRpcException(17);
            }
        }
    }

    public void close() throws OncRpcException {
        this.portmapClient.close();
    }

    public OncRpcClient getOncRpcClient() {
        return this.portmapClient;
    }

    public int getPort(int program, int version, int protocol) throws OncRpcException {
        OncRpcServerIdent params = new OncRpcServerIdent(program, version, protocol, 0);
        OncRpcGetPortResult result = new OncRpcGetPortResult();
        try {
            this.portmapClient.call(3, params, result);
        }
        catch (OncRpcException e) {
            throw new OncRpcException(14);
        }
        if (result.port == 0) {
            throw new OncRpcProgramNotRegisteredException();
        }
        return result.port;
    }

    public boolean setPort(int program, int version, int protocol, int port) throws OncRpcException {
        OncRpcServerIdent params = new OncRpcServerIdent(program, version, protocol, port);
        XdrBoolean result = new XdrBoolean(false);
        try {
            this.portmapClient.call(1, params, result);
        }
        catch (OncRpcException e) {
            throw new OncRpcException(14);
        }
        return result.booleanValue();
    }

    public boolean unsetPort(int program, int version) throws OncRpcException {
        OncRpcServerIdent params = new OncRpcServerIdent(program, version, 0, 0);
        XdrBoolean result = new XdrBoolean(false);
        try {
            this.portmapClient.call(2, params, result);
        }
        catch (OncRpcException e) {
            throw new OncRpcException(14);
        }
        return result.booleanValue();
    }

    public OncRpcServerIdent[] listServers() throws OncRpcException {
        OncRpcDumpResult result = new OncRpcDumpResult();
        try {
            this.portmapClient.call(4, XdrVoid.XDR_VOID, result);
        }
        catch (OncRpcException e) {
            throw new OncRpcException(14);
        }
        Object[] info = new OncRpcServerIdent[result.servers.size()];
        result.servers.copyInto(info);
        return info;
    }

    public void ping() throws OncRpcException {
        try {
            this.portmapClient.call(0, XdrVoid.XDR_VOID, XdrVoid.XDR_VOID);
        }
        catch (OncRpcException e) {
            throw new OncRpcException(14);
        }
    }

    static {
        PMAP_PORT = 111;
        PMAP_PROGRAM = 100000;
        PMAP_VERSION = 2;
    }
}

