/*
 * Decompiled with CFR 0.152.
 */
package simtools.shapes;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import simtools.shapes.AbstractShape;

public class LabelShape
extends AbstractShape
implements Serializable,
Cloneable {
    static final long serialVersionUID = 8487155681626070280L;
    protected static final AffineTransform _trv = new AffineTransform(0.0, 1.0, -1.0, 0.0, 0.0, 0.0);
    protected static final FontRenderContext _frch = new FontRenderContext(new AffineTransform(), true, false);
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int CENTER = 2;
    public static final int LEFTUP = 4;
    public static final int RIGHTUP = 5;
    public static final int CENTERUP = 6;
    public static final int LEFTDOWN = 8;
    public static final int RIGHTDOWN = 9;
    public static final int CENTERDOWN = 10;
    protected int anchorSide;
    protected boolean vertical;
    protected String text;
    protected Font font;

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public int getAnchorSide() {
        return this.anchorSide;
    }

    public void setAnchorSide(int n) {
        this.anchorSide = n;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean bl) {
        this.vertical = bl;
    }

    public LabelShape(String string, int n, int n2, int n3, boolean bl) {
        super(n, n2);
        this.anchorSide = n3;
        this.vertical = bl;
        this.text = string;
        this.font = null;
    }

    public void setSide(int n) {
        this.anchorSide = n;
    }

    public int getSide() {
        return this.anchorSide;
    }

    public void setString(String string) {
        this.text = string;
    }

    public String getString() {
        return this.text;
    }

    public void setBounds(Font font) {
        if (this.text == null) {
            return;
        }
        this.font = font;
        Rectangle2D rectangle2D = font.getStringBounds(this.text, _frch);
        if (this.vertical) {
            this._h = (int)rectangle2D.getWidth();
            this._w = (int)rectangle2D.getHeight();
            switch (this.anchorSide) {
                case 0: {
                    this._x = -this._w / 2;
                    this._y = 0;
                    break;
                }
                case 1: {
                    this._x = -this._w / 2;
                    this._y = this._h;
                    break;
                }
                case 2: {
                    this._x = -this._w / 2;
                    this._y = this._h / 2;
                    break;
                }
                case 4: {
                    this._x = 0;
                    this._y = 0;
                    break;
                }
                case 5: {
                    this._x = 0;
                    this._y = this._h;
                    break;
                }
                case 6: {
                    this._x = 0;
                    this._y = this._h / 2;
                    break;
                }
                case 8: {
                    this._x = -this._w;
                    this._y = 0;
                    break;
                }
                case 9: {
                    this._x = -this._w;
                    this._y = this._h;
                    break;
                }
                case 10: {
                    this._x = -this._w;
                    this._y = this._h / 2;
                }
            }
        } else {
            this._w = (int)rectangle2D.getWidth();
            this._h = (int)rectangle2D.getHeight();
            switch (this.anchorSide) {
                case 0: {
                    this._x = -this._w;
                    this._y = this._h / 2;
                    break;
                }
                case 1: {
                    this._x = 0;
                    this._y = this._h / 2;
                    break;
                }
                case 2: {
                    this._x = -this._w / 2;
                    this._y = this._h / 2;
                    break;
                }
                case 4: {
                    this._x = -this._w;
                    this._y = 0;
                    break;
                }
                case 5: {
                    this._x = 0;
                    this._y = 0;
                    break;
                }
                case 6: {
                    this._x = -this._w / 2;
                    this._y = 0;
                    break;
                }
                case 8: {
                    this._x = -this._w;
                    this._y = this._h;
                    break;
                }
                case 9: {
                    this._x = 0;
                    this._y = this._h;
                    break;
                }
                case 10: {
                    this._x = -this._w / 2;
                    this._y = this._h;
                }
            }
        }
    }

    public void draw(Graphics2D graphics2D) {
        if (this.text == null) {
            return;
        }
        Font font = graphics2D.getFont();
        if (this.font == null) {
            this.setBounds(font);
        }
        graphics2D.setFont(this.font);
        AffineTransform affineTransform = null;
        if (this.vertical) {
            affineTransform = graphics2D.getTransform();
            graphics2D.transform(_trv);
            this.drawText(graphics2D, this._oy + this._y - this._h, -this._ox - this._x, this._h, this._w);
            graphics2D.setTransform(affineTransform);
        } else {
            this.drawText(graphics2D, this._ox + this._x, this._oy + this._y, this._w, this._h);
        }
        graphics2D.setFont(font);
    }

    public static void draw(Graphics2D graphics2D, LabelShape[] labelShapeArray) {
        AffineTransform affineTransform = null;
        if (labelShapeArray[0].vertical) {
            affineTransform = graphics2D.getTransform();
            graphics2D.transform(_trv);
        }
        for (int i = 0; i < labelShapeArray.length; ++i) {
            if (labelShapeArray[i].vertical) {
                labelShapeArray[i].drawText(graphics2D, labelShapeArray[i]._oy + labelShapeArray[i]._y - labelShapeArray[i]._h, -labelShapeArray[i]._ox - labelShapeArray[i]._x, labelShapeArray[i]._h, labelShapeArray[i]._w);
                continue;
            }
            labelShapeArray[i].drawText(graphics2D, labelShapeArray[i]._ox + labelShapeArray[i]._x, labelShapeArray[i]._oy + labelShapeArray[i]._y, labelShapeArray[i]._w, labelShapeArray[i]._h);
        }
        if (labelShapeArray[0].vertical) {
            graphics2D.setTransform(affineTransform);
        }
    }

    protected void drawText(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.drawString(this.text, n, n2);
    }
}

