/*
 * Decompiled with CFR 0.152.
 */
package simtools.shapes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.io.Serializable;
import java.text.Format;
import simtools.diagram.Resizable;
import simtools.shapes.AbstractShape;
import simtools.shapes.AxisLabelFormatter;
import simtools.shapes.LabelShape;

public class AxisShape
extends AbstractShape
implements Serializable,
Cloneable,
Resizable {
    static final long serialVersionUID = 2776298686196507458L;
    private static Font _defaultFont = new Font("TimesRoman", 0, 10);
    protected static Stroke gridStroke = new BasicStroke(0.4f);
    protected static Color gridColor = Color.gray;
    protected static int _defaultTickLength = 5;
    protected static int _defaultTickSpace = 1;
    protected boolean _isVertical;
    protected boolean _valuesFirst;
    protected boolean _withGridlines;
    protected boolean _withValues;
    protected Font _font;
    protected Format _format;
    protected Color _color;
    protected LabelShape _label;
    protected double _min;
    protected double _max;
    protected double _step;
    protected LabelShape[] _gridValues;
    protected int[] _gridPos;
    protected int _gridZeroIndex;
    protected double _gridOffset;
    protected int _lineWidth;
    protected int _lineHeight;

    public AxisShape(boolean bl, boolean bl2, int n, int n2, int n3, int n4) {
        super(n, n2);
        this._isVertical = bl;
        this._valuesFirst = bl2;
        this._withGridlines = false;
        this._withValues = true;
        this._font = _defaultFont;
        this._format = null;
        this._color = Color.black;
        this._label = null;
        this._lineWidth = n3;
        this._lineHeight = n4;
        this._gridValues = null;
        this._gridPos = null;
        this._gridZeroIndex = -1;
        this.set(0.0, 0.0, 0.0);
    }

    protected AbstractShape cloneShape() {
        AxisShape axisShape = null;
        try {
            axisShape = (AxisShape)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        if (axisShape._label != null) {
            axisShape._label = (LabelShape)axisShape._label.cloneShape();
        }
        axisShape._gridValues = null;
        axisShape.set(axisShape._min, axisShape._max, axisShape._step);
        return axisShape;
    }

    public void setWithGridlines(boolean bl) {
        this._withGridlines = bl;
    }

    public boolean isWithGridlines() {
        return this._withGridlines;
    }

    public void setWithValues(boolean bl) {
        if (bl != this._withValues) {
            this._withValues = bl;
            this.computeBounds();
        }
    }

    public boolean isWithValues() {
        return this._withValues;
    }

    public void setLabel(String string) {
        if (string == null || string.trim().equals("")) {
            if (this._label != null) {
                this._label = null;
                this.computeBounds();
            }
        } else {
            if (this._label == null) {
                this._label = new LabelShape(string, 0, 0, this._valuesFirst ? 6 : 10, this._isVertical);
            } else {
                this._label.setString(string);
            }
            this.computeBounds();
        }
    }

    public void setFont(Font font) {
        if (font != this._font) {
            this._font = font;
            this.computeBounds();
        }
    }

    public void setFormat(Format format) {
        if (format != this._format) {
            this._format = format;
            this.computeBounds();
        }
    }

    public void setColor(Color color) {
        this._color = color;
    }

    public void resize(int n, int n2) {
        this._lineWidth += n;
        this._lineHeight += n2;
        if (this._lineWidth < 1) {
            this._lineWidth = 1;
        }
        if (this._lineHeight < 1) {
            this._lineHeight = 1;
        }
        this.computeBounds();
    }

    public void setAnchor(int n, int n2) {
        int n3 = n - this._ox;
        int n4 = n2 - this._oy;
        this.translate(n3, n4);
    }

    public void translate(int n, int n2) {
        super.translate(n, n2);
        for (int i = 0; i < this._gridValues.length; ++i) {
            this._gridValues[i].translate(n, n2);
            int n3 = i;
            this._gridPos[n3] = this._gridPos[n3] + (this._isVertical ? n2 : n);
        }
        if (this._label != null) {
            this._label.translate(n, n2);
        }
    }

    public void set(double d, double d2) {
        this.set(d, d2, this.computeStep(d, d2));
    }

    public void set(double d, double d2, double d3) {
        int n;
        int n2;
        this._min = Math.min(d, d2);
        this._max = Math.max(d, d2);
        this._step = Math.abs(d3);
        if (this._min < 0.0 && this._max > 0.0) {
            n2 = (int)Math.floor(this._max / this._step);
            int n3 = (int)Math.floor(Math.abs(this._min) / this._step);
            n = n2 + n3 + 1;
            this._gridOffset = (double)(-n3) * this._step;
            this._gridZeroIndex = n3;
        } else {
            n = (int)Math.floor((this._max - this._min) / this._step);
            if ((double)n * d3 == this._max - this._min) {
                ++n;
            }
            this._gridOffset = this._min;
            this._gridZeroIndex = -1;
        }
        if (this._gridValues == null || this._gridValues.length != n) {
            this.createLabels(n);
        }
        for (n2 = 0; n2 < n; ++n2) {
            double d4 = this._gridOffset + (double)n2 * this._step;
            if (this._format != null) {
                this._gridValues[n2].setString(this._format.format(new Double(d4)));
                continue;
            }
            this._gridValues[n2].setString(AxisLabelFormatter.labelFormat(d4));
        }
        this.computeBounds();
    }

    public double getMin() {
        return this._min;
    }

    public double getMax() {
        return this._max;
    }

    public double getStep() {
        return this._step;
    }

    public double getScale() {
        if (this._max == this._min) {
            return 0.0;
        }
        if (this._isVertical) {
            return (double)this._lineHeight / (this._max - this._min);
        }
        return (double)this._lineWidth / (this._max - this._min);
    }

    public void draw(Graphics2D graphics2D) {
        Color color;
        Stroke stroke;
        int n;
        int n2;
        int n3;
        int n4;
        graphics2D.setColor(this._color);
        if (this._isVertical) {
            n4 = this._withGridlines ? this._lineWidth : 0;
            n3 = this._valuesFirst ? this._ox : this._ox + this._lineWidth;
            graphics2D.drawLine(n3, this._oy, n3, this._oy - this._lineHeight);
            for (n2 = 0; n2 < this._gridValues.length; ++n2) {
                int n5 = n = n2 == this._gridZeroIndex ? this._lineWidth : n4;
                if (this._valuesFirst) {
                    graphics2D.drawLine(n3 - _defaultTickLength, this._gridPos[n2], n3, this._gridPos[n2]);
                    if (n <= 0) continue;
                    stroke = graphics2D.getStroke();
                    color = graphics2D.getColor();
                    if (n2 != this._gridZeroIndex) {
                        graphics2D.setStroke(gridStroke);
                    }
                    graphics2D.setColor(gridColor);
                    graphics2D.drawLine(n3, this._gridPos[n2], n3 + n, this._gridPos[n2]);
                    graphics2D.setColor(color);
                    graphics2D.setStroke(stroke);
                    continue;
                }
                graphics2D.drawLine(n3 + _defaultTickLength, this._gridPos[n2], n3, this._gridPos[n2]);
                if (n <= 0) continue;
                stroke = graphics2D.getStroke();
                color = graphics2D.getColor();
                if (n2 != this._gridZeroIndex) {
                    graphics2D.setStroke(gridStroke);
                }
                graphics2D.setColor(gridColor);
                graphics2D.drawLine(n3, this._gridPos[n2], n3 - n, this._gridPos[n2]);
                graphics2D.setColor(color);
                graphics2D.setStroke(stroke);
            }
        } else {
            n4 = this._withGridlines ? this._lineHeight : 0;
            n3 = this._valuesFirst ? this._oy : this._oy - this._lineHeight;
            graphics2D.drawLine(this._ox, n3, this._ox + this._lineWidth, n3);
            for (n2 = 0; n2 < this._gridValues.length; ++n2) {
                int n6 = n = n2 == this._gridZeroIndex ? this._lineHeight : n4;
                if (this._valuesFirst) {
                    graphics2D.drawLine(this._gridPos[n2], n3 + _defaultTickLength, this._gridPos[n2], n3);
                    if (n <= 0) continue;
                    stroke = graphics2D.getStroke();
                    color = graphics2D.getColor();
                    if (n2 != this._gridZeroIndex) {
                        graphics2D.setStroke(gridStroke);
                    }
                    graphics2D.setColor(gridColor);
                    graphics2D.drawLine(this._gridPos[n2], n3, this._gridPos[n2], n3 - n);
                    graphics2D.setColor(color);
                    graphics2D.setStroke(stroke);
                    continue;
                }
                graphics2D.drawLine(this._gridPos[n2], n3 - _defaultTickLength, this._gridPos[n2], n3);
                if (n <= 0) continue;
                stroke = graphics2D.getStroke();
                color = graphics2D.getColor();
                if (n2 != this._gridZeroIndex) {
                    graphics2D.setStroke(gridStroke);
                }
                graphics2D.setColor(gridColor);
                graphics2D.drawLine(this._gridPos[n2], n3, this._gridPos[n2], n3 + n);
                graphics2D.setColor(color);
                graphics2D.setStroke(stroke);
            }
        }
        if (this._withValues) {
            for (n2 = 0; n2 < this._gridValues.length; ++n2) {
                this._gridValues[n2].draw(graphics2D);
            }
        }
        if (this._label != null) {
            this._label.draw(graphics2D);
        }
    }

    private void createLabels(int n) {
        this._gridValues = new LabelShape[n];
        this._gridPos = new int[n];
        int n2 = this._valuesFirst ? (this._isVertical ? 0 : 1) : (this._isVertical ? 1 : 0);
        for (int i = 0; i < n; ++i) {
            this._gridValues[i] = new LabelShape("", 0, 0, n2, !this._isVertical);
            this._gridPos[i] = 0;
        }
    }

    protected void computeBounds() {
        Point point = new Point(0, 0);
        Point point2 = new Point(0, 0);
        Point point3 = new Point(0, 0);
        Rectangle rectangle = null;
        if (this._withValues) {
            for (int i = 0; i < this._gridValues.length; ++i) {
                LabelShape labelShape = this._gridValues[i];
                labelShape.setAnchor(point);
                labelShape.setBounds(this._font);
                labelShape.getMax(point3);
                labelShape.getMin(point2);
            }
        }
        if (this._label != null) {
            this._label.setAnchor(point);
            this._label.setBounds(this._font);
            rectangle = this._label.getBounds();
        }
        if (this._isVertical) {
            this._w = this._lineWidth + (point3.x - point2.x + _defaultTickLength + _defaultTickSpace);
            if (rectangle != null) {
                this._w += rectangle.width;
            }
            this._x = this._valuesFirst ? this._lineWidth - this._w : 0;
            this._h = this._lineHeight + (point3.y - point2.y);
            this._y = (this._h - this._lineHeight) / 2;
            if (this._label != null) {
                if (this._valuesFirst) {
                    this._label.translate(this._ox + this._x, this._oy + this._y - this._h / 2);
                } else {
                    this._label.translate(this._ox + this._x + this._w, this._oy + this._y - this._h / 2);
                }
            }
        } else {
            this._h = this._lineHeight + (point3.y - point2.y + _defaultTickLength + _defaultTickSpace);
            if (rectangle != null) {
                this._h += rectangle.height;
            }
            this._y = this._valuesFirst ? this._h - this._lineHeight : 0;
            this._w = this._lineWidth + (point3.x - point2.x);
            this._x = -(this._w - this._lineWidth) / 2;
            if (this._label != null) {
                if (this._valuesFirst) {
                    this._label.translate(this._ox + this._x + this._w / 2, this._oy + this._y);
                } else {
                    this._label.translate(this._ox + this._x + this._w / 2, this._oy + this._y - this._h);
                }
            }
        }
        double d = this.getScale();
        int n = (int)Math.floor(this._min * d);
        for (int i = 0; i < this._gridValues.length; ++i) {
            int n2 = (int)Math.floor((this._gridOffset + this._step * (double)i) * d);
            if (this._isVertical) {
                this._gridPos[i] = this._oy - n2 + n;
                if (this._valuesFirst) {
                    this._gridValues[i].translate(this._ox - _defaultTickLength - _defaultTickSpace, this._gridPos[i]);
                    continue;
                }
                this._gridValues[i].translate(this._ox + this._lineWidth + _defaultTickLength + _defaultTickSpace, this._gridPos[i]);
                continue;
            }
            this._gridPos[i] = this._ox + n2 - n;
            if (this._valuesFirst) {
                this._gridValues[i].translate(this._gridPos[i], this._oy + _defaultTickLength + _defaultTickSpace);
                continue;
            }
            this._gridValues[i].translate(this._gridPos[i], this._oy - this._lineHeight - _defaultTickLength - _defaultTickSpace);
        }
    }

    protected double computeStep(double d, double d2) {
        double d3 = Math.abs(d2 - d);
        double d4 = d3 / 9.0;
        double d5 = Math.log(10.0);
        double d6 = Math.floor(Math.log(d4 / 0.75) / d5);
        double d7 = Math.exp(d6 * d5);
        double d8 = d4 / d7;
        int n = 2;
        if (d8 < 1.5) {
            n = 1;
        } else if (d8 >= 3.5) {
            n = 5;
        }
        double d9 = (double)n * d7;
        return Math.rint(d9 * 1000000.0) / 1000000.0;
    }
}

